/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial3d;

class Geo3DUtil {
    Geo3DUtil() {
    }

    public static int encodeValueLenient(double planetMax, double x) {
        if (x > planetMax) {
            x = planetMax;
        } else if (x < -planetMax) {
            x = -planetMax;
        }
        return Geo3DUtil.encodeValue(planetMax, x);
    }

    public static int encodeValue(double planetMax, double x) {
        if (x > planetMax) {
            throw new IllegalArgumentException("value=" + x + " is out-of-bounds (greater than planetMax=" + planetMax + ")");
        }
        if (x < -planetMax) {
            throw new IllegalArgumentException("value=" + x + " is out-of-bounds (less than than -planetMax=" + -planetMax + ")");
        }
        long y = Math.round(x * (2.147483647E9 / planetMax));
        assert (y >= Integer.MIN_VALUE);
        assert (y <= Integer.MAX_VALUE);
        return (int)y;
    }

    public static double decodeValueCenter(double planetMax, int x) {
        return (double)x * (planetMax / 2.147483647E9);
    }

    public static double decodeValueMin(double planetMax, int x) {
        return ((double)x - 0.5) * (planetMax / 2.147483647E9);
    }

    public static double decodeValueMax(double planetMax, int x) {
        return ((double)x + 0.5) * (planetMax / 2.147483647E9);
    }
}

