/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial3d.geom;

import org.apache.lucene.spatial3d.geom.Bounds;
import org.apache.lucene.spatial3d.geom.GeoPoint;
import org.apache.lucene.spatial3d.geom.Membership;
import org.apache.lucene.spatial3d.geom.Plane;
import org.apache.lucene.spatial3d.geom.PlanetModel;

public class XYZBounds
implements Bounds {
    protected static final double FUDGE_FACTOR = 2.0E-12;
    protected Double minX = null;
    protected Double maxX = null;
    protected Double minY = null;
    protected Double maxY = null;
    protected Double minZ = null;
    protected Double maxZ = null;
    protected boolean noLongitudeBound = false;
    protected boolean noTopLatitudeBound = false;
    protected boolean noBottomLatitudeBound = false;

    public Double getMinimumX() {
        return this.minX;
    }

    public Double getMaximumX() {
        return this.maxX;
    }

    public Double getMinimumY() {
        return this.minY;
    }

    public Double getMaximumY() {
        return this.maxY;
    }

    public Double getMinimumZ() {
        return this.minZ;
    }

    public Double getMaximumZ() {
        return this.maxZ;
    }

    public boolean isSmallestMinX(PlanetModel planetModel) {
        if (this.minX == null) {
            return false;
        }
        return this.minX - planetModel.getMinimumXValue() < 1.0E-12;
    }

    public boolean isLargestMaxX(PlanetModel planetModel) {
        if (this.maxX == null) {
            return false;
        }
        return planetModel.getMaximumXValue() - this.maxX < 1.0E-12;
    }

    public boolean isSmallestMinY(PlanetModel planetModel) {
        if (this.minY == null) {
            return false;
        }
        return this.minY - planetModel.getMinimumYValue() < 1.0E-12;
    }

    public boolean isLargestMaxY(PlanetModel planetModel) {
        if (this.maxY == null) {
            return false;
        }
        return planetModel.getMaximumYValue() - this.maxY < 1.0E-12;
    }

    public boolean isSmallestMinZ(PlanetModel planetModel) {
        if (this.minZ == null) {
            return false;
        }
        return this.minZ - planetModel.getMinimumZValue() < 1.0E-12;
    }

    public boolean isLargestMaxZ(PlanetModel planetModel) {
        if (this.maxZ == null) {
            return false;
        }
        return planetModel.getMaximumZValue() - this.maxZ < 1.0E-12;
    }

    @Override
    public Bounds addPlane(PlanetModel planetModel, Plane plane, Membership ... bounds) {
        plane.recordBounds(planetModel, this, bounds);
        return this;
    }

    @Override
    public Bounds addHorizontalPlane(PlanetModel planetModel, double latitude, Plane horizontalPlane, Membership ... bounds) {
        return this.addPlane(planetModel, horizontalPlane, bounds);
    }

    @Override
    public Bounds addVerticalPlane(PlanetModel planetModel, double longitude, Plane verticalPlane, Membership ... bounds) {
        return this.addPlane(planetModel, verticalPlane, bounds);
    }

    @Override
    public Bounds addXValue(GeoPoint point) {
        double x = point.x;
        double small = x - 2.0E-12;
        if (this.minX == null || this.minX > small) {
            this.minX = new Double(small);
        }
        double large = x + 2.0E-12;
        if (this.maxX == null || this.maxX < large) {
            this.maxX = new Double(large);
        }
        return this;
    }

    @Override
    public Bounds addYValue(GeoPoint point) {
        double y = point.y;
        double small = y - 2.0E-12;
        if (this.minY == null || this.minY > small) {
            this.minY = new Double(small);
        }
        double large = y + 2.0E-12;
        if (this.maxY == null || this.maxY < large) {
            this.maxY = new Double(large);
        }
        return this;
    }

    @Override
    public Bounds addZValue(GeoPoint point) {
        double z = point.z;
        double small = z - 2.0E-12;
        if (this.minZ == null || this.minZ > small) {
            this.minZ = new Double(small);
        }
        double large = z + 2.0E-12;
        if (this.maxZ == null || this.maxZ < large) {
            this.maxZ = new Double(large);
        }
        return this;
    }

    @Override
    public Bounds addPoint(GeoPoint point) {
        return this.addXValue(point).addYValue(point).addZValue(point);
    }

    @Override
    public Bounds isWide() {
        return this;
    }

    @Override
    public Bounds noLongitudeBound() {
        return this;
    }

    @Override
    public Bounds noTopLatitudeBound() {
        return this;
    }

    @Override
    public Bounds noBottomLatitudeBound() {
        return this;
    }
}

