/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.vector;

import com.spatial4j.core.distance.DistanceCalculator;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.simple.PointImpl;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.spatial.vector.TwoDoublesFieldInfo;
import org.apache.lucene.util.Bits;

public class DistanceValueSource
extends ValueSource {
    private final TwoDoublesFieldInfo fields;
    private final DistanceCalculator calculator;
    private final Point from;
    private final FieldCache.DoubleParser parser;

    public DistanceValueSource(Point from, DistanceCalculator calc, TwoDoublesFieldInfo fields, FieldCache.DoubleParser parser) {
        this.from = from;
        this.fields = fields;
        this.calculator = calc;
        this.parser = parser;
    }

    public String description() {
        return "DistanceValueSource(" + this.calculator + ")";
    }

    public FunctionValues getValues(Map context, AtomicReaderContext readerContext) throws IOException {
        AtomicReader reader = readerContext.reader();
        final double[] ptX = FieldCache.DEFAULT.getDoubles(reader, this.fields.getFieldNameX(), true);
        final double[] ptY = FieldCache.DEFAULT.getDoubles(reader, this.fields.getFieldNameY(), true);
        final Bits validX = FieldCache.DEFAULT.getDocsWithField(reader, this.fields.getFieldNameX());
        final Bits validY = FieldCache.DEFAULT.getDocsWithField(reader, this.fields.getFieldNameY());
        return new FunctionValues(){

            public float floatVal(int doc) {
                return (float)this.doubleVal(doc);
            }

            public double doubleVal(int doc) {
                if (validX.get(doc) && validY.get(doc)) {
                    PointImpl pt = new PointImpl(ptX[doc], ptY[doc]);
                    return DistanceValueSource.this.calculator.distance(DistanceValueSource.this.from, (Point)pt);
                }
                return 0.0;
            }

            public String toString(int doc) {
                return DistanceValueSource.this.description() + "=" + this.floatVal(doc);
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DistanceValueSource that = (DistanceValueSource)((Object)o);
        if (this.calculator != null ? !this.calculator.equals(that.calculator) : that.calculator != null) {
            return false;
        }
        if (this.fields != null ? !this.fields.equals(that.fields) : that.fields != null) {
            return false;
        }
        return !(this.from != null ? !this.from.equals(that.from) : that.from != null);
    }

    public int hashCode() {
        int result = this.fields != null ? this.fields.hashCode() : 0;
        result = 31 * result + (this.calculator != null ? this.calculator.hashCode() : 0);
        result = 31 * result + (this.from != null ? this.from.hashCode() : 0);
        return result;
    }
}

