/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.geohash;

import java.util.HashMap;
import java.util.Map;

public class GeoHashUtils {
    private static char[] _base32 = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'j', 'k', 'm', 'n', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final Map<Character, Integer> _decodemap = new HashMap<Character, Integer>();
    private static int precision;
    private static int[] bits;

    public static void main(String[] args) {
        GeoHashUtils ghf = new GeoHashUtils();
        String gc1 = GeoHashUtils.encode(30.0, -90.0);
        String gc2 = GeoHashUtils.encode(51.4797, -0.0124);
        System.out.println(gc1);
        System.out.println(gc2);
        double[] gd1 = GeoHashUtils.decode(gc1);
        double[] gd2 = GeoHashUtils.decode(gc2);
        System.out.println(gd1[0] + ", " + gd1[1]);
        System.out.println(gd2[0] + ", " + gd2[1]);
    }

    public static String encode(double latitude, double longitude) {
        double[] lat_interval = new double[]{-90.0, 90.0};
        double[] lon_interval = new double[]{-180.0, 180.0};
        StringBuilder geohash = new StringBuilder();
        boolean is_even = true;
        int bit = 0;
        int ch = 0;
        while (geohash.length() < precision) {
            double mid = 0.0;
            if (is_even) {
                mid = (lon_interval[0] + lon_interval[1]) / 2.0;
                if (longitude > mid) {
                    ch |= bits[bit];
                    lon_interval[0] = mid;
                } else {
                    lon_interval[1] = mid;
                }
            } else {
                mid = (lat_interval[0] + lat_interval[1]) / 2.0;
                if (latitude > mid) {
                    ch |= bits[bit];
                    lat_interval[0] = mid;
                } else {
                    lat_interval[1] = mid;
                }
            }
            boolean bl = is_even = !is_even;
            if (bit < 4) {
                ++bit;
                continue;
            }
            geohash.append(_base32[ch]);
            bit = 0;
            ch = 0;
        }
        return geohash.toString();
    }

    public static double[] decode(String geohash) {
        double[] ge = GeoHashUtils.decode_exactly(geohash);
        double lat = ge[0];
        double lon = ge[1];
        double lat_err = ge[2];
        double lon_err = ge[3];
        double lat_precision = Math.max(1L, Math.round(-Math.log10(lat_err))) - 1L;
        double lon_precision = Math.max(1L, Math.round(-Math.log10(lon_err))) - 1L;
        lat = GeoHashUtils.getPrecision(lat, lat_precision);
        lon = GeoHashUtils.getPrecision(lon, lon_precision);
        return new double[]{lat, lon};
    }

    public static double[] decode_exactly(String geohash) {
        double[] lat_interval = new double[]{-90.0, 90.0};
        double[] lon_interval = new double[]{-180.0, 180.0};
        double lat_err = 90.0;
        double lon_err = 180.0;
        boolean is_even = true;
        int sz = geohash.length();
        int bsz = bits.length;
        for (int i = 0; i < sz; ++i) {
            int cd = _decodemap.get(Character.valueOf(geohash.charAt(i)));
            for (int z = 0; z < bsz; ++z) {
                int mask = bits[z];
                if (is_even) {
                    lon_err /= 2.0;
                    if ((cd & mask) != 0) {
                        lon_interval[0] = (lon_interval[0] + lon_interval[1]) / 2.0;
                    } else {
                        lon_interval[1] = (lon_interval[0] + lon_interval[1]) / 2.0;
                    }
                } else {
                    lat_err /= 2.0;
                    if ((cd & mask) != 0) {
                        lat_interval[0] = (lat_interval[0] + lat_interval[1]) / 2.0;
                    } else {
                        lat_interval[1] = (lat_interval[0] + lat_interval[1]) / 2.0;
                    }
                }
                is_even = !is_even;
            }
        }
        double latitude = (lat_interval[0] + lat_interval[1]) / 2.0;
        double longitude = (lon_interval[0] + lon_interval[1]) / 2.0;
        return new double[]{latitude, longitude, lat_err, lon_err};
    }

    static double getPrecision(double x, double precision) {
        double base = Math.pow(10.0, -precision);
        double diff = x % base;
        return x - diff;
    }

    static {
        int sz = _base32.length;
        for (int i = 0; i < sz; ++i) {
            _decodemap.put(Character.valueOf(_base32[i]), i);
        }
        precision = 12;
        bits = new int[]{16, 8, 4, 2, 1};
    }
}

