/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.geometry.shape;

import org.apache.lucene.spatial.geometry.FloatLatLng;
import org.apache.lucene.spatial.geometry.LatLng;
import org.apache.lucene.spatial.geometry.shape.DistanceApproximation;
import org.apache.lucene.spatial.geometry.shape.Rectangle;

public class LLRect {
    private LatLng ll;
    private LatLng ur;

    public LLRect(LatLng ll, LatLng ur) {
        this.ll = ll;
        this.ur = ur;
    }

    public LLRect(LLRect other) {
        this.ll = other.ll;
        this.ur = other.ur;
    }

    public double area() {
        return Math.abs((this.ll.getLat() - this.ur.getLat()) * (this.ll.getLng() - this.ur.getLng()));
    }

    public LatLng getLowerLeft() {
        return this.ll;
    }

    public LatLng getUpperRight() {
        return this.ur;
    }

    public String toString() {
        return "{" + this.ll + ", " + this.ur + "}";
    }

    public LatLng getMidpoint() {
        return this.ll.calculateMidpoint(this.ur);
    }

    public static LLRect createBox(LatLng center, double widthMi, double heightMi) {
        double miplatdeg = DistanceApproximation.getMilesPerLngDeg(center.getLat());
        double miplngdeg = DistanceApproximation.getMilesPerLatDeg();
        double lngDelta = widthMi / 2.0 / miplngdeg;
        double latDelta = heightMi / 2.0 / miplatdeg;
        FloatLatLng ll = new FloatLatLng(center.getLat() - latDelta, center.getLng() - lngDelta);
        FloatLatLng ur = new FloatLatLng(center.getLat() + latDelta, center.getLng() + lngDelta);
        return new LLRect(ll, ur);
    }

    public Rectangle toRectangle() {
        return new Rectangle(this.ll.getLng(), this.ll.getLat(), this.ur.getLng(), this.ur.getLat());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ll == null ? 0 : this.ll.hashCode());
        result = 31 * result + (this.ur == null ? 0 : this.ur.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LLRect other = (LLRect)obj;
        if (this.ll == null ? other.ll != null : !this.ll.equals(other.ll)) {
            return false;
        }
        return !(this.ur == null ? other.ur != null : !this.ur.equals(other.ur));
    }
}

