/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.snowball;

import java.io.IOException;
import java.io.Reader;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.snowball.SnowballFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;

public class SnowballAnalyzer
extends Analyzer {
    private String name;
    private Set stopSet;

    public SnowballAnalyzer(String name) {
        this.name = name;
        this.setOverridesTokenStreamMethod(SnowballAnalyzer.class);
    }

    public SnowballAnalyzer(String name, String[] stopWords) {
        this(name);
        this.stopSet = StopFilter.makeStopSet((String[])stopWords);
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        Object result = new StandardTokenizer(reader);
        result = new StandardFilter((TokenStream)result);
        result = new LowerCaseFilter((TokenStream)result);
        if (this.stopSet != null) {
            result = new StopFilter((TokenStream)result, this.stopSet);
        }
        result = new SnowballFilter((TokenStream)result, this.name);
        return result;
    }

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        if (this.overridesTokenStreamMethod) {
            return this.tokenStream(fieldName, reader);
        }
        SavedStreams streams = (SavedStreams)this.getPreviousTokenStream();
        if (streams == null) {
            streams = new SavedStreams();
            streams.source = new StandardTokenizer(reader);
            streams.result = new StandardFilter((TokenStream)streams.source);
            streams.result = new LowerCaseFilter(streams.result);
            if (this.stopSet != null) {
                streams.result = new StopFilter(streams.result, this.stopSet);
            }
            streams.result = new SnowballFilter(streams.result, this.name);
            this.setPreviousTokenStream(streams);
        } else {
            streams.source.reset(reader);
        }
        return streams.result;
    }

    private class SavedStreams {
        Tokenizer source;
        TokenStream result;

        private SavedStreams() {
        }
    }
}

