/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.cn.smart;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.AttributeSource;

public final class SentenceTokenizer
extends Tokenizer {
    private static final String PUNCTION = "\u3002\uff0c\uff01\uff1f\uff1b,!?;";
    private final StringBuilder buffer = new StringBuilder();
    private int tokenStart = 0;
    private int tokenEnd = 0;
    private TermAttribute termAtt;
    private OffsetAttribute offsetAtt;
    private TypeAttribute typeAtt;

    public SentenceTokenizer(Reader reader) {
        super(reader);
        this.init();
    }

    public SentenceTokenizer(AttributeSource source, Reader reader) {
        super(source, reader);
        this.init();
    }

    public SentenceTokenizer(AttributeSource.AttributeFactory factory, Reader reader) {
        super(factory, reader);
        this.init();
    }

    private void init() {
        this.termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);
        this.offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
        this.typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);
    }

    public boolean incrementToken() throws IOException {
        this.clearAttributes();
        this.buffer.setLength(0);
        boolean atBegin = true;
        this.tokenStart = this.tokenEnd;
        int ci = this.input.read();
        char ch = (char)ci;
        while (ci != -1) {
            if (PUNCTION.indexOf(ch) != -1) {
                this.buffer.append(ch);
                ++this.tokenEnd;
                break;
            }
            if (atBegin && " \u3000\t\r\n".indexOf(ch) != -1) {
                ++this.tokenStart;
                ++this.tokenEnd;
                ci = this.input.read();
                ch = (char)ci;
                continue;
            }
            this.buffer.append(ch);
            atBegin = false;
            ++this.tokenEnd;
            char pch = ch;
            ci = this.input.read();
            ch = (char)ci;
            if (" \u3000\t\r\n".indexOf(ch) == -1 || " \u3000\t\r\n".indexOf(pch) == -1) continue;
            ++this.tokenEnd;
            break;
        }
        if (this.buffer.length() == 0) {
            return false;
        }
        this.termAtt.setTermBuffer(this.buffer.toString());
        this.offsetAtt.setOffset(this.correctOffset(this.tokenStart), this.correctOffset(this.tokenEnd));
        this.typeAtt.setType("sentence");
        return true;
    }

    public void reset() throws IOException {
        super.reset();
        this.tokenEnd = 0;
        this.tokenStart = 0;
    }

    public void reset(Reader input) throws IOException {
        super.reset(input);
        this.reset();
    }
}

