/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.cn.smart.hhmm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.cn.smart.hhmm.SegToken;

class SegGraph {
    private Map tokenListTable = new HashMap();
    private int maxStart = -1;

    SegGraph() {
    }

    public boolean isStartExist(int s) {
        return this.tokenListTable.get(new Integer(s)) != null;
    }

    public List getStartList(int s) {
        return (List)this.tokenListTable.get(new Integer(s));
    }

    public int getMaxStart() {
        return this.maxStart;
    }

    public List makeIndex() {
        ArrayList<SegToken> result = new ArrayList<SegToken>();
        int s = -1;
        int count = 0;
        int size = this.tokenListTable.size();
        int index = 0;
        while (count < size) {
            if (this.isStartExist(s)) {
                List tokenList = (List)this.tokenListTable.get(new Integer(s));
                Iterator iter = tokenList.iterator();
                while (iter.hasNext()) {
                    SegToken st = (SegToken)iter.next();
                    st.index = index;
                    result.add(st);
                    index = (short)(index + 1);
                }
                ++count;
            }
            ++s;
        }
        return result;
    }

    public void addToken(SegToken token) {
        int s = token.startOffset;
        if (!this.isStartExist(s)) {
            ArrayList<SegToken> newlist = new ArrayList<SegToken>();
            newlist.add(token);
            this.tokenListTable.put(new Integer(s), newlist);
        } else {
            List tokenList = (List)this.tokenListTable.get(new Integer(s));
            tokenList.add(token);
        }
        if (s > this.maxStart) {
            this.maxStart = s;
        }
    }

    public List toTokenList() {
        ArrayList<SegToken> result = new ArrayList<SegToken>();
        int s = -1;
        int count = 0;
        int size = this.tokenListTable.size();
        while (count < size) {
            if (this.isStartExist(s)) {
                List tokenList = (List)this.tokenListTable.get(new Integer(s));
                Iterator iter = tokenList.iterator();
                while (iter.hasNext()) {
                    SegToken st = (SegToken)iter.next();
                    result.add(st);
                }
                ++count;
            }
            ++s;
        }
        return result;
    }

    public String toString() {
        List tokenList = this.toTokenList();
        StringBuffer sb = new StringBuffer();
        Iterator iter = tokenList.iterator();
        while (iter.hasNext()) {
            SegToken t = (SegToken)iter.next();
            sb.append(t + "\n");
        }
        return sb.toString();
    }
}

