/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.cn.smart;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.PorterStemFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.cn.smart.SentenceTokenizer;
import org.apache.lucene.analysis.cn.smart.WordTokenFilter;
import org.apache.lucene.util.Version;

public class SmartChineseAnalyzer
extends Analyzer {
    private final Set stopWords;
    private final Version matchVersion;

    public SmartChineseAnalyzer() {
        this(Version.LUCENE_24, true);
    }

    public SmartChineseAnalyzer(Version matchVersion) {
        this(matchVersion, true);
    }

    public SmartChineseAnalyzer(boolean useDefaultStopWords) {
        this(Version.LUCENE_24, useDefaultStopWords);
    }

    public SmartChineseAnalyzer(Version matchVersion, boolean useDefaultStopWords) {
        this.matchVersion = matchVersion;
        if (useDefaultStopWords) {
            try {
                InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream("stopwords.txt");
                InputStreamReader reader = new InputStreamReader(stream, "UTF-8");
                this.stopWords = WordlistLoader.getWordSet((Reader)reader, (String)"//");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.stopWords = null;
        }
    }

    public SmartChineseAnalyzer(Set stopWords) {
        this(Version.LUCENE_24, stopWords);
    }

    public SmartChineseAnalyzer(Version matchVersion, Set stopWords) {
        this.stopWords = stopWords;
        this.matchVersion = matchVersion;
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        Object result = new SentenceTokenizer(reader);
        result = new WordTokenFilter((TokenStream)result);
        result = new PorterStemFilter((TokenStream)result);
        if (this.stopWords != null) {
            result = new StopFilter(StopFilter.getEnablePositionIncrementsVersionDefault((Version)this.matchVersion), (TokenStream)result, this.stopWords, false);
        }
        return result;
    }

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        SavedStreams streams = (SavedStreams)this.getPreviousTokenStream();
        if (streams == null) {
            streams = new SavedStreams();
            this.setPreviousTokenStream(streams);
            streams.tokenStream = new SentenceTokenizer(reader);
            streams.filteredTokenStream = new WordTokenFilter((TokenStream)streams.tokenStream);
            streams.filteredTokenStream = new PorterStemFilter(streams.filteredTokenStream);
            if (this.stopWords != null) {
                streams.filteredTokenStream = new StopFilter(StopFilter.getEnablePositionIncrementsVersionDefault((Version)this.matchVersion), streams.filteredTokenStream, this.stopWords, false);
            }
        } else {
            streams.tokenStream.reset(reader);
            streams.filteredTokenStream.reset();
        }
        return streams.filteredTokenStream;
    }

    private static final class SavedStreams {
        Tokenizer tokenStream;
        TokenStream filteredTokenStream;

        private SavedStreams() {
        }
    }
}

