/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.cn.smart;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.PorterStemFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.cn.smart.SentenceTokenizer;
import org.apache.lucene.analysis.cn.smart.WordTokenFilter;

public class SmartChineseAnalyzer
extends Analyzer {
    private final Set stopWords;

    public SmartChineseAnalyzer() {
        this(true);
    }

    public SmartChineseAnalyzer(boolean useDefaultStopWords) {
        if (useDefaultStopWords) {
            try {
                InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream("stopwords.txt");
                InputStreamReader reader = new InputStreamReader(stream, "UTF-8");
                this.stopWords = WordlistLoader.getWordSet((Reader)reader, (String)"//");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.stopWords = null;
        }
    }

    public SmartChineseAnalyzer(Set stopWords) {
        this.stopWords = stopWords;
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        Object result = new SentenceTokenizer(reader);
        result = new WordTokenFilter((TokenStream)result);
        result = new PorterStemFilter((TokenStream)result);
        if (this.stopWords != null) {
            result = new StopFilter((TokenStream)result, this.stopWords, false);
        }
        return result;
    }

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        SavedStreams streams = (SavedStreams)this.getPreviousTokenStream();
        if (streams == null) {
            streams = new SavedStreams();
            this.setPreviousTokenStream(streams);
            streams.tokenStream = new SentenceTokenizer(reader);
            streams.filteredTokenStream = new WordTokenFilter((TokenStream)streams.tokenStream);
            streams.filteredTokenStream = new PorterStemFilter(streams.filteredTokenStream);
            if (this.stopWords != null) {
                streams.filteredTokenStream = new StopFilter(streams.filteredTokenStream, this.stopWords, false);
            }
        } else {
            streams.tokenStream.reset(reader);
            streams.filteredTokenStream.reset();
        }
        return streams.filteredTokenStream;
    }

    private static final class SavedStreams {
        Tokenizer tokenStream;
        TokenStream filteredTokenStream;

        private SavedStreams() {
        }
    }
}

