/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.replicator.nrt;

import java.io.Closeable;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.NoSuchFileException;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.replicator.nrt.FileMetaData;
import org.apache.lucene.replicator.nrt.PrimaryNode;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;

public abstract class Node
implements Closeable {
    public static boolean VERBOSE_FILES = true;
    public static boolean VERBOSE_CONNECTIONS = false;
    public static String PRIMARY_GEN_KEY = "__primaryGen";
    public static String VERSION_KEY = "__version";
    protected final int id;
    protected final Directory dir;
    protected final SearcherFactory searcherFactory;
    protected ReferenceManager<IndexSearcher> mgr;
    public static long globalStartNS;
    public static final long localStartNS;
    protected final PrintStream printStream;
    volatile String state = "idle";
    protected volatile Map<String, FileMetaData> lastFileMetaData;

    public Node(int id, Directory dir, SearcherFactory searcherFactory, PrintStream printStream) {
        this.id = id;
        this.dir = dir;
        this.searcherFactory = searcherFactory;
        this.printStream = printStream;
    }

    public ReferenceManager<IndexSearcher> getSearcherManager() {
        return this.mgr;
    }

    public Directory getDirectory() {
        return this.dir;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(id=" + this.id + ")";
    }

    public abstract void commit() throws IOException;

    public static void nodeMessage(PrintStream printStream, String message) {
        if (printStream != null) {
            long now = System.nanoTime();
            printStream.println(String.format(Locale.ROOT, "%5.3fs %5.1fs:           [%11s] %s", (double)(now - globalStartNS) / 1.0E9, (double)(now - localStartNS) / 1.0E9, Thread.currentThread().getName(), message));
        }
    }

    public static void nodeMessage(PrintStream printStream, int id, String message) {
        if (printStream != null) {
            long now = System.nanoTime();
            printStream.println(String.format(Locale.ROOT, "%5.3fs %5.1fs:         N%d [%11s] %s", (double)(now - globalStartNS) / 1.0E9, (double)(now - localStartNS) / 1.0E9, id, Thread.currentThread().getName(), message));
        }
    }

    public void message(String message) {
        if (this.printStream != null) {
            long now = System.nanoTime();
            this.printStream.println(String.format(Locale.ROOT, "%5.3fs %5.1fs: %7s %2s [%11s] %s", (double)(now - globalStartNS) / 1.0E9, (double)(now - localStartNS) / 1.0E9, this.state, this.name(), Thread.currentThread().getName(), message));
        }
    }

    public String name() {
        char mode = this instanceof PrimaryNode ? (char)'P' : 'R';
        return mode + Integer.toString(this.id);
    }

    public abstract boolean isClosed();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCurrentSearchingVersion() throws IOException {
        IndexSearcher searcher = (IndexSearcher)this.mgr.acquire();
        try {
            long l = ((DirectoryReader)searcher.getIndexReader()).getVersion();
            return l;
        }
        finally {
            this.mgr.release((Object)searcher);
        }
    }

    public static String bytesToString(long bytes) {
        if (bytes < 1024L) {
            return bytes + " b";
        }
        if (bytes < 0x100000L) {
            return String.format(Locale.ROOT, "%.1f KB", (double)bytes / 1024.0);
        }
        if (bytes < 0x40000000L) {
            return String.format(Locale.ROOT, "%.1f MB", (double)bytes / 1024.0 / 1024.0);
        }
        return String.format(Locale.ROOT, "%.1f GB", (double)bytes / 1024.0 / 1024.0 / 1024.0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FileMetaData readLocalFileMetaData(String fileName) throws IOException {
        Map<String, FileMetaData> cache = this.lastFileMetaData;
        FileMetaData result = cache != null ? cache.get(fileName) : null;
        if (result != null) return result;
        try {
            IndexInput in = this.dir.openInput(fileName, IOContext.DEFAULT);
            try {
                long checksum;
                byte[] footer;
                byte[] header;
                long length;
                try {
                    length = in.length();
                    header = CodecUtil.readIndexHeader((IndexInput)in);
                    footer = CodecUtil.readFooter((IndexInput)in);
                    checksum = CodecUtil.retrieveChecksum((IndexInput)in);
                }
                catch (EOFException | CorruptIndexException cie) {
                    if (VERBOSE_FILES) {
                        this.message("file " + fileName + ": will copy [existing file is corrupt]");
                    }
                    FileMetaData fileMetaData = null;
                    if (in == null) return fileMetaData;
                    in.close();
                    return fileMetaData;
                }
                if (!VERBOSE_FILES) return new FileMetaData(header, footer, length, checksum);
                this.message("file " + fileName + " has length=" + Node.bytesToString(length));
                return new FileMetaData(header, footer, length, checksum);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            if (!VERBOSE_FILES) return null;
            this.message("file " + fileName + ": will copy [file does not exist]");
            return null;
        }
    }

    static {
        localStartNS = System.nanoTime();
    }
}

