/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.replicator;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.replicator.Revision;
import org.apache.lucene.replicator.RevisionFile;

@Deprecated
public final class SessionToken {
    public final String id;
    public final String version;
    public final Map<String, List<RevisionFile>> sourceFiles;

    public SessionToken(DataInput in) throws IOException {
        this.id = in.readUTF();
        this.version = in.readUTF();
        this.sourceFiles = new HashMap<String, List<RevisionFile>>();
        for (int numSources = in.readInt(); numSources > 0; --numSources) {
            String source = in.readUTF();
            int numFiles = in.readInt();
            ArrayList<RevisionFile> files = new ArrayList<RevisionFile>(numFiles);
            for (int i = 0; i < numFiles; ++i) {
                String fileName = in.readUTF();
                RevisionFile file = new RevisionFile(fileName);
                file.size = in.readLong();
                files.add(file);
            }
            this.sourceFiles.put(source, files);
        }
    }

    public SessionToken(String id, Revision revision) {
        this.id = id;
        this.version = revision.getVersion();
        this.sourceFiles = revision.getSourceFiles();
    }

    public void serialize(DataOutput out) throws IOException {
        out.writeUTF(this.id);
        out.writeUTF(this.version);
        out.writeInt(this.sourceFiles.size());
        for (Map.Entry<String, List<RevisionFile>> e : this.sourceFiles.entrySet()) {
            out.writeUTF(e.getKey());
            List<RevisionFile> files = e.getValue();
            out.writeInt(files.size());
            for (RevisionFile file : files) {
                out.writeUTF(file.fileName);
                out.writeLong(file.size);
            }
        }
    }

    public String toString() {
        return "id=" + this.id + " version=" + this.version + " files=" + this.sourceFiles;
    }
}

