/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.replicator;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.replicator.IndexAndTaxonomyRevision;
import org.apache.lucene.replicator.IndexReplicationHandler;
import org.apache.lucene.replicator.ReplicationClient;
import org.apache.lucene.replicator.RevisionFile;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.InfoStream;

public class IndexAndTaxonomyReplicationHandler
implements ReplicationClient.ReplicationHandler {
    public static final String INFO_STREAM_COMPONENT = "IndexAndTaxonomyReplicationHandler";
    private final Directory indexDir;
    private final Directory taxoDir;
    private final Callable<Boolean> callback;
    private volatile Map<String, List<RevisionFile>> currentRevisionFiles;
    private volatile String currentVersion;
    private volatile InfoStream infoStream = InfoStream.getDefault();

    public IndexAndTaxonomyReplicationHandler(Directory indexDir, Directory taxoDir, Callable<Boolean> callback) throws IOException {
        this.callback = callback;
        this.indexDir = indexDir;
        this.taxoDir = taxoDir;
        this.currentRevisionFiles = null;
        this.currentVersion = null;
        boolean indexExists = DirectoryReader.indexExists((Directory)indexDir);
        boolean taxoExists = DirectoryReader.indexExists((Directory)taxoDir);
        if (indexExists != taxoExists) {
            throw new IllegalStateException("search and taxonomy indexes must either both exist or not: index=" + indexExists + " taxo=" + taxoExists);
        }
        if (indexExists) {
            IndexCommit indexCommit = IndexReplicationHandler.getLastCommit(indexDir);
            IndexCommit taxoCommit = IndexReplicationHandler.getLastCommit(taxoDir);
            this.currentRevisionFiles = IndexAndTaxonomyRevision.revisionFiles(indexCommit, taxoCommit);
            this.currentVersion = IndexAndTaxonomyRevision.revisionVersion(indexCommit, taxoCommit);
            InfoStream infoStream = InfoStream.getDefault();
            if (infoStream.isEnabled(INFO_STREAM_COMPONENT)) {
                infoStream.message(INFO_STREAM_COMPONENT, "constructor(): currentVersion=" + this.currentVersion + " currentRevisionFiles=" + this.currentRevisionFiles);
                infoStream.message(INFO_STREAM_COMPONENT, "constructor(): indexCommit=" + indexCommit + " taxoCommit=" + taxoCommit);
            }
        }
    }

    @Override
    public String currentVersion() {
        return this.currentVersion;
    }

    @Override
    public Map<String, List<RevisionFile>> currentRevisionFiles() {
        return this.currentRevisionFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revisionReady(String version, Map<String, List<RevisionFile>> revisionFiles, Map<String, List<String>> copiedFiles, Map<String, Directory> sourceDirectory) throws IOException {
        Directory taxoClientDir = sourceDirectory.get("taxo");
        Directory indexClientDir = sourceDirectory.get("index");
        List<String> taxoFiles = copiedFiles.get("taxo");
        List<String> indexFiles = copiedFiles.get("index");
        String taxoSegmentsFile = IndexReplicationHandler.getSegmentsFile(taxoFiles, true);
        String indexSegmentsFile = IndexReplicationHandler.getSegmentsFile(indexFiles, false);
        String taxoPendingFile = taxoSegmentsFile == null ? null : "pending_" + taxoSegmentsFile;
        String indexPendingFile = "pending_" + indexSegmentsFile;
        boolean success = false;
        try {
            IndexReplicationHandler.copyFiles(taxoClientDir, this.taxoDir, taxoFiles);
            IndexReplicationHandler.copyFiles(indexClientDir, this.indexDir, indexFiles);
            if (!taxoFiles.isEmpty()) {
                this.taxoDir.sync(taxoFiles);
            }
            this.indexDir.sync(indexFiles);
            if (taxoSegmentsFile != null) {
                this.taxoDir.copyFrom(taxoClientDir, taxoSegmentsFile, taxoPendingFile, IOContext.READONCE);
            }
            this.indexDir.copyFrom(indexClientDir, indexSegmentsFile, indexPendingFile, IOContext.READONCE);
            if (taxoSegmentsFile != null) {
                this.taxoDir.sync(Collections.singletonList(taxoPendingFile));
            }
            this.indexDir.sync(Collections.singletonList(indexPendingFile));
            if (taxoSegmentsFile != null) {
                this.taxoDir.rename(taxoPendingFile, taxoSegmentsFile);
                this.taxoDir.syncMetaData();
            }
            this.indexDir.rename(indexPendingFile, indexSegmentsFile);
            this.indexDir.syncMetaData();
            success = true;
        }
        finally {
            if (!success) {
                if (taxoSegmentsFile != null) {
                    taxoFiles.add(taxoSegmentsFile);
                    taxoFiles.add(taxoPendingFile);
                }
                IndexReplicationHandler.cleanupFilesOnFailure(this.taxoDir, taxoFiles);
                indexFiles.add(indexSegmentsFile);
                indexFiles.add(indexPendingFile);
                IndexReplicationHandler.cleanupFilesOnFailure(this.indexDir, indexFiles);
            }
        }
        this.currentRevisionFiles = revisionFiles;
        this.currentVersion = version;
        if (this.infoStream.isEnabled(INFO_STREAM_COMPONENT)) {
            this.infoStream.message(INFO_STREAM_COMPONENT, "revisionReady(): currentVersion=" + this.currentVersion + " currentRevisionFiles=" + this.currentRevisionFiles);
        }
        IndexReplicationHandler.cleanupOldIndexFiles(this.indexDir, indexSegmentsFile, this.infoStream);
        IndexReplicationHandler.cleanupOldIndexFiles(this.taxoDir, taxoSegmentsFile, this.infoStream);
        if (this.callback != null) {
            try {
                this.callback.call();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    public void setInfoStream(InfoStream infoStream) {
        if (infoStream == null) {
            infoStream = InfoStream.NO_OUTPUT;
        }
        this.infoStream = infoStream;
    }
}

