/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.replicator;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.replicator.ReplicationClient;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class PerSessionDirectoryFactory
implements ReplicationClient.SourceDirectoryFactory {
    private final File workDir;

    public PerSessionDirectoryFactory(File workDir) {
        this.workDir = workDir;
    }

    private void rm(File file) throws IOException {
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                this.rm(f);
            }
        }
        if (!file.delete() && file.exists()) {
            throw new IOException("failed to delete " + file);
        }
    }

    @Override
    public Directory getDirectory(String sessionID, String source) throws IOException {
        File sessionDir = new File(this.workDir, sessionID);
        if (!sessionDir.exists() && !sessionDir.mkdirs()) {
            throw new IOException("failed to create session directory " + sessionDir);
        }
        File sourceDir = new File(sessionDir, source);
        if (!sourceDir.mkdirs()) {
            throw new IOException("failed to create source directory " + sourceDir);
        }
        return FSDirectory.open((File)sourceDir);
    }

    @Override
    public void cleanupSession(String sessionID) throws IOException {
        if (sessionID.isEmpty()) {
            throw new IllegalArgumentException("sessionID cannot be empty");
        }
        this.rm(new File(this.workDir, sessionID));
    }
}

