/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.replicator.http;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.concurrent.Callable;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.apache.lucene.store.AlreadyClosedException;

public abstract class HttpClientBase
implements Closeable {
    public static final int DEFAULT_CONNECTION_TIMEOUT = 1000;
    public static final int DEFAULT_SO_TIMEOUT = 60000;
    protected final String url;
    private volatile boolean closed = false;
    private final HttpClient httpc;

    protected HttpClientBase(String host, int port, String path, ClientConnectionManager conMgr) {
        this.url = HttpClientBase.normalizedURL(host, port, path);
        this.httpc = new DefaultHttpClient(conMgr);
        this.setConnectionTimeout(1000);
        this.setSoTimeout(60000);
    }

    public void setConnectionTimeout(int timeout) {
        HttpConnectionParams.setConnectionTimeout((HttpParams)this.httpc.getParams(), (int)timeout);
    }

    public void setSoTimeout(int timeout) {
        HttpConnectionParams.setSoTimeout((HttpParams)this.httpc.getParams(), (int)timeout);
    }

    protected final void ensureOpen() throws AlreadyClosedException {
        if (this.closed) {
            throw new AlreadyClosedException("HttpClient already closed");
        }
    }

    private static String normalizedURL(String host, int port, String path) {
        if (path == null || path.length() == 0) {
            path = "/";
        }
        return "http://" + host + ":" + port + path;
    }

    protected void verifyStatus(HttpResponse response) throws IOException {
        StatusLine statusLine = response.getStatusLine();
        if (statusLine.getStatusCode() != 200) {
            this.throwKnownError(response, statusLine);
        }
    }

    protected void throwKnownError(HttpResponse response, StatusLine statusLine) throws IOException {
        Throwable t;
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(response.getEntity().getContent());
        }
        catch (Exception e) {
            throw new RuntimeException("Uknown error: " + statusLine);
        }
        try {
            t = (Throwable)in.readObject();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read exception object: " + statusLine, e);
        }
        finally {
            in.close();
        }
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new RuntimeException("unknown exception " + statusLine, t);
    }

    protected HttpResponse executePOST(String request, HttpEntity entity, String ... params) throws IOException {
        this.ensureOpen();
        HttpPost m = new HttpPost(this.queryString(request, params));
        m.setEntity(entity);
        HttpResponse response = this.httpc.execute((HttpUriRequest)m);
        this.verifyStatus(response);
        return response;
    }

    protected HttpResponse executeGET(String request, String ... params) throws IOException {
        this.ensureOpen();
        HttpGet m = new HttpGet(this.queryString(request, params));
        HttpResponse response = this.httpc.execute((HttpUriRequest)m);
        this.verifyStatus(response);
        return response;
    }

    private String queryString(String request, String ... params) throws UnsupportedEncodingException {
        StringBuilder query = new StringBuilder(this.url).append('/').append(request).append('?');
        if (params != null) {
            for (int i = 0; i < params.length; i += 2) {
                query.append(params[i]).append('=').append(URLEncoder.encode(params[i + 1], "UTF8")).append('&');
            }
        }
        return query.substring(0, query.length() - 1);
    }

    public InputStream responseInputStream(HttpResponse response) throws IOException {
        return this.responseInputStream(response, false);
    }

    public InputStream responseInputStream(HttpResponse response, boolean consume) throws IOException {
        final HttpEntity entity = response.getEntity();
        final InputStream in = entity.getContent();
        if (!consume) {
            return in;
        }
        return new InputStream(){
            private boolean consumed = false;

            @Override
            public int read() throws IOException {
                int res = in.read();
                this.consume(res);
                return res;
            }

            @Override
            public void close() throws IOException {
                super.close();
                this.consume(-1);
            }

            @Override
            public int read(byte[] b) throws IOException {
                int res = super.read(b);
                this.consume(res);
                return res;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                int res = super.read(b, off, len);
                this.consume(res);
                return res;
            }

            private void consume(int minusOne) {
                if (!this.consumed && minusOne == -1) {
                    try {
                        EntityUtils.consume((HttpEntity)entity);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.consumed = true;
                }
            }
        };
    }

    protected final boolean isClosed() {
        return this.closed;
    }

    protected <T> T doAction(HttpResponse response, Callable<T> call) throws IOException {
        return this.doAction(response, true, call);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected <T> T doAction(HttpResponse response, boolean consume, Callable<T> call) throws IOException {
        IOException error = null;
        try {
            T t = call.call();
            return t;
        }
        catch (IOException e) {
            error = e;
            throw error;
        }
        catch (Exception e) {
            error = new IOException(e);
            throw error;
        }
        finally {
            block31: {
                try {
                    this.verifyStatus(response);
                    if (!consume) break block31;
                }
                catch (Throwable throwable) {
                    if (!consume) throw throwable;
                    try {
                        EntityUtils.consume((HttpEntity)response.getEntity());
                        throw throwable;
                    }
                    catch (Exception e) {}
                }
                try {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
                catch (Exception e) {}
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }
}

