/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.replicator.http;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;
import org.apache.http.HttpResponse;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.lucene.replicator.Replicator;
import org.apache.lucene.replicator.Revision;
import org.apache.lucene.replicator.SessionToken;
import org.apache.lucene.replicator.http.HttpClientBase;
import org.apache.lucene.replicator.http.ReplicationService;

public class HttpReplicator
extends HttpClientBase
implements Replicator {
    public HttpReplicator(String host, int port, String path, ClientConnectionManager conMgr) {
        super(host, port, path, conMgr);
    }

    @Override
    public SessionToken checkForUpdate(String currVersion) throws IOException {
        String[] params = null;
        if (currVersion != null) {
            params = new String[]{"version", currVersion};
        }
        final HttpResponse response = this.executeGET(ReplicationService.ReplicationAction.UPDATE.name(), params);
        return this.doAction(response, new Callable<SessionToken>(){

            @Override
            public SessionToken call() throws Exception {
                DataInputStream dis = new DataInputStream(HttpReplicator.this.responseInputStream(response));
                try {
                    if (dis.readByte() == 0) {
                        SessionToken sessionToken = null;
                        return sessionToken;
                    }
                    SessionToken sessionToken = new SessionToken(dis);
                    return sessionToken;
                }
                finally {
                    dis.close();
                }
            }
        });
    }

    @Override
    public InputStream obtainFile(String sessionID, String source, String fileName) throws IOException {
        String[] params = new String[]{"sessionid", sessionID, "source", source, "filename", fileName};
        final HttpResponse response = this.executeGET(ReplicationService.ReplicationAction.OBTAIN.name(), params);
        return this.doAction(response, false, new Callable<InputStream>(){

            @Override
            public InputStream call() throws Exception {
                return HttpReplicator.this.responseInputStream(response, true);
            }
        });
    }

    @Override
    public void publish(Revision revision) throws IOException {
        throw new UnsupportedOperationException("this replicator implementation does not support remote publishing of revisions");
    }

    @Override
    public void release(String sessionID) throws IOException {
        String[] params = new String[]{"sessionid", sessionID};
        HttpResponse response = this.executeGET(ReplicationService.ReplicationAction.RELEASE.name(), params);
        this.doAction(response, new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return null;
            }
        });
    }
}

