/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.spans;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermStates;
import org.apache.lucene.queries.spans.SpanOrQuery;
import org.apache.lucene.queries.spans.SpanQuery;
import org.apache.lucene.queries.spans.SpanTermQuery;
import org.apache.lucene.queries.spans.SpanWeight;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.ScoringRewrite;
import org.apache.lucene.search.TopTermsRewrite;

public class SpanMultiTermQueryWrapper<Q extends MultiTermQuery>
extends SpanQuery {
    protected final Q query;
    private SpanRewriteMethod rewriteMethod;
    public static final SpanRewriteMethod SCORING_SPAN_QUERY_REWRITE = new SpanRewriteMethod(){
        private final ScoringRewrite<List<SpanQuery>> delegate = new ScoringRewrite<List<SpanQuery>>(){

            protected List<SpanQuery> getTopLevelBuilder() {
                return new ArrayList<SpanQuery>();
            }

            protected Query build(List<SpanQuery> builder) {
                return new SpanOrQuery(builder.toArray(new SpanQuery[builder.size()]));
            }

            protected void checkMaxClauseCount(int count) {
            }

            protected void addClause(List<SpanQuery> topLevel, Term term, int docCount, float boost, TermStates states) {
                SpanTermQuery q = new SpanTermQuery(term, states);
                topLevel.add(q);
            }
        };

        @Override
        public SpanQuery rewrite(IndexReader reader, MultiTermQuery query) throws IOException {
            return (SpanQuery)this.delegate.rewrite(reader, query);
        }
    };

    public SpanMultiTermQueryWrapper(Q query) {
        this.query = (MultiTermQuery)Objects.requireNonNull(query);
        this.rewriteMethod = SpanMultiTermQueryWrapper.selectRewriteMethod(query);
    }

    private static SpanRewriteMethod selectRewriteMethod(MultiTermQuery query) {
        MultiTermQuery.RewriteMethod method = query.getRewriteMethod();
        if (method instanceof TopTermsRewrite) {
            int pqsize = ((TopTermsRewrite)method).getSize();
            return new TopTermsSpanBooleanQueryRewrite(pqsize);
        }
        return SCORING_SPAN_QUERY_REWRITE;
    }

    public final SpanRewriteMethod getRewriteMethod() {
        return this.rewriteMethod;
    }

    public final void setRewriteMethod(SpanRewriteMethod rewriteMethod) {
        this.rewriteMethod = rewriteMethod;
    }

    @Override
    public String getField() {
        return this.query.getField();
    }

    @Override
    public SpanWeight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        throw new IllegalArgumentException("Rewrite first!");
    }

    public Query getWrappedQuery() {
        return this.query;
    }

    public String toString(String field) {
        StringBuilder builder = new StringBuilder();
        builder.append("SpanMultiTermQueryWrapper(");
        String queryStr = this.query.toString(field);
        builder.append(queryStr);
        builder.append(")");
        return builder.toString();
    }

    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        return this.rewriteMethod.rewrite(indexSearcher.getIndexReader(), (MultiTermQuery)this.query);
    }

    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.query.getField())) {
            this.query.visit(visitor.getSubVisitor(BooleanClause.Occur.MUST, (Query)this));
        }
    }

    public int hashCode() {
        return this.classHash() * 31 + this.query.hashCode();
    }

    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.query.equals(((SpanMultiTermQueryWrapper)((Object)other)).query);
    }

    public static abstract class SpanRewriteMethod
    extends MultiTermQuery.RewriteMethod {
        public abstract SpanQuery rewrite(IndexReader var1, MultiTermQuery var2) throws IOException;
    }

    public static final class TopTermsSpanBooleanQueryRewrite
    extends SpanRewriteMethod {
        private final TopTermsRewrite<List<SpanQuery>> delegate;

        public TopTermsSpanBooleanQueryRewrite(int size) {
            this.delegate = new TopTermsRewrite<List<SpanQuery>>(size){

                protected int getMaxSize() {
                    return Integer.MAX_VALUE;
                }

                protected List<SpanQuery> getTopLevelBuilder() {
                    return new ArrayList<SpanQuery>();
                }

                protected Query build(List<SpanQuery> builder) {
                    return new SpanOrQuery(builder.toArray(new SpanQuery[builder.size()]));
                }

                protected void addClause(List<SpanQuery> topLevel, Term term, int docFreq, float boost, TermStates states) {
                    SpanTermQuery q = new SpanTermQuery(term, states);
                    topLevel.add(q);
                }
            };
        }

        public int getSize() {
            return this.delegate.getSize();
        }

        @Override
        public SpanQuery rewrite(IndexReader reader, MultiTermQuery query) throws IOException {
            return (SpanQuery)this.delegate.rewrite(reader, query);
        }

        public int hashCode() {
            return 31 * this.delegate.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            TopTermsSpanBooleanQueryRewrite other = (TopTermsSpanBooleanQueryRewrite)((Object)obj);
            return this.delegate.equals(other.delegate);
        }
    }
}

