/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.valuesource;

import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.MultiFloatFunction;

public class MaxFloatFunction
extends MultiFloatFunction {
    public MaxFloatFunction(ValueSource[] sources) {
        super(sources);
    }

    @Override
    protected String name() {
        return "max";
    }

    @Override
    protected float func(int doc, FunctionValues[] valsArr) {
        boolean first = true;
        float val = 0.0f;
        for (FunctionValues vals : valsArr) {
            if (first) {
                first = false;
                val = vals.floatVal(doc);
                continue;
            }
            val = Math.max(vals.floatVal(doc), val);
        }
        return val;
    }
}

