/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilterClause;

public class BooleanFilter
extends Filter {
    ArrayList shouldFilters = null;
    ArrayList notFilters = null;
    ArrayList mustFilters = null;

    public BitSet bits(IndexReader reader) throws IOException {
        int i;
        BitSet returnBits = null;
        if (this.shouldFilters != null) {
            returnBits = ((Filter)this.shouldFilters.get(0)).bits(reader);
            if (this.shouldFilters.size() > 1) {
                for (i = 1; i < this.shouldFilters.size(); ++i) {
                    returnBits.or(((Filter)this.shouldFilters.get(i)).bits(reader));
                }
            }
        }
        if (this.notFilters != null) {
            for (i = 0; i < this.notFilters.size(); ++i) {
                BitSet notBits = ((Filter)this.notFilters.get(i)).bits(reader);
                if (returnBits == null) {
                    returnBits = notBits;
                    returnBits.flip(0, reader.maxDoc());
                    continue;
                }
                returnBits.andNot(notBits);
            }
        }
        if (this.mustFilters != null) {
            for (i = 0; i < this.mustFilters.size(); ++i) {
                BitSet mustBits = ((Filter)this.mustFilters.get(i)).bits(reader);
                if (returnBits == null) {
                    returnBits = mustBits;
                    continue;
                }
                returnBits.and(mustBits);
            }
        }
        if (returnBits == null) {
            returnBits = new BitSet(reader.maxDoc());
        }
        return returnBits;
    }

    public void add(FilterClause filterClause) {
        if (filterClause.getOccur().equals(BooleanClause.Occur.MUST)) {
            if (this.mustFilters == null) {
                this.mustFilters = new ArrayList();
            }
            this.mustFilters.add(filterClause.getFilter());
        }
        if (filterClause.getOccur().equals(BooleanClause.Occur.SHOULD)) {
            if (this.shouldFilters == null) {
                this.shouldFilters = new ArrayList();
            }
            this.shouldFilters.add(filterClause.getFilter());
        }
        if (filterClause.getOccur().equals(BooleanClause.Occur.MUST_NOT)) {
            if (this.notFilters == null) {
                this.notFilters = new ArrayList();
            }
            this.notFilters.add(filterClause.getFilter());
        }
    }
}

