/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index.pruning;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.index.pruning.TermPruningPolicy;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DefaultSimilarity;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopScoreDocCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CarmelUniformTermPruningPolicy
extends TermPruningPolicy {
    int docsPos = 0;
    float curThr;
    float defThreshold;
    Map<String, Float> thresholds;
    ScoreDoc[] docs = null;
    IndexSearcher is;
    Similarity sim;

    public CarmelUniformTermPruningPolicy(IndexReader in, Map<String, Integer> fieldFlags, Map<String, Float> thresholds, float defThreshold, Similarity sim) {
        super(in, fieldFlags);
        this.defThreshold = defThreshold;
        this.thresholds = thresholds != null ? thresholds : Collections.emptyMap();
        if (sim != null) {
            this.sim = sim;
        } else {
            sim = new DefaultSimilarity();
        }
        this.is = new IndexSearcher(in);
        this.is.setSimilarity(sim);
    }

    @Override
    public boolean pruneTermEnum(TermEnum te) throws IOException {
        return false;
    }

    @Override
    public void initPositionsTerm(TermPositions tp, Term t) throws IOException {
        this.curThr = this.defThreshold;
        String termKey = t.field() + ":" + t.text();
        if (this.thresholds.containsKey(termKey)) {
            this.curThr = this.thresholds.get(termKey).floatValue();
        } else if (this.thresholds.containsKey(t.field())) {
            this.curThr = this.thresholds.get(t.field()).floatValue();
        }
        int df = this.in.docFreq(t);
        int count = Math.round((float)df * this.curThr);
        if (count < 100) {
            count = 100;
        }
        TopScoreDocCollector collector = TopScoreDocCollector.create((int)count, (boolean)true);
        TermQuery tq = new TermQuery(t);
        this.is.search((Query)tq, (Collector)collector);
        this.docs = collector.topDocs().scoreDocs;
        Arrays.sort(this.docs, ByDocComparator.INSTANCE);
        this.docsPos = 0;
    }

    @Override
    public boolean pruneAllPositions(TermPositions termPositions, Term t) throws IOException {
        if (this.docsPos >= this.docs.length) {
            return true;
        }
        while (this.docsPos < this.docs.length - 1 && termPositions.doc() > this.docs[this.docsPos].doc) {
            ++this.docsPos;
        }
        if (termPositions.doc() == this.docs[this.docsPos].doc) {
            ++this.docsPos;
            return false;
        }
        if (termPositions.doc() < this.docs[this.docsPos].doc) {
            return true;
        }
        throw new IOException("termPositions.doc > docs[docsPos].doc");
    }

    @Override
    public int pruneTermVectorTerms(int docNumber, String field, String[] terms, int[] freqs, TermFreqVector tfv) throws IOException {
        return 0;
    }

    @Override
    public int pruneSomePositions(int docNum, int[] positions, Term curTerm) {
        return 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ByDocComparator
    implements Comparator<ScoreDoc> {
        public static final ByDocComparator INSTANCE = new ByDocComparator();

        @Override
        public int compare(ScoreDoc o1, ScoreDoc o2) {
            return o1.doc - o2.doc;
        }
    }
}

