/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index.pruning;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.index.pruning.TermPruningPolicy;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DefaultSimilarity;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopScoreDocCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CarmelTopKTermPruningPolicy
extends TermPruningPolicy {
    public static final int DEFAULT_TOP_K = 10;
    public static final int DEFAULT_R = 1;
    public static final float DEFAULT_EPSILON = 0.001f;
    private int docsPos = 0;
    private int k;
    private ScoreDoc[] docs = null;
    private IndexSearcher is;
    private boolean noPruningForCurrentTerm;
    private float scoreDelta;

    public CarmelTopKTermPruningPolicy(IndexReader in, Map<String, Integer> fieldFlags) {
        this(in, fieldFlags, 10, 0.001f, 1, null);
    }

    public CarmelTopKTermPruningPolicy(IndexReader in, Map<String, Integer> fieldFlags, int k, float epsilon, int r, Similarity sim) {
        super(in, fieldFlags);
        this.k = k;
        this.is = new IndexSearcher(in);
        this.is.setSimilarity((Similarity)(sim != null ? sim : new DefaultSimilarity()));
        this.scoreDelta = epsilon * (float)r;
    }

    @Override
    public boolean pruneTermEnum(TermEnum te) throws IOException {
        return false;
    }

    @Override
    public void initPositionsTerm(TermPositions tp, Term t) throws IOException {
        int df = this.in.docFreq(t);
        boolean bl = this.noPruningForCurrentTerm = df <= this.k;
        if (this.noPruningForCurrentTerm) {
            return;
        }
        int k2 = Math.min(2 * this.k, this.k + 100);
        k2 = Math.min(k2, df);
        TopScoreDocCollector collector = TopScoreDocCollector.create((int)k2, (boolean)true);
        TermQuery tq = new TermQuery(t);
        this.is.search((Query)tq, (Collector)collector);
        this.docs = collector.topDocs().scoreDocs;
        float threshold = this.docs[this.k - 1].score - this.scoreDelta;
        int nLast = k2 - 1;
        nLast = Math.min(nLast, this.docs.length - 1);
        if (this.docs[nLast].score < threshold) {
            int n = nLast;
            while (this.docs[n - 1].score < threshold) {
                --n;
            }
            ScoreDoc[] subset = new ScoreDoc[n];
            System.arraycopy(this.docs, 0, subset, 0, n);
            this.docs = subset;
            Arrays.sort(this.docs, ByDocComparator.INSTANCE);
        } else {
            ThresholdCollector thresholdCollector = new ThresholdCollector(threshold);
            this.is.search((Query)tq, (Collector)thresholdCollector);
            this.docs = thresholdCollector.scoreDocs.toArray(new ScoreDoc[0]);
        }
        this.docsPos = 0;
    }

    @Override
    public boolean pruneAllPositions(TermPositions termPositions, Term t) throws IOException {
        if (this.noPruningForCurrentTerm) {
            return false;
        }
        if (this.docsPos >= this.docs.length) {
            return true;
        }
        while (this.docsPos < this.docs.length - 1 && termPositions.doc() > this.docs[this.docsPos].doc) {
            ++this.docsPos;
        }
        if (termPositions.doc() == this.docs[this.docsPos].doc) {
            ++this.docsPos;
            return false;
        }
        if (termPositions.doc() < this.docs[this.docsPos].doc) {
            return true;
        }
        throw new IOException("termPositions.doc > docs[docsPos].doc");
    }

    @Override
    public int pruneTermVectorTerms(int docNumber, String field, String[] terms, int[] freqs, TermFreqVector tfv) throws IOException {
        return 0;
    }

    @Override
    public int pruneSomePositions(int docNum, int[] positions, Term curTerm) {
        return 0;
    }

    private static class ThresholdCollector
    extends Collector {
        private ArrayList<ScoreDoc> scoreDocs = new ArrayList();
        private Scorer scorer;
        private float threshold;
        private int docBase;

        public ThresholdCollector(float threshold) {
            this.threshold = threshold;
        }

        public boolean acceptsDocsOutOfOrder() {
            return false;
        }

        public void collect(int doc) throws IOException {
            float score = this.scorer.score();
            if (score >= this.threshold) {
                this.scoreDocs.add(new ScoreDoc(this.docBase + doc, score));
            }
        }

        public void setNextReader(IndexReader reader, int docBase) throws IOException {
            this.docBase = docBase;
        }

        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ByDocComparator
    implements Comparator<ScoreDoc> {
        public static final ByDocComparator INSTANCE = new ByDocComparator();

        @Override
        public int compare(ScoreDoc o1, ScoreDoc o2) {
            return o1.doc - o2.doc;
        }
    }
}

