/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FilterIndexReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.SegmentTermPositionVector;
import org.apache.lucene.index.SegmentTermVector;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositionVector;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.index.TermVectorOffsetInfo;
import org.apache.lucene.index.pruning.StorePruningPolicy;
import org.apache.lucene.index.pruning.TermPruningPolicy;

public class PruningReader
extends FilterIndexReader {
    private static final Logger LOG = Logger.getLogger(PruningReader.class.getName());
    protected int docCount;
    protected int vecCount;
    protected int termCount;
    protected int delTermCount;
    protected int prunedVecCount;
    protected int delVecCount;
    protected TermPruningPolicy termPolicy;
    protected StorePruningPolicy storePolicy;

    public PruningReader(IndexReader in, StorePruningPolicy storePolicy, TermPruningPolicy termPolicy) {
        super(in);
        this.termPolicy = termPolicy;
        assert (termPolicy != null);
        this.storePolicy = storePolicy;
    }

    public IndexReader[] getSequentialSubReaders() {
        IndexReader[] orig = super.getSequentialSubReaders();
        if (orig == null) {
            return null;
        }
        IndexReader[] res = new IndexReader[orig.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = new PruningReader(orig[i], this.storePolicy, this.termPolicy);
        }
        return res;
    }

    public Document document(int n, FieldSelector fieldSelector) throws CorruptIndexException, IOException {
        ++this.docCount;
        if (this.docCount % 10000 == 0) {
            LOG.info(" - stored fields: " + this.docCount + " docs.");
        }
        if (this.storePolicy != null) {
            return this.storePolicy.pruneDocument(n, fieldSelector);
        }
        return this.in.document(n, fieldSelector);
    }

    public FieldInfos getFieldInfos() {
        FieldInfos res = super.getFieldInfos();
        if (this.storePolicy == null) {
            return res;
        }
        return this.storePolicy.getFieldInfos(res);
    }

    public TermFreqVector[] getTermFreqVectors(int docNumber) throws IOException {
        TermFreqVector[] vectors = super.getTermFreqVectors(docNumber);
        if (vectors == null) {
            return null;
        }
        ArrayList<TermFreqVector> newVectors = new ArrayList<TermFreqVector>();
        for (TermFreqVector v : vectors) {
            if (v == null) continue;
            if (this.termPolicy.pruneWholeTermVector(docNumber, v.getField())) {
                ++this.delVecCount;
                if (this.delVecCount % 10000 != 0) continue;
                LOG.info(" - deleted vectors: " + this.delVecCount);
                continue;
            }
            if (v.size() == 0) continue;
            String[] terms = v.getTerms();
            int[] freqs = v.getTermFrequencies();
            int removed = this.termPolicy.pruneTermVectorTerms(docNumber, v.getField(), terms, freqs, v);
            if (removed <= 0 || removed >= terms.length) continue;
            String[] newTerms = new String[terms.length - removed];
            int[] newFreqs = new int[terms.length - removed];
            int j = 0;
            for (int i = 0; i < terms.length; ++i) {
                if (terms[i] == null) continue;
                newTerms[j] = terms[i];
                newFreqs[j] = freqs[i];
                ++j;
            }
            if (v instanceof TermPositionVector) {
                TermVectorOffsetInfo[][] offsets = new TermVectorOffsetInfo[terms.length - removed][];
                boolean withOffsets = false;
                j = 0;
                for (int i = 0; i < terms.length; ++i) {
                    if (terms[i] == null) continue;
                    offsets[j] = ((TermPositionVector)v).getOffsets(i);
                    if (offsets[j] != null && offsets[j] != TermVectorOffsetInfo.EMPTY_OFFSET_INFO) {
                        withOffsets = true;
                    }
                    ++j;
                }
                j = 0;
                int[][] positions = new int[terms.length - removed][];
                boolean withPositions = false;
                for (int i = 0; i < terms.length; ++i) {
                    if (terms[i] == null) continue;
                    positions[j] = ((TermPositionVector)v).getTermPositions(i);
                    if (positions[j] != null && positions[j].length > 0) {
                        withPositions = true;
                    }
                    ++j;
                }
                v = new SegmentTermPositionVector(v.getField(), newTerms, newFreqs, (int[][])(withPositions ? positions : (int[][])null), (TermVectorOffsetInfo[][])(withOffsets ? offsets : (TermVectorOffsetInfo[][])null));
            } else {
                v = new SegmentTermVector(v.getField(), newTerms, newFreqs);
            }
            newVectors.add(v);
        }
        ++this.vecCount;
        if (this.vecCount % 10000 == 0) {
            LOG.info(" - vectors: " + this.vecCount + " docs.");
        }
        if (newVectors.size() == 0) {
            ++this.prunedVecCount;
            if (this.prunedVecCount % 1000 == 0) {
                LOG.info(" - deleted pruned vectors: " + this.prunedVecCount);
            }
            return null;
        }
        return newVectors.toArray(new TermFreqVector[newVectors.size()]);
    }

    public TermPositions termPositions() throws IOException {
        return new PruningTermPositions(this.in.termPositions());
    }

    public TermEnum terms() throws IOException {
        return new PruningTermEnum(this.in.terms());
    }

    private class PruningTermPositions
    extends FilterIndexReader.FilterTermPositions {
        protected Term curTerm;
        protected int[] positions;
        protected TermPositions tp;
        protected int curFreq;
        protected int posPos;

        private PruningTermPositions(TermPositions in) {
            super(in);
            this.curTerm = null;
            this.tp = in;
        }

        public void seek(Term t) throws IOException {
            super.seek(t);
            this.informPolicy(t);
        }

        public void seek(TermEnum termEnum) throws IOException {
            super.seek(termEnum);
            this.informPolicy(termEnum.term());
        }

        private void informPolicy(Term t) throws IOException {
            PruningReader.this.termPolicy.initPositionsTerm(this.tp, t);
            this.curTerm = new Term(t.field(), t.text());
        }

        public boolean next() throws IOException {
            do {
                this.positions = null;
                if (super.next()) continue;
                return false;
            } while (PruningReader.this.termPolicy.pruneAllPositions(this.tp, this.curTerm));
            this.positions = new int[this.tp.freq()];
            for (int i = 0; i < this.positions.length; ++i) {
                this.positions[i] = this.tp.nextPosition();
            }
            int pruned = PruningReader.this.termPolicy.pruneSomePositions(this.tp.doc(), this.positions, this.curTerm);
            if (pruned > 0) {
                int[] newPositions = new int[this.positions.length - pruned];
                int j = 0;
                for (int i = 0; i < this.positions.length; ++i) {
                    if (this.positions[i] < 0) continue;
                    newPositions[j++] = this.positions[i];
                }
                this.positions = newPositions;
            }
            this.curFreq = this.positions.length;
            this.posPos = 0;
            return true;
        }

        public int nextPosition() throws IOException {
            return this.positions[this.posPos++];
        }

        public int freq() {
            return this.curFreq;
        }

        public boolean isPayloadAvailable() {
            if (!super.isPayloadAvailable()) {
                return false;
            }
            return !PruningReader.this.termPolicy.prunePayload((TermPositions)this.in, this.curTerm);
        }
    }

    private class PruningTermEnum
    extends FilterIndexReader.FilterTermEnum {
        private PruningTermEnum(TermEnum in) {
            super(in);
        }

        public boolean next() throws IOException {
            while (true) {
                if (!super.next()) {
                    return false;
                }
                ++PruningReader.this.termCount;
                if (PruningReader.this.termCount % 50000 == 0) {
                    LOG.info(" - terms: " + PruningReader.this.termCount + " (" + this.term() + "), deleted: " + PruningReader.this.delTermCount);
                }
                if (!PruningReader.this.termPolicy.pruneAllFieldPostings(this.term().field()) && !PruningReader.this.termPolicy.pruneTermEnum(this.in)) break;
                ++PruningReader.this.delTermCount;
            }
            return true;
        }
    }
}

