/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.monitor;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.monitor.CandidateMatcher;
import org.apache.lucene.monitor.DocumentBatch;
import org.apache.lucene.monitor.ForceNoBulkScoringQuery;
import org.apache.lucene.monitor.MatcherFactory;
import org.apache.lucene.monitor.MatchingQueries;
import org.apache.lucene.monitor.MonitorConfiguration;
import org.apache.lucene.monitor.MonitorQuery;
import org.apache.lucene.monitor.MonitorUpdateListener;
import org.apache.lucene.monitor.MultiMatchingQueries;
import org.apache.lucene.monitor.Presearcher;
import org.apache.lucene.monitor.PresearcherMatches;
import org.apache.lucene.monitor.QueryCacheEntry;
import org.apache.lucene.monitor.QueryIndex;
import org.apache.lucene.monitor.QueryMatch;
import org.apache.lucene.monitor.ReadonlyQueryIndex;
import org.apache.lucene.monitor.TermFilteredPresearcher;
import org.apache.lucene.monitor.WritableQueryIndex;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Matches;
import org.apache.lucene.search.MatchesIterator;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

public class Monitor
implements Closeable {
    protected final Presearcher presearcher;
    private final Analyzer analyzer;
    private final QueryIndex queryIndex;
    private final long commitBatchSize;

    public Monitor(Analyzer analyzer) throws IOException {
        this(analyzer, new TermFilteredPresearcher());
    }

    public Monitor(Analyzer analyzer, Presearcher presearcher) throws IOException {
        this(analyzer, presearcher, new MonitorConfiguration());
    }

    public Monitor(Analyzer analyzer, MonitorConfiguration config) throws IOException {
        this(analyzer, new TermFilteredPresearcher(), config);
    }

    public Monitor(Analyzer analyzer, Presearcher presearcher, MonitorConfiguration configuration) throws IOException {
        this.analyzer = analyzer;
        this.presearcher = presearcher;
        this.queryIndex = configuration.isReadOnly() ? new ReadonlyQueryIndex(configuration) : new WritableQueryIndex(configuration, presearcher);
        this.commitBatchSize = configuration.getQueryUpdateBufferSize();
    }

    public void addQueryIndexUpdateListener(MonitorUpdateListener listener) {
        this.queryIndex.addListener(listener);
    }

    public QueryCacheStats getQueryCacheStats() throws IOException {
        return new QueryCacheStats(this.queryIndex.numDocs(), this.queryIndex.cacheSize(), this.queryIndex.getLastPurged());
    }

    public void purgeCache() throws IOException {
        this.queryIndex.purgeCache();
    }

    @Override
    public void close() throws IOException {
        this.queryIndex.close();
    }

    public void register(Iterable<MonitorQuery> queries) throws IOException {
        ArrayList<MonitorQuery> updates = new ArrayList<MonitorQuery>();
        for (MonitorQuery query : queries) {
            updates.add(query);
            if ((long)updates.size() <= this.commitBatchSize) continue;
            this.commit(updates);
            updates.clear();
        }
        this.commit(updates);
    }

    private void commit(List<MonitorQuery> updates) throws IOException {
        this.queryIndex.commit(updates);
    }

    public void register(MonitorQuery ... queries) throws IOException {
        this.register(Arrays.asList(queries));
    }

    public void deleteById(List<String> queryIds) throws IOException {
        this.queryIndex.deleteQueries(queryIds);
    }

    public void deleteById(String ... queryIds) throws IOException {
        this.deleteById(Arrays.asList(queryIds));
    }

    public void clear() throws IOException {
        this.queryIndex.clear();
    }

    public <T extends QueryMatch> MultiMatchingQueries<T> match(Document[] docs, MatcherFactory<T> factory) throws IOException {
        try (DocumentBatch batch = DocumentBatch.of(this.analyzer, docs);){
            LeafReader reader = (LeafReader)batch.get();
            CandidateMatcher<T> matcher = factory.createMatcher(new IndexSearcher((IndexReader)batch.get()));
            StandardQueryCollector<T> collector = new StandardQueryCollector<T>(matcher);
            long buildTime = this.queryIndex.search(t -> this.presearcher.buildQuery(reader, t), collector);
            MultiMatchingQueries<T> multiMatchingQueries = matcher.finish(buildTime, collector.queryCount);
            return multiMatchingQueries;
        }
    }

    public <T extends QueryMatch> MatchingQueries<T> match(Document doc, MatcherFactory<T> factory) throws IOException {
        return this.match(new Document[]{doc}, factory).singleton();
    }

    public MonitorQuery getQuery(String queryId) throws IOException {
        return this.queryIndex.getQuery(queryId);
    }

    public int getDisjunctCount() throws IOException {
        return this.queryIndex.numDocs();
    }

    public int getQueryCount() throws IOException {
        return this.getQueryIds().size();
    }

    public Set<String> getQueryIds() throws IOException {
        HashSet<String> ids = new HashSet<String>();
        this.queryIndex.scan((id, query, dataValues) -> ids.add(id));
        return ids;
    }

    public <T extends QueryMatch> PresearcherMatches<T> debug(Document[] docs, MatcherFactory<T> factory) throws IOException {
        try (DocumentBatch batch = DocumentBatch.of(this.analyzer, docs);){
            LeafReader reader = (LeafReader)batch.get();
            IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
            searcher.setQueryCache(null);
            PresearcherQueryCollector<T> collector = new PresearcherQueryCollector<T>(factory.createMatcher(searcher));
            long buildTime = this.queryIndex.search(t -> new ForceNoBulkScoringQuery(this.presearcher.buildQuery(reader, t)), collector);
            PresearcherMatches<T> presearcherMatches = collector.getMatches(buildTime);
            return presearcherMatches;
        }
    }

    public <T extends QueryMatch> PresearcherMatches<T> debug(Document doc, MatcherFactory<T> factory) throws IOException {
        return this.debug(new Document[]{doc}, factory);
    }

    private class PresearcherQueryCollector<T extends QueryMatch>
    extends StandardQueryCollector<T> {
        final Map<String, StringBuilder> matchingTerms;

        private PresearcherQueryCollector(CandidateMatcher<T> matcher) {
            super(matcher);
            this.matchingTerms = new HashMap<String, StringBuilder>();
        }

        public PresearcherMatches<T> getMatches(long buildTime) {
            return new PresearcherMatches(this.matchingTerms, this.matcher.finish(buildTime, this.queryCount));
        }

        @Override
        public ScoreMode scoreMode() {
            return ScoreMode.COMPLETE;
        }

        @Override
        public void matchQuery(String id, QueryCacheEntry query, QueryIndex.DataValues dataValues) throws IOException {
            Weight w = ((Scorer)dataValues.scorer).getWeight();
            Matches matches = w.matches(dataValues.ctx, dataValues.scorer.docID());
            for (String field : matches) {
                MatchesIterator mi = matches.getMatches(field);
                while (mi.next()) {
                    this.matchingTerms.computeIfAbsent(id, i -> new StringBuilder()).append(" ").append(mi.getQuery());
                }
            }
            super.matchQuery(id, query, dataValues);
        }
    }

    private static class StandardQueryCollector<T extends QueryMatch>
    implements QueryIndex.QueryCollector {
        final CandidateMatcher<T> matcher;
        int queryCount = 0;

        private StandardQueryCollector(CandidateMatcher<T> matcher) {
            this.matcher = matcher;
        }

        @Override
        public void matchQuery(String id, QueryCacheEntry query, QueryIndex.DataValues dataValues) throws IOException {
            if (query == null) {
                return;
            }
            try {
                ++this.queryCount;
                this.matcher.matchQuery(id, query.matchQuery, query.metadata);
            }
            catch (Exception e) {
                this.matcher.reportError(id, e);
            }
        }
    }

    public static class QueryCacheStats {
        public final int queries;
        public final int cachedQueries;
        public final long lastPurged;

        public QueryCacheStats(int queries, int cachedQueries, long lastPurged) {
            this.queries = queries;
            this.cachedQueries = cachedQueries;
            this.lastPurged = lastPurged;
        }
    }
}

