/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.monitor;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Matches;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

class ForceNoBulkScoringQuery
extends Query {
    private final Query inner;

    public ForceNoBulkScoringQuery(Query inner) {
        this.inner = inner;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query rewritten = this.inner.rewrite(reader);
        if (rewritten != this.inner) {
            return new ForceNoBulkScoringQuery(rewritten);
        }
        return super.rewrite(reader);
    }

    public void visit(QueryVisitor visitor) {
        this.inner.visit(visitor);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ForceNoBulkScoringQuery that = (ForceNoBulkScoringQuery)((Object)o);
        return Objects.equals(this.inner, that.inner);
    }

    public int hashCode() {
        return Objects.hash(this.inner);
    }

    public Query getWrappedQuery() {
        return this.inner;
    }

    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        final Weight innerWeight = this.inner.createWeight(searcher, scoreMode, boost);
        return new Weight(this){

            public boolean isCacheable(LeafReaderContext ctx) {
                return innerWeight.isCacheable(ctx);
            }

            public Explanation explain(LeafReaderContext leafReaderContext, int i) throws IOException {
                return innerWeight.explain(leafReaderContext, i);
            }

            public Scorer scorer(LeafReaderContext leafReaderContext) throws IOException {
                return innerWeight.scorer(leafReaderContext);
            }

            public Matches matches(LeafReaderContext context, int doc) throws IOException {
                return innerWeight.matches(context, doc);
            }
        };
    }

    public String toString(String s) {
        return "NoBulkScorer(" + this.inner.toString(s) + ")";
    }
}

