/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.monitor;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.function.BiPredicate;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.monitor.MonitorConfiguration;
import org.apache.lucene.monitor.MonitorQuery;
import org.apache.lucene.monitor.MonitorQuerySerializer;
import org.apache.lucene.monitor.MonitorUpdateListener;
import org.apache.lucene.monitor.QueryCacheEntry;
import org.apache.lucene.monitor.QueryDecomposer;
import org.apache.lucene.monitor.QueryIndex;
import org.apache.lucene.monitor.TermsHashBuilder;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.NamedThreadFactory;

class ReadonlyQueryIndex
extends QueryIndex {
    private final ScheduledExecutorService refreshExecutor;

    public ReadonlyQueryIndex(MonitorConfiguration configuration) throws IOException {
        if (configuration.getDirectoryProvider() == null) {
            throw new IllegalStateException("You must specify a Directory when configuring a Monitor as read-only.");
        }
        Directory directory = (Directory)configuration.getDirectoryProvider().get();
        this.manager = new SearcherManager(directory, (SearcherFactory)new TermsHashBuilder(this.termFilters));
        this.decomposer = configuration.getQueryDecomposer();
        this.serializer = configuration.getQuerySerializer();
        this.refreshExecutor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("cache-purge"));
        long refreshFrequency = configuration.getPurgeFrequency();
        this.refreshExecutor.scheduleAtFixedRate(() -> {
            try {
                this.purgeCache();
            }
            catch (IOException e) {
                this.listeners.forEach(l -> l.onPurgeError(e));
            }
        }, refreshFrequency, refreshFrequency, configuration.getPurgeFrequencyUnits());
    }

    @Override
    public void commit(List<MonitorQuery> updates) throws IOException {
        throw new UnsupportedOperationException("Monitor is readOnly cannot commit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long search(QueryIndex.QueryBuilder queryBuilder, QueryIndex.QueryCollector matcher) throws IOException {
        IndexSearcher searcher = null;
        try {
            searcher = (IndexSearcher)this.manager.acquire();
            LazyMonitorQueryCollector collector = new LazyMonitorQueryCollector(matcher, this.serializer, this.decomposer);
            long buildTime = System.nanoTime();
            Query query = queryBuilder.buildQuery((BiPredicate)this.termFilters.get(searcher.getIndexReader().getReaderCacheHelper().getKey()));
            buildTime = System.nanoTime() - buildTime;
            searcher.search(query, (Collector)collector);
            long l = buildTime;
            return l;
        }
        finally {
            if (searcher != null) {
                this.manager.release((Object)searcher);
            }
        }
    }

    @Override
    public void purgeCache() throws IOException {
        this.manager.maybeRefresh();
        this.listeners.forEach(MonitorUpdateListener::onPurge);
    }

    @Override
    void purgeCache(QueryIndex.CachePopulator populator) {
        throw new UnsupportedOperationException("Monitor is readOnly, it has no cache");
    }

    @Override
    public void close() throws IOException {
        this.refreshExecutor.shutdown();
        IOUtils.close((Closeable[])new Closeable[]{this.manager});
    }

    @Override
    public int numDocs() throws IOException {
        int numDocs;
        IndexSearcher searcher = null;
        try {
            searcher = (IndexSearcher)this.manager.acquire();
            numDocs = searcher.getIndexReader().numDocs();
        }
        finally {
            if (searcher != null) {
                this.manager.release((Object)searcher);
            }
        }
        return numDocs;
    }

    @Override
    public int cacheSize() {
        return -1;
    }

    @Override
    public void deleteQueries(List<String> ids) throws IOException {
        throw new UnsupportedOperationException("Monitor is readOnly cannot delete queries");
    }

    @Override
    public void clear() throws IOException {
        throw new UnsupportedOperationException("Monitor is readOnly cannot clear");
    }

    @Override
    public long getLastPurged() {
        return -1L;
    }

    static final class LazyMonitorQueryCollector
    extends SimpleCollector {
        private final QueryIndex.QueryCollector matcher;
        private final QueryIndex.DataValues dataValues = new QueryIndex.DataValues();
        private final MonitorQuerySerializer serializer;
        private final QueryDecomposer decomposer;

        LazyMonitorQueryCollector(QueryIndex.QueryCollector matcher, MonitorQuerySerializer serializer, QueryDecomposer decomposer) {
            this.matcher = matcher;
            this.serializer = serializer;
            this.decomposer = decomposer;
        }

        public void setScorer(Scorable scorer) {
            this.dataValues.scorer = scorer;
        }

        public void collect(int doc) throws IOException {
            this.dataValues.advanceTo(doc);
            BytesRef cache_id = this.dataValues.cacheId.lookupOrd(this.dataValues.cacheId.ordValue());
            BytesRef query_id = this.dataValues.queryId.lookupOrd(this.dataValues.queryId.ordValue());
            MonitorQuery mq = this.serializer.deserialize(this.dataValues.mq.binaryValue());
            QueryCacheEntry query = QueryCacheEntry.decompose(mq, this.decomposer).stream().filter(queryCacheEntry -> queryCacheEntry.cacheId.equals(cache_id.utf8ToString())).findFirst().orElseThrow(() -> new IllegalStateException("Cached queries not found"));
            this.matcher.matchQuery(query_id.utf8ToString(), query, this.dataValues);
        }

        public void doSetNextReader(LeafReaderContext context) throws IOException {
            this.dataValues.cacheId = context.reader().getSortedDocValues("_cache_id");
            this.dataValues.queryId = context.reader().getSortedDocValues("_query_id");
            this.dataValues.mq = context.reader().getBinaryDocValues("_mq");
            this.dataValues.ctx = context;
        }

        public ScoreMode scoreMode() {
            return this.matcher.scoreMode();
        }
    }
}

