/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.monitor;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.monitor.MonitorQuery;
import org.apache.lucene.monitor.MonitorQuerySerializer;
import org.apache.lucene.monitor.MonitorUpdateListener;
import org.apache.lucene.monitor.QueryCacheEntry;
import org.apache.lucene.monitor.QueryDecomposer;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefHash;

abstract class QueryIndex
implements Closeable {
    protected SearcherManager manager;
    protected QueryDecomposer decomposer;
    protected MonitorQuerySerializer serializer;
    final Map<IndexReader.CacheKey, QueryTermFilter> termFilters = new HashMap<IndexReader.CacheKey, QueryTermFilter>();
    protected final List<MonitorUpdateListener> listeners = new ArrayList<MonitorUpdateListener>();

    QueryIndex() {
    }

    abstract void commit(List<MonitorQuery> var1) throws IOException;

    public MonitorQuery getQuery(String queryId) throws IOException {
        if (this.serializer == null) {
            throw new IllegalStateException("Cannot get queries from an index with no MonitorQuerySerializer");
        }
        BytesRef[] bytesHolder = new BytesRef[1];
        this.search((Query)new TermQuery(new Term("_query_id", queryId)), (String id, QueryCacheEntry query, DataValues dataValues) -> {
            bytesHolder[0] = dataValues.mq.binaryValue();
        });
        return this.serializer.deserialize(bytesHolder[0]);
    }

    public void scan(QueryCollector matcher) throws IOException {
        this.search((Query)new MatchAllDocsQuery(), matcher);
    }

    long search(Query query, QueryCollector matcher) throws IOException {
        QueryBuilder builder = termFilter -> query;
        return this.search(builder, matcher);
    }

    abstract long search(QueryBuilder var1, QueryCollector var2) throws IOException;

    public abstract void purgeCache() throws IOException;

    abstract void purgeCache(CachePopulator var1) throws IOException;

    abstract int numDocs() throws IOException;

    public abstract int cacheSize();

    abstract void deleteQueries(List<String> var1) throws IOException;

    abstract void clear() throws IOException;

    public abstract long getLastPurged();

    public void addListener(MonitorUpdateListener listener) {
        this.listeners.add(listener);
    }

    static class QueryTermFilter
    implements BiPredicate<String, BytesRef> {
        private final Map<String, BytesRefHash> termsHash = new HashMap<String, BytesRefHash>();

        QueryTermFilter(IndexReader reader) throws IOException {
            for (LeafReaderContext ctx : reader.leaves()) {
                for (FieldInfo fi : ctx.reader().getFieldInfos()) {
                    BytesRef term;
                    BytesRefHash terms = this.termsHash.computeIfAbsent(fi.name, f -> new BytesRefHash());
                    Terms t = ctx.reader().terms(fi.name);
                    if (t == null) continue;
                    TermsEnum te = t.iterator();
                    while ((term = te.next()) != null) {
                        terms.add(term);
                    }
                }
            }
        }

        @Override
        public boolean test(String field, BytesRef term) {
            BytesRefHash bytes = this.termsHash.get(field);
            if (bytes == null) {
                return false;
            }
            return bytes.find(term) != -1;
        }
    }

    public static final class DataValues {
        SortedDocValues queryId;
        SortedDocValues cacheId;
        BinaryDocValues mq;
        Scorable scorer;
        LeafReaderContext ctx;

        void advanceTo(int doc) throws IOException {
            assert (this.scorer.docID() == doc);
            this.queryId.advanceExact(doc);
            this.cacheId.advanceExact(doc);
            if (this.mq != null) {
                this.mq.advanceExact(doc);
            }
        }
    }

    static interface CachePopulator {
        public void populateCacheWithIndex(Map<String, QueryCacheEntry> var1) throws IOException;
    }

    static interface QueryBuilder {
        public Query buildQuery(BiPredicate<String, BytesRef> var1) throws IOException;
    }

    public static interface QueryCollector {
        public void matchQuery(String var1, QueryCacheEntry var2, DataValues var3) throws IOException;

        default public ScoreMode scoreMode() {
            return ScoreMode.COMPLETE_NO_SCORES;
        }
    }

    static final class FIELDS {
        static final String query_id = "_query_id";
        static final String cache_id = "_cache_id";
        static final String mq = "_mq";

        FIELDS() {
        }
    }
}

