/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.monitor;

import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.TieredMergePolicy;
import org.apache.lucene.monitor.MonitorQuerySerializer;
import org.apache.lucene.monitor.QueryDecomposer;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class MonitorConfiguration {
    private int queryUpdateBufferSize = 5000;
    private long purgeFrequency = 5L;
    private TimeUnit purgeFrequencyUnits = TimeUnit.MINUTES;
    private QueryDecomposer queryDecomposer = new QueryDecomposer();
    private Path indexPath = null;
    private MonitorQuerySerializer serializer;

    private static IndexWriterConfig defaultIndexWriterConfig() {
        IndexWriterConfig iwc = new IndexWriterConfig((Analyzer)new KeywordAnalyzer());
        TieredMergePolicy mergePolicy = new TieredMergePolicy();
        mergePolicy.setSegmentsPerTier(4.0);
        iwc.setMergePolicy((MergePolicy)mergePolicy);
        iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        return iwc;
    }

    public MonitorConfiguration setIndexPath(Path indexPath, MonitorQuerySerializer serializer) {
        this.indexPath = indexPath;
        this.serializer = serializer;
        return this;
    }

    public IndexWriter buildIndexWriter() throws IOException {
        ByteBuffersDirectory directory = this.indexPath == null ? new ByteBuffersDirectory() : FSDirectory.open((Path)this.indexPath);
        return new IndexWriter((Directory)directory, this.getIndexWriterConfig());
    }

    protected IndexWriterConfig getIndexWriterConfig() {
        return MonitorConfiguration.defaultIndexWriterConfig();
    }

    public MonitorQuerySerializer getQuerySerializer() {
        return this.serializer;
    }

    public MonitorConfiguration setQueryDecomposer(QueryDecomposer queryDecomposer) {
        this.queryDecomposer = queryDecomposer;
        return this;
    }

    public QueryDecomposer getQueryDecomposer() {
        return this.queryDecomposer;
    }

    public MonitorConfiguration setPurgeFrequency(long frequency, TimeUnit units) {
        this.purgeFrequency = frequency;
        this.purgeFrequencyUnits = units;
        return this;
    }

    public long getPurgeFrequency() {
        return this.purgeFrequency;
    }

    public TimeUnit getPurgeFrequencyUnits() {
        return this.purgeFrequencyUnits;
    }

    public MonitorConfiguration setQueryUpdateBufferSize(int size) {
        this.queryUpdateBufferSize = size;
        return this;
    }

    public int getQueryUpdateBufferSize() {
        return this.queryUpdateBufferSize;
    }
}

