/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.monitor;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiPredicate;
import org.apache.lucene.document.BinaryDocValuesField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.monitor.MonitorConfiguration;
import org.apache.lucene.monitor.MonitorQuery;
import org.apache.lucene.monitor.MonitorQuerySerializer;
import org.apache.lucene.monitor.Presearcher;
import org.apache.lucene.monitor.QueryCacheEntry;
import org.apache.lucene.monitor.QueryDecomposer;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.IOUtils;

class QueryIndex
implements Closeable {
    private final IndexWriter writer;
    private final SearcherManager manager;
    private final QueryDecomposer decomposer;
    private final MonitorQuerySerializer serializer;
    private final Presearcher presearcher;
    private volatile Map<String, QueryCacheEntry> purgeCache = null;
    private final ReadWriteLock purgeLock = new ReentrantReadWriteLock();
    private final Object commitLock = new Object();
    private volatile ConcurrentMap<String, QueryCacheEntry> queries = new ConcurrentHashMap<String, QueryCacheEntry>();
    final Map<IndexReader.CacheKey, QueryTermFilter> termFilters = new HashMap<IndexReader.CacheKey, QueryTermFilter>();
    private static final BytesRef EMPTY = new BytesRef();

    QueryIndex(MonitorConfiguration config, Presearcher presearcher) throws IOException {
        this.writer = config.buildIndexWriter();
        this.manager = new SearcherManager(this.writer, true, true, (SearcherFactory)new TermsHashBuilder());
        this.decomposer = config.getQueryDecomposer();
        this.serializer = config.getQuerySerializer();
        this.presearcher = presearcher;
        this.populateQueryCache(this.serializer, this.decomposer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateQueryCache(MonitorQuerySerializer serializer, QueryDecomposer decomposer) throws IOException {
        if (serializer == null) {
            IndexSearcher searcher = (IndexSearcher)this.manager.acquire();
            try {
                if (searcher.count((Query)new MatchAllDocsQuery()) != 0) {
                    throw new IllegalStateException("Attempting to open a non-empty monitor query index with no MonitorQuerySerializer");
                }
            }
            finally {
                this.manager.release((Object)searcher);
            }
            return;
        }
        HashSet ids = new HashSet();
        ArrayList errors = new ArrayList();
        this.purgeCache(newCache -> this.scan((id, cacheEntry, dataValues) -> {
            if (ids.contains(id)) {
                return;
            }
            ids.add(id);
            try {
                MonitorQuery mq = serializer.deserialize(dataValues.mq.binaryValue());
                for (QueryCacheEntry entry : QueryCacheEntry.decompose(mq, decomposer)) {
                    newCache.put(entry.cacheId, entry);
                }
            }
            catch (Exception e) {
                errors.add(e);
            }
        }));
        if (errors.size() > 0) {
            IllegalStateException e = new IllegalStateException("Couldn't parse some queries from the index");
            for (Exception parseError : errors) {
                e.addSuppressed(parseError);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commit(List<MonitorQuery> updates) throws IOException {
        List<Indexable> indexables = this.buildIndexables(updates);
        Object object = this.commitLock;
        synchronized (object) {
            this.purgeLock.readLock().lock();
            try {
                if (indexables.size() > 0) {
                    HashSet<String> ids = new HashSet<String>();
                    for (Indexable update : indexables) {
                        ids.add(update.queryCacheEntry.queryId);
                    }
                    for (String id : ids) {
                        this.writer.deleteDocuments(new Term[]{new Term("_query_id", id)});
                    }
                    for (Indexable update : indexables) {
                        this.queries.put(update.queryCacheEntry.cacheId, update.queryCacheEntry);
                        this.writer.addDocument((Iterable)update.document);
                        if (this.purgeCache == null) continue;
                        this.purgeCache.put(update.queryCacheEntry.cacheId, update.queryCacheEntry);
                    }
                }
                this.writer.commit();
                this.manager.maybeRefresh();
            }
            finally {
                this.purgeLock.readLock().unlock();
            }
        }
    }

    private List<Indexable> buildIndexables(List<MonitorQuery> updates) {
        ArrayList<Indexable> indexables = new ArrayList<Indexable>();
        for (MonitorQuery mq : updates) {
            if (this.serializer != null && mq.getQueryString() == null) {
                throw new IllegalArgumentException("Cannot add a MonitorQuery with a null string representation to a non-ephemeral Monitor");
            }
            BytesRef serialized = this.serializer == null ? EMPTY : this.serializer.serialize(mq);
            for (QueryCacheEntry qce : QueryCacheEntry.decompose(mq, this.decomposer)) {
                Document doc = this.presearcher.indexQuery(qce.matchQuery, mq.getMetadata());
                doc.add((IndexableField)new StringField("_query_id", qce.queryId, Field.Store.NO));
                doc.add((IndexableField)new SortedDocValuesField("_cache_id", new BytesRef((CharSequence)qce.cacheId)));
                doc.add((IndexableField)new SortedDocValuesField("_query_id", new BytesRef((CharSequence)qce.queryId)));
                doc.add((IndexableField)new BinaryDocValuesField("_mq", serialized));
                indexables.add(new Indexable(qce, doc));
            }
        }
        return indexables;
    }

    MonitorQuery getQuery(String queryId) throws IOException {
        if (this.serializer == null) {
            throw new IllegalStateException("Cannot get queries from an index with no MonitorQuerySerializer");
        }
        BytesRef[] bytesHolder = new BytesRef[1];
        this.search((Query)new TermQuery(new Term("_query_id", queryId)), (String id, QueryCacheEntry query, DataValues dataValues) -> {
            bytesHolder[0] = dataValues.mq.binaryValue();
        });
        return this.serializer.deserialize(bytesHolder[0]);
    }

    void scan(QueryCollector matcher) throws IOException {
        this.search((Query)new MatchAllDocsQuery(), matcher);
    }

    long search(Query query, QueryCollector matcher) throws IOException {
        QueryBuilder builder = termFilter -> query;
        return this.search(builder, matcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long search(QueryBuilder queryBuilder, QueryCollector matcher) throws IOException {
        long l;
        block7: {
            IndexSearcher searcher = null;
            try {
                ConcurrentMap<String, QueryCacheEntry> queries;
                this.purgeLock.readLock().lock();
                try {
                    searcher = (IndexSearcher)this.manager.acquire();
                    queries = this.queries;
                }
                finally {
                    this.purgeLock.readLock().unlock();
                }
                MonitorQueryCollector collector = new MonitorQueryCollector(queries, matcher);
                long buildTime = System.nanoTime();
                Query query = queryBuilder.buildQuery(this.termFilters.get(searcher.getIndexReader().getReaderCacheHelper().getKey()));
                buildTime = System.nanoTime() - buildTime;
                searcher.search(query, (Collector)collector);
                l = buildTime;
                if (searcher == null) break block7;
            }
            catch (Throwable throwable) {
                if (searcher != null) {
                    this.manager.release(searcher);
                }
                throw throwable;
            }
            this.manager.release((Object)searcher);
        }
        return l;
    }

    void purgeCache() throws IOException {
        this.purgeCache(newCache -> this.scan((id, query, dataValues) -> {
            if (query != null) {
                newCache.put(query.cacheId, query);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void purgeCache(CachePopulator populator) throws IOException {
        ConcurrentHashMap<String, QueryCacheEntry> newCache = new ConcurrentHashMap<String, QueryCacheEntry>();
        this.purgeLock.writeLock().lock();
        try {
            this.purgeCache = new ConcurrentHashMap<String, QueryCacheEntry>();
        }
        finally {
            this.purgeLock.writeLock().unlock();
        }
        populator.populateCacheWithIndex(newCache);
        this.purgeLock.writeLock().lock();
        try {
            newCache.putAll(this.purgeCache);
            this.purgeCache = null;
            this.queries = newCache;
        }
        finally {
            this.purgeLock.writeLock().unlock();
        }
    }

    @Override
    public void close() throws IOException {
        IOUtils.close((Closeable[])new Closeable[]{this.manager, this.writer, this.writer.getDirectory()});
    }

    int numDocs() {
        return this.writer.getDocStats().numDocs;
    }

    int cacheSize() {
        return this.queries.size();
    }

    void deleteQueries(Iterable<String> ids) throws IOException {
        for (String id : ids) {
            this.writer.deleteDocuments(new Term[]{new Term("_query_id", id)});
        }
        this.commit(Collections.emptyList());
    }

    void clear() throws IOException {
        this.writer.deleteAll();
        this.commit(Collections.emptyList());
    }

    static final class MonitorQueryCollector
    extends SimpleCollector {
        private final Map<String, QueryCacheEntry> queries;
        private final QueryCollector matcher;
        private final DataValues dataValues = new DataValues();

        MonitorQueryCollector(Map<String, QueryCacheEntry> queries, QueryCollector matcher) {
            this.queries = queries;
            this.matcher = matcher;
        }

        public void setScorer(Scorable scorer) {
            this.dataValues.scorer = scorer;
        }

        public void collect(int doc) throws IOException {
            this.dataValues.advanceTo(doc);
            BytesRef cache_id = this.dataValues.cacheId.lookupOrd(this.dataValues.cacheId.ordValue());
            BytesRef query_id = this.dataValues.queryId.lookupOrd(this.dataValues.queryId.ordValue());
            QueryCacheEntry query = this.queries.get(cache_id.utf8ToString());
            this.matcher.matchQuery(query_id.utf8ToString(), query, this.dataValues);
        }

        public void doSetNextReader(LeafReaderContext context) throws IOException {
            this.dataValues.cacheId = context.reader().getSortedDocValues("_cache_id");
            this.dataValues.queryId = context.reader().getSortedDocValues("_query_id");
            this.dataValues.mq = context.reader().getBinaryDocValues("_mq");
            this.dataValues.ctx = context;
        }

        public ScoreMode scoreMode() {
            return this.matcher.scoreMode();
        }
    }

    static final class DataValues {
        SortedDocValues queryId;
        SortedDocValues cacheId;
        BinaryDocValues mq;
        Scorable scorer;
        LeafReaderContext ctx;

        DataValues() {
        }

        void advanceTo(int doc) throws IOException {
            assert (this.scorer.docID() == doc);
            this.queryId.advanceExact(doc);
            this.cacheId.advanceExact(doc);
            if (this.mq != null) {
                this.mq.advanceExact(doc);
            }
        }
    }

    static interface QueryCollector {
        public void matchQuery(String var1, QueryCacheEntry var2, DataValues var3) throws IOException;

        default public ScoreMode scoreMode() {
            return ScoreMode.COMPLETE_NO_SCORES;
        }
    }

    static interface CachePopulator {
        public void populateCacheWithIndex(Map<String, QueryCacheEntry> var1) throws IOException;
    }

    static class QueryTermFilter
    implements BiPredicate<String, BytesRef> {
        private final Map<String, BytesRefHash> termsHash = new HashMap<String, BytesRefHash>();

        QueryTermFilter(IndexReader reader) throws IOException {
            for (LeafReaderContext ctx : reader.leaves()) {
                for (FieldInfo fi : ctx.reader().getFieldInfos()) {
                    BytesRef term;
                    BytesRefHash terms = this.termsHash.computeIfAbsent(fi.name, f -> new BytesRefHash());
                    Terms t = ctx.reader().terms(fi.name);
                    if (t == null) continue;
                    TermsEnum te = t.iterator();
                    while ((term = te.next()) != null) {
                        terms.add(term);
                    }
                }
            }
        }

        @Override
        public boolean test(String field, BytesRef term) {
            BytesRefHash bytes = this.termsHash.get(field);
            if (bytes == null) {
                return false;
            }
            return bytes.find(term) != -1;
        }
    }

    static interface QueryBuilder {
        public Query buildQuery(BiPredicate<String, BytesRef> var1) throws IOException;
    }

    private static class Indexable {
        final QueryCacheEntry queryCacheEntry;
        final Document document;

        private Indexable(QueryCacheEntry queryCacheEntry, Document document) {
            this.queryCacheEntry = queryCacheEntry;
            this.document = document;
        }
    }

    private class TermsHashBuilder
    extends SearcherFactory {
        private TermsHashBuilder() {
        }

        public IndexSearcher newSearcher(IndexReader reader, IndexReader previousReader) throws IOException {
            IndexSearcher searcher = super.newSearcher(reader, previousReader);
            searcher.setQueryCache(null);
            QueryIndex.this.termFilters.put(reader.getReaderCacheHelper().getKey(), new QueryTermFilter(reader));
            reader.getReaderCacheHelper().addClosedListener(QueryIndex.this.termFilters::remove);
            return searcher;
        }
    }

    static final class FIELDS {
        static final String query_id = "_query_id";
        static final String cache_id = "_cache_id";
        static final String mq = "_mq";

        FIELDS() {
        }
    }
}

