/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.monitor;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.monitor.CandidateMatcher;
import org.apache.lucene.monitor.QueryMatch;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.SimpleCollector;

abstract class CollectingMatcher<T extends QueryMatch>
extends CandidateMatcher<T> {
    private final ScoreMode scoreMode;

    CollectingMatcher(IndexSearcher searcher, ScoreMode scoreMode) {
        super(searcher);
        this.scoreMode = scoreMode;
    }

    @Override
    protected void matchQuery(String queryId, Query matchQuery, Map<String, String> metadata) throws IOException {
        this.searcher.search(matchQuery, (Collector)new MatchCollector(queryId, this.scoreMode));
    }

    protected abstract T doMatch(String var1, int var2, Scorable var3) throws IOException;

    private class MatchCollector
    extends SimpleCollector {
        private final String queryId;
        private final ScoreMode scoreMode;
        private Scorable scorer;

        MatchCollector(String queryId, ScoreMode scoreMode) {
            this.queryId = queryId;
            this.scoreMode = scoreMode;
        }

        public void collect(int doc) throws IOException {
            Object match = CollectingMatcher.this.doMatch(this.queryId, doc, this.scorer);
            if (match != null) {
                CollectingMatcher.this.addMatch(match, doc);
            }
        }

        public void setScorer(Scorable scorer) {
            this.scorer = scorer;
        }

        public ScoreMode scoreMode() {
            return this.scoreMode;
        }
    }
}

