/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index.memory;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PayloadAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TermToBytesRefAttribute;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.OrdTermState;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.ByteBlockPool;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefArray;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.IntBlockPool;
import org.apache.lucene.util.RecyclingByteBlockAllocator;
import org.apache.lucene.util.RecyclingIntBlockAllocator;
import org.apache.lucene.util.StringHelper;

public class MemoryIndex {
    private static final boolean DEBUG = false;
    private final SortedMap<String, Info> fields = new TreeMap<String, Info>();
    private final boolean storeOffsets;
    private final boolean storePayloads;
    private final ByteBlockPool byteBlockPool;
    private final IntBlockPool intBlockPool;
    private final IntBlockPool.SliceWriter postingsWriter;
    private final BytesRefArray payloadsBytesRefs;
    private Counter bytesUsed;
    private boolean frozen = false;
    private Similarity normSimilarity = IndexSearcher.getDefaultSimilarity();

    public MemoryIndex() {
        this(false);
    }

    public MemoryIndex(boolean storeOffsets) {
        this(storeOffsets, false);
    }

    public MemoryIndex(boolean storeOffsets, boolean storePayloads) {
        this(storeOffsets, storePayloads, 0L);
    }

    MemoryIndex(boolean storeOffsets, boolean storePayloads, long maxReusedBytes) {
        this.storeOffsets = storeOffsets;
        this.storePayloads = storePayloads;
        this.bytesUsed = Counter.newCounter();
        int maxBufferedByteBlocks = (int)(maxReusedBytes / 2L / 32768L);
        int maxBufferedIntBlocks = (int)((maxReusedBytes - (long)(maxBufferedByteBlocks * 32768)) / 32768L);
        assert ((long)(maxBufferedByteBlocks * 32768 + maxBufferedIntBlocks * 8192 * 4) <= maxReusedBytes);
        this.byteBlockPool = new ByteBlockPool((ByteBlockPool.Allocator)new RecyclingByteBlockAllocator(32768, maxBufferedByteBlocks, this.bytesUsed));
        this.intBlockPool = new IntBlockPool((IntBlockPool.Allocator)new RecyclingIntBlockAllocator(8192, maxBufferedIntBlocks, this.bytesUsed));
        this.postingsWriter = new IntBlockPool.SliceWriter(this.intBlockPool);
        this.payloadsBytesRefs = storePayloads ? new BytesRefArray(this.bytesUsed) : null;
    }

    public void addField(String fieldName, String text, Analyzer analyzer) {
        if (fieldName == null) {
            throw new IllegalArgumentException("fieldName must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("text must not be null");
        }
        if (analyzer == null) {
            throw new IllegalArgumentException("analyzer must not be null");
        }
        TokenStream stream = analyzer.tokenStream(fieldName, text);
        this.addField(fieldName, stream, 1.0f, analyzer.getPositionIncrementGap(fieldName), analyzer.getOffsetGap(fieldName), DocValuesType.NONE, null, 0, 0, null);
    }

    public static MemoryIndex fromDocument(Iterable<? extends IndexableField> document, Analyzer analyzer) {
        return MemoryIndex.fromDocument(document, analyzer, false, false, 0L);
    }

    public static MemoryIndex fromDocument(Iterable<? extends IndexableField> document, Analyzer analyzer, boolean storeOffsets, boolean storePayloads) {
        return MemoryIndex.fromDocument(document, analyzer, storeOffsets, storePayloads, 0L);
    }

    public static MemoryIndex fromDocument(Iterable<? extends IndexableField> document, Analyzer analyzer, boolean storeOffsets, boolean storePayloads, long maxReusedBytes) {
        MemoryIndex mi = new MemoryIndex(storeOffsets, storePayloads, maxReusedBytes);
        for (IndexableField indexableField : document) {
            mi.addField(indexableField, analyzer);
        }
        return mi;
    }

    public <T> TokenStream keywordTokenStream(final Collection<T> keywords) {
        if (keywords == null) {
            throw new IllegalArgumentException("keywords must not be null");
        }
        return new TokenStream(){
            private Iterator<T> iter;
            private int start;
            private final CharTermAttribute termAtt;
            private final OffsetAttribute offsetAtt;
            {
                this.iter = keywords.iterator();
                this.start = 0;
                this.termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
                this.offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
            }

            public boolean incrementToken() {
                if (!this.iter.hasNext()) {
                    return false;
                }
                Object obj = this.iter.next();
                if (obj == null) {
                    throw new IllegalArgumentException("keyword must not be null");
                }
                String term = obj.toString();
                this.clearAttributes();
                this.termAtt.setEmpty().append(term);
                this.offsetAtt.setOffset(this.start, this.start + this.termAtt.length());
                this.start += term.length() + 1;
                return true;
            }
        };
    }

    public void addField(String fieldName, TokenStream stream) {
        this.addField(fieldName, stream, 1.0f);
    }

    public void addField(IndexableField field, Analyzer analyzer) {
        this.addField(field, analyzer, 1.0f);
    }

    public void addField(IndexableField field, Analyzer analyzer, float boost) {
        Object docValuesValue;
        int positionIncrementGap;
        TokenStream tokenStream;
        int offsetGap;
        if (analyzer != null) {
            offsetGap = analyzer.getOffsetGap(field.name());
            tokenStream = field.tokenStream(analyzer, null);
            positionIncrementGap = analyzer.getPositionIncrementGap(field.name());
        } else {
            offsetGap = 1;
            tokenStream = field.tokenStream(null, null);
            positionIncrementGap = 0;
        }
        DocValuesType docValuesType = field.fieldType().docValuesType();
        switch (docValuesType) {
            case NONE: {
                docValuesValue = null;
                break;
            }
            case BINARY: 
            case SORTED: 
            case SORTED_SET: {
                docValuesValue = field.binaryValue();
                break;
            }
            case NUMERIC: 
            case SORTED_NUMERIC: {
                docValuesValue = field.numericValue();
                break;
            }
            default: {
                throw new UnsupportedOperationException("unknown doc values type [" + docValuesType + "]");
            }
        }
        BytesRef pointValue = null;
        if (field.fieldType().pointDimensionCount() > 0) {
            pointValue = field.binaryValue();
        }
        this.addField(field.name(), tokenStream, boost, positionIncrementGap, offsetGap, docValuesType, docValuesValue, field.fieldType().pointDimensionCount(), field.fieldType().pointNumBytes(), pointValue);
    }

    public void addField(String fieldName, TokenStream stream, float boost) {
        this.addField(fieldName, stream, boost, 0);
    }

    public void addField(String fieldName, TokenStream stream, float boost, int positionIncrementGap) {
        this.addField(fieldName, stream, boost, positionIncrementGap, 1);
    }

    public void addField(String fieldName, TokenStream tokenStream, float boost, int positionIncrementGap, int offsetGap) {
        this.addField(fieldName, tokenStream, boost, positionIncrementGap, offsetGap, DocValuesType.NONE, null, 0, 0, null);
    }

    private void addField(String fieldName, TokenStream tokenStream, float boost, int positionIncrementGap, int offsetGap, DocValuesType docValuesType, Object docValuesValue, int pointDimensionCount, int pointNumBytes, BytesRef pointValue) {
        if (this.frozen) {
            throw new IllegalArgumentException("Cannot call addField() when MemoryIndex is frozen");
        }
        if (fieldName == null) {
            throw new IllegalArgumentException("fieldName must not be null");
        }
        if (boost <= 0.0f) {
            throw new IllegalArgumentException("boost factor must be greater than 0.0");
        }
        Info info = (Info)this.fields.get(fieldName);
        if (info == null) {
            IndexOptions indexOptions = this.storeOffsets ? IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS : IndexOptions.DOCS_AND_FREQS_AND_POSITIONS;
            FieldInfo fieldInfo = new FieldInfo(fieldName, this.fields.size(), true, false, this.storePayloads, indexOptions, docValuesType, -1L, Collections.emptyMap(), 0, 0);
            info = new Info(fieldInfo, this.byteBlockPool);
            this.fields.put(fieldName, info);
        }
        if (pointDimensionCount > 0) {
            this.storePointValues(info, pointDimensionCount, pointNumBytes, pointValue);
        }
        if (docValuesType != DocValuesType.NONE) {
            this.storeDocValues(info, docValuesType, docValuesValue);
        }
        if (tokenStream != null) {
            this.storeTerms(info, tokenStream, boost, positionIncrementGap, offsetGap);
        }
    }

    private void storePointValues(Info info, int pointDimensionCount, int pointNumBytes, BytesRef pointValue) {
        info.fieldInfo.setPointDimensions(pointDimensionCount, pointNumBytes);
        if (info.pointValues == null) {
            Info.access$202(info, new BytesRef[4]);
        }
        Info.access$202(info, (BytesRef[])ArrayUtil.grow((Object[])info.pointValues, (int)(info.pointValuesCount + 1)));
        ((Info)info).pointValues[((Info)info).pointValuesCount++] = BytesRef.deepCopyOf((BytesRef)pointValue);
    }

    private void storeDocValues(Info info, DocValuesType docValuesType, Object docValuesValue) {
        String fieldName = ((Info)info).fieldInfo.name;
        DocValuesType existingDocValuesType = info.fieldInfo.getDocValuesType();
        if (existingDocValuesType == DocValuesType.NONE) {
            info.fieldInfo = new FieldInfo(((Info)info).fieldInfo.name, ((Info)info).fieldInfo.number, info.fieldInfo.hasVectors(), info.fieldInfo.hasPayloads(), info.fieldInfo.hasPayloads(), info.fieldInfo.getIndexOptions(), docValuesType, -1L, info.fieldInfo.attributes(), info.fieldInfo.getPointDimensionCount(), info.fieldInfo.getPointNumBytes());
        } else if (existingDocValuesType != docValuesType) {
            throw new IllegalArgumentException("Can't add [" + docValuesType + "] doc values field [" + fieldName + "], because [" + existingDocValuesType + "] doc values field already exists");
        }
        switch (docValuesType) {
            case NUMERIC: {
                if (((Info)info).numericProducer.dvLongValues != null) {
                    throw new IllegalArgumentException("Only one value per field allowed for [" + docValuesType + "] doc values field [" + fieldName + "]");
                }
                ((Info)info).numericProducer.dvLongValues = new long[]{(Long)docValuesValue};
                ++((Info)info).numericProducer.count;
                break;
            }
            case SORTED_NUMERIC: {
                if (((Info)info).numericProducer.dvLongValues == null) {
                    ((Info)info).numericProducer.dvLongValues = new long[4];
                }
                ((Info)info).numericProducer.dvLongValues = ArrayUtil.grow((long[])((Info)info).numericProducer.dvLongValues, (int)(((Info)info).numericProducer.count + 1));
                ((Info)info).numericProducer.dvLongValues[((Info)info).numericProducer.count++] = (Long)docValuesValue;
                break;
            }
            case BINARY: {
                if (((Info)info).binaryProducer.dvBytesValuesSet != null) {
                    throw new IllegalArgumentException("Only one value per field allowed for [" + docValuesType + "] doc values field [" + fieldName + "]");
                }
                ((Info)info).binaryProducer.dvBytesValuesSet = new BytesRefHash(this.byteBlockPool);
                ((Info)info).binaryProducer.dvBytesValuesSet.add((BytesRef)docValuesValue);
                break;
            }
            case SORTED: {
                if (((Info)info).binaryProducer.dvBytesValuesSet != null) {
                    throw new IllegalArgumentException("Only one value per field allowed for [" + docValuesType + "] doc values field [" + fieldName + "]");
                }
                ((Info)info).binaryProducer.dvBytesValuesSet = new BytesRefHash(this.byteBlockPool);
                ((Info)info).binaryProducer.dvBytesValuesSet.add((BytesRef)docValuesValue);
                break;
            }
            case SORTED_SET: {
                if (((Info)info).binaryProducer.dvBytesValuesSet == null) {
                    ((Info)info).binaryProducer.dvBytesValuesSet = new BytesRefHash(this.byteBlockPool);
                }
                ((Info)info).binaryProducer.dvBytesValuesSet.add((BytesRef)docValuesValue);
                break;
            }
            default: {
                throw new UnsupportedOperationException("unknown doc values type [" + docValuesType + "]");
            }
        }
    }

    private void storeTerms(Info info, TokenStream tokenStream, float boost, int positionIncrementGap, int offsetGap) {
        int pos = -1;
        int offset = 0;
        if (info.numTokens == 0) {
            info.boost = boost;
        } else if (info.numTokens > 0) {
            pos = info.lastPosition + positionIncrementGap;
            offset = info.lastOffset + offsetGap;
            Info info2 = info;
            info2.boost = info2.boost * boost;
        }
        try (TokenStream stream = tokenStream;){
            TermToBytesRefAttribute termAtt = (TermToBytesRefAttribute)stream.getAttribute(TermToBytesRefAttribute.class);
            PositionIncrementAttribute posIncrAttribute = (PositionIncrementAttribute)stream.addAttribute(PositionIncrementAttribute.class);
            OffsetAttribute offsetAtt = (OffsetAttribute)stream.addAttribute(OffsetAttribute.class);
            PayloadAttribute payloadAtt = this.storePayloads ? (PayloadAttribute)stream.addAttribute(PayloadAttribute.class) : null;
            stream.reset();
            while (stream.incrementToken()) {
                info.numTokens++;
                int posIncr = posIncrAttribute.getPositionIncrement();
                if (posIncr == 0) {
                    info.numOverlapTokens++;
                }
                pos += posIncr;
                int ord = info.terms.add(termAtt.getBytesRef());
                if (ord < 0) {
                    ord = -ord - 1;
                    this.postingsWriter.reset(((Info)info).sliceArray.end[ord]);
                } else {
                    ((Info)info).sliceArray.start[ord] = this.postingsWriter.startNewSlice();
                }
                int n = ord;
                ((Info)info).sliceArray.freq[n] = ((Info)info).sliceArray.freq[n] + 1;
                info.sumTotalTermFreq++;
                this.postingsWriter.writeInt(pos);
                if (this.storeOffsets) {
                    this.postingsWriter.writeInt(offsetAtt.startOffset() + offset);
                    this.postingsWriter.writeInt(offsetAtt.endOffset() + offset);
                }
                if (this.storePayloads) {
                    BytesRef payload = payloadAtt.getPayload();
                    int pIndex = payload == null || payload.length == 0 ? -1 : this.payloadsBytesRefs.append(payload);
                    this.postingsWriter.writeInt(pIndex);
                }
                ((Info)info).sliceArray.end[ord] = this.postingsWriter.getCurrentOffset();
            }
            stream.end();
            if (info.numTokens > 0) {
                info.lastPosition = pos;
                info.lastOffset = offsetAtt.endOffset() + offset;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setSimilarity(Similarity similarity) {
        if (this.frozen) {
            throw new IllegalArgumentException("Cannot set Similarity when MemoryIndex is frozen");
        }
        if (this.normSimilarity == similarity) {
            return;
        }
        this.normSimilarity = similarity;
        for (Info info : this.fields.values()) {
            info.norms = null;
        }
    }

    public IndexSearcher createSearcher() {
        MemoryIndexReader reader = new MemoryIndexReader();
        IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
        searcher.setSimilarity(this.normSimilarity);
        searcher.setQueryCache(null);
        return searcher;
    }

    public void freeze() {
        this.frozen = true;
        for (Info info : this.fields.values()) {
            info.freeze();
        }
    }

    public float search(Query query) {
        if (query == null) {
            throw new IllegalArgumentException("query must not be null");
        }
        IndexSearcher searcher = this.createSearcher();
        try {
            float score;
            final float[] scores = new float[1];
            searcher.search(query, (Collector)new SimpleCollector(){
                private Scorer scorer;

                public void collect(int doc) throws IOException {
                    scores[0] = this.scorer.score();
                }

                public void setScorer(Scorer scorer) {
                    this.scorer = scorer;
                }

                public boolean needsScores() {
                    return true;
                }
            });
            float f = score = scores[0];
            return f;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder(256);
        int sumPositions = 0;
        int sumTerms = 0;
        BytesRef spare = new BytesRef();
        for (Map.Entry<String, Info> entry : this.fields.entrySet()) {
            String fieldName = entry.getKey();
            Info info = entry.getValue();
            info.sortTerms();
            result.append(fieldName + ":\n");
            SliceByteStartArray sliceArray = info.sliceArray;
            int numPositions = 0;
            IntBlockPool.SliceReader postingsReader = new IntBlockPool.SliceReader(this.intBlockPool);
            for (int j = 0; j < info.terms.size(); ++j) {
                int iters;
                int ord = info.sortedTerms[j];
                info.terms.get(ord, spare);
                int freq = sliceArray.freq[ord];
                result.append("\t'" + spare + "':" + freq + ":");
                postingsReader.reset(sliceArray.start[ord], sliceArray.end[ord]);
                result.append(" [");
                int n = iters = this.storeOffsets ? 3 : 1;
                while (!postingsReader.endOfSlice()) {
                    result.append("(");
                    for (int k = 0; k < iters; ++k) {
                        result.append(postingsReader.readInt());
                        if (k >= iters - 1) continue;
                        result.append(", ");
                    }
                    result.append(")");
                    if (postingsReader.endOfSlice()) continue;
                    result.append(",");
                }
                result.append("]");
                result.append("\n");
                numPositions += freq;
            }
            result.append("\tterms=" + info.terms.size());
            result.append(", positions=" + numPositions);
            result.append("\n");
            sumPositions += numPositions;
            sumTerms += info.terms.size();
        }
        result.append("\nfields=" + this.fields.size());
        result.append(", terms=" + sumTerms);
        result.append(", positions=" + sumPositions);
        return result.toString();
    }

    public void reset() {
        this.fields.clear();
        this.normSimilarity = IndexSearcher.getDefaultSimilarity();
        this.byteBlockPool.reset(false, false);
        this.intBlockPool.reset(true, false);
        if (this.payloadsBytesRefs != null) {
            this.payloadsBytesRefs.clear();
        }
        this.frozen = false;
    }

    private static final class SliceByteStartArray
    extends BytesRefHash.DirectBytesStartArray {
        int[] start;
        int[] end;
        int[] freq;

        public SliceByteStartArray(int initSize) {
            super(initSize);
        }

        public int[] init() {
            int[] ord = super.init();
            this.start = new int[ArrayUtil.oversize((int)ord.length, (int)4)];
            this.end = new int[ArrayUtil.oversize((int)ord.length, (int)4)];
            this.freq = new int[ArrayUtil.oversize((int)ord.length, (int)4)];
            assert (this.start.length >= ord.length);
            assert (this.end.length >= ord.length);
            assert (this.freq.length >= ord.length);
            return ord;
        }

        public int[] grow() {
            int[] ord = super.grow();
            if (this.start.length < ord.length) {
                this.start = ArrayUtil.grow((int[])this.start, (int)ord.length);
                this.end = ArrayUtil.grow((int[])this.end, (int)ord.length);
                this.freq = ArrayUtil.grow((int[])this.freq, (int)ord.length);
            }
            assert (this.start.length >= ord.length);
            assert (this.end.length >= ord.length);
            assert (this.freq.length >= ord.length);
            return ord;
        }

        public int[] clear() {
            this.end = null;
            this.start = null;
            return super.clear();
        }
    }

    private final class MemoryIndexReader
    extends LeafReader {
        private final PointValues pointValues;

        private MemoryIndexReader() {
            boolean hasPointValues = false;
            for (Info info : MemoryIndex.this.fields.values()) {
                info.prepareDocValuesAndPointValues();
                if (info.pointValues == null) continue;
                hasPointValues = true;
            }
            this.pointValues = hasPointValues ? new MemoryIndexPointValues() : null;
        }

        public void addCoreClosedListener(LeafReader.CoreClosedListener listener) {
            MemoryIndexReader.addCoreClosedListenerAsReaderClosedListener((IndexReader)this, (LeafReader.CoreClosedListener)listener);
        }

        public void removeCoreClosedListener(LeafReader.CoreClosedListener listener) {
            MemoryIndexReader.removeCoreClosedListenerAsReaderClosedListener((IndexReader)this, (LeafReader.CoreClosedListener)listener);
        }

        private Info getInfoForExpectedDocValuesType(String fieldName, DocValuesType expectedType) {
            if (expectedType == DocValuesType.NONE) {
                return null;
            }
            Info info = (Info)MemoryIndex.this.fields.get(fieldName);
            if (info == null) {
                return null;
            }
            if (info.fieldInfo.getDocValuesType() != expectedType) {
                return null;
            }
            return info;
        }

        public Bits getLiveDocs() {
            return null;
        }

        public FieldInfos getFieldInfos() {
            FieldInfo[] fieldInfos = new FieldInfo[MemoryIndex.this.fields.size()];
            int i = 0;
            for (Info info : MemoryIndex.this.fields.values()) {
                fieldInfos[i++] = info.fieldInfo;
            }
            return new FieldInfos(fieldInfos);
        }

        public NumericDocValues getNumericDocValues(String field) {
            Info info = this.getInfoForExpectedDocValuesType(field, DocValuesType.NUMERIC);
            if (info != null) {
                return ((Info)info).numericProducer.numericDocValues;
            }
            return null;
        }

        public BinaryDocValues getBinaryDocValues(String field) {
            return this.getSortedDocValues(field, DocValuesType.BINARY);
        }

        public SortedDocValues getSortedDocValues(String field) {
            return this.getSortedDocValues(field, DocValuesType.SORTED);
        }

        private SortedDocValues getSortedDocValues(String field, DocValuesType docValuesType) {
            Info info = this.getInfoForExpectedDocValuesType(field, docValuesType);
            if (info != null) {
                return ((Info)info).binaryProducer.sortedDocValues;
            }
            return null;
        }

        public SortedNumericDocValues getSortedNumericDocValues(String field) {
            Info info = this.getInfoForExpectedDocValuesType(field, DocValuesType.SORTED_NUMERIC);
            if (info != null) {
                return ((Info)info).numericProducer.sortedNumericDocValues;
            }
            return null;
        }

        public SortedSetDocValues getSortedSetDocValues(String field) {
            final Info info = this.getInfoForExpectedDocValuesType(field, DocValuesType.SORTED_SET);
            if (info != null) {
                return new SortedSetDocValues(){
                    int index = 0;

                    public long nextOrd() {
                        if (this.index >= ((Info)info).binaryProducer.dvBytesValuesSet.size()) {
                            return -1L;
                        }
                        return this.index++;
                    }

                    public void setDocument(int docID) {
                        this.index = 0;
                    }

                    public BytesRef lookupOrd(long ord) {
                        return info.binaryProducer.getValue((int)ord);
                    }

                    public long getValueCount() {
                        return ((Info)info).binaryProducer.dvBytesValuesSet.size();
                    }
                };
            }
            return null;
        }

        public Bits getDocsWithField(String field) throws IOException {
            Info info = (Info)MemoryIndex.this.fields.get(field);
            if (info != null && info.fieldInfo.getDocValuesType() != DocValuesType.NONE) {
                return new Bits.MatchAllBits(1);
            }
            return null;
        }

        public PointValues getPointValues() {
            return this.pointValues;
        }

        public void checkIntegrity() throws IOException {
        }

        public Fields fields() {
            Map filteredFields = MemoryIndex.this.fields.entrySet().stream().filter(entry -> ((Info)entry.getValue()).numTokens > 0).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (u, v) -> {
                throw new IllegalStateException(String.format(Locale.ROOT, "Duplicate key %s", u));
            }, TreeMap::new));
            return new MemoryFields(filteredFields);
        }

        public Fields getTermVectors(int docID) {
            if (docID == 0) {
                return this.fields();
            }
            return null;
        }

        public int numDocs() {
            return 1;
        }

        public int maxDoc() {
            return 1;
        }

        public void document(int docID, StoredFieldVisitor visitor) {
        }

        protected void doClose() {
        }

        public NumericDocValues getNormValues(String field) {
            Info info = (Info)MemoryIndex.this.fields.get(field);
            if (info == null) {
                return null;
            }
            return info.getNormDocValues();
        }

        private class MemoryIndexPointValues
        extends PointValues {
            private MemoryIndexPointValues() {
            }

            public void intersect(String fieldName, PointValues.IntersectVisitor visitor) throws IOException {
                Info info = (Info)MemoryIndex.this.fields.get(fieldName);
                if (info == null) {
                    return;
                }
                BytesRef[] values = info.pointValues;
                if (values == null) {
                    return;
                }
                visitor.grow(info.pointValuesCount);
                for (int i = 0; i < info.pointValuesCount; ++i) {
                    visitor.visit(0, values[i].bytes);
                }
            }

            public byte[] getMinPackedValue(String fieldName) throws IOException {
                Info info = (Info)MemoryIndex.this.fields.get(fieldName);
                if (info == null) {
                    return null;
                }
                BytesRef[] values = info.pointValues;
                if (values != null) {
                    return info.minPackedValue;
                }
                return null;
            }

            public byte[] getMaxPackedValue(String fieldName) throws IOException {
                Info info = (Info)MemoryIndex.this.fields.get(fieldName);
                if (info == null) {
                    return null;
                }
                BytesRef[] values = info.pointValues;
                if (values != null) {
                    return info.maxPackedValue;
                }
                return null;
            }

            public int getNumDimensions(String fieldName) throws IOException {
                Info info = (Info)MemoryIndex.this.fields.get(fieldName);
                if (info == null) {
                    return 0;
                }
                return info.fieldInfo.getPointDimensionCount();
            }

            public int getBytesPerDimension(String fieldName) throws IOException {
                Info info = (Info)MemoryIndex.this.fields.get(fieldName);
                if (info == null) {
                    return 0;
                }
                return info.fieldInfo.getPointNumBytes();
            }

            public long size(String fieldName) {
                Info info = (Info)MemoryIndex.this.fields.get(fieldName);
                if (info == null) {
                    return 0L;
                }
                BytesRef[] values = info.pointValues;
                if (values != null) {
                    return info.pointValuesCount;
                }
                return 0L;
            }

            public int getDocCount(String fieldName) {
                Info info = (Info)MemoryIndex.this.fields.get(fieldName);
                if (info == null) {
                    return 0;
                }
                BytesRef[] values = info.pointValues;
                if (values != null) {
                    return 1;
                }
                return 0;
            }
        }

        private class MemoryPostingsEnum
        extends PostingsEnum {
            private final IntBlockPool.SliceReader sliceReader;
            private int posUpto;
            private boolean hasNext;
            private int doc = -1;
            private int freq;
            private int pos;
            private int startOffset;
            private int endOffset;
            private int payloadIndex;
            private final BytesRefBuilder payloadBuilder;

            public MemoryPostingsEnum() {
                this.sliceReader = new IntBlockPool.SliceReader(MemoryIndex.this.intBlockPool);
                this.payloadBuilder = MemoryIndex.this.storePayloads ? new BytesRefBuilder() : null;
            }

            public PostingsEnum reset(int start, int end, int freq) {
                this.sliceReader.reset(start, end);
                this.posUpto = 0;
                this.hasNext = true;
                this.doc = -1;
                this.freq = freq;
                return this;
            }

            public int docID() {
                return this.doc;
            }

            public int nextDoc() {
                this.pos = -1;
                if (this.hasNext) {
                    this.hasNext = false;
                    this.doc = 0;
                    return 0;
                }
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }

            public int advance(int target) throws IOException {
                return this.slowAdvance(target);
            }

            public int freq() throws IOException {
                return this.freq;
            }

            public int nextPosition() {
                ++this.posUpto;
                assert (this.posUpto <= this.freq);
                assert (!this.sliceReader.endOfSlice()) : " stores offsets : " + this.startOffset;
                int pos = this.sliceReader.readInt();
                if (MemoryIndex.this.storeOffsets) {
                    this.startOffset = this.sliceReader.readInt();
                    this.endOffset = this.sliceReader.readInt();
                }
                if (MemoryIndex.this.storePayloads) {
                    this.payloadIndex = this.sliceReader.readInt();
                }
                return pos;
            }

            public int startOffset() {
                return this.startOffset;
            }

            public int endOffset() {
                return this.endOffset;
            }

            public BytesRef getPayload() {
                if (this.payloadBuilder == null || this.payloadIndex == -1) {
                    return null;
                }
                return MemoryIndex.this.payloadsBytesRefs.get(this.payloadBuilder, this.payloadIndex);
            }

            public long cost() {
                return 1L;
            }
        }

        private class MemoryTermsEnum
        extends TermsEnum {
            private final Info info;
            private final BytesRef br = new BytesRef();
            int termUpto = -1;

            public MemoryTermsEnum(Info info) {
                this.info = info;
                info.sortTerms();
            }

            private final int binarySearch(BytesRef b, BytesRef bytesRef, int low, int high, BytesRefHash hash, int[] ords) {
                int mid = 0;
                while (low <= high) {
                    mid = low + high >>> 1;
                    hash.get(ords[mid], bytesRef);
                    int cmp = bytesRef.compareTo(b);
                    if (cmp < 0) {
                        low = mid + 1;
                        continue;
                    }
                    if (cmp > 0) {
                        high = mid - 1;
                        continue;
                    }
                    return mid;
                }
                assert (bytesRef.compareTo(b) != 0);
                return -(low + 1);
            }

            public boolean seekExact(BytesRef text) {
                this.termUpto = this.binarySearch(text, this.br, 0, this.info.terms.size() - 1, this.info.terms, this.info.sortedTerms);
                return this.termUpto >= 0;
            }

            public TermsEnum.SeekStatus seekCeil(BytesRef text) {
                this.termUpto = this.binarySearch(text, this.br, 0, this.info.terms.size() - 1, this.info.terms, this.info.sortedTerms);
                if (this.termUpto < 0) {
                    this.termUpto = -this.termUpto - 1;
                    if (this.termUpto >= this.info.terms.size()) {
                        return TermsEnum.SeekStatus.END;
                    }
                    this.info.terms.get(this.info.sortedTerms[this.termUpto], this.br);
                    return TermsEnum.SeekStatus.NOT_FOUND;
                }
                return TermsEnum.SeekStatus.FOUND;
            }

            public void seekExact(long ord) {
                assert (ord < (long)this.info.terms.size());
                this.termUpto = (int)ord;
                this.info.terms.get(this.info.sortedTerms[this.termUpto], this.br);
            }

            public BytesRef next() {
                ++this.termUpto;
                if (this.termUpto >= this.info.terms.size()) {
                    return null;
                }
                this.info.terms.get(this.info.sortedTerms[this.termUpto], this.br);
                return this.br;
            }

            public BytesRef term() {
                return this.br;
            }

            public long ord() {
                return this.termUpto;
            }

            public int docFreq() {
                return 1;
            }

            public long totalTermFreq() {
                return ((Info)this.info).sliceArray.freq[this.info.sortedTerms[this.termUpto]];
            }

            public PostingsEnum postings(PostingsEnum reuse, int flags) {
                if (reuse == null || !(reuse instanceof MemoryPostingsEnum)) {
                    reuse = new MemoryPostingsEnum();
                }
                int ord = this.info.sortedTerms[this.termUpto];
                return ((MemoryPostingsEnum)reuse).reset(((Info)this.info).sliceArray.start[ord], ((Info)this.info).sliceArray.end[ord], ((Info)this.info).sliceArray.freq[ord]);
            }

            public void seekExact(BytesRef term, TermState state) throws IOException {
                assert (state != null);
                this.seekExact(((OrdTermState)state).ord);
            }

            public TermState termState() throws IOException {
                OrdTermState ts = new OrdTermState();
                ts.ord = this.termUpto;
                return ts;
            }
        }

        private class MemoryFields
        extends Fields {
            private final Map<String, Info> fields;

            public MemoryFields(Map<String, Info> fields) {
                this.fields = fields;
            }

            public Iterator<String> iterator() {
                return this.fields.keySet().iterator();
            }

            public Terms terms(String field) {
                final Info info = this.fields.get(field);
                if (info == null) {
                    return null;
                }
                return new Terms(){

                    public TermsEnum iterator() {
                        return new MemoryTermsEnum(info);
                    }

                    public long size() {
                        return info.terms.size();
                    }

                    public long getSumTotalTermFreq() {
                        return info.sumTotalTermFreq;
                    }

                    public long getSumDocFreq() {
                        return info.terms.size();
                    }

                    public int getDocCount() {
                        return this.size() > 0L ? 1 : 0;
                    }

                    public boolean hasFreqs() {
                        return true;
                    }

                    public boolean hasOffsets() {
                        return MemoryIndex.this.storeOffsets;
                    }

                    public boolean hasPositions() {
                        return true;
                    }

                    public boolean hasPayloads() {
                        return MemoryIndex.this.storePayloads;
                    }
                };
            }

            public int size() {
                return this.fields.size();
            }
        }
    }

    private static final class NumericDocValuesProducer {
        long[] dvLongValues;
        int count;
        final NumericDocValues numericDocValues = new NumericDocValues(){

            public long get(int docID) {
                return dvLongValues[0];
            }
        };
        final SortedNumericDocValues sortedNumericDocValues = new SortedNumericDocValues(){

            public void setDocument(int doc) {
            }

            public long valueAt(int index) {
                return dvLongValues[index];
            }

            public int count() {
                return count;
            }
        };

        private NumericDocValuesProducer() {
        }

        private void prepareForUsage() {
            Arrays.sort(this.dvLongValues, 0, this.count);
        }
    }

    private static final class BinaryDocValuesProducer {
        BytesRefHash dvBytesValuesSet;
        final SortedDocValues sortedDocValues;
        final BytesRef spare = new BytesRef();
        int[] bytesIds;

        private BinaryDocValuesProducer() {
            this.sortedDocValues = new SortedDocValues(){

                public int getOrd(int docID) {
                    return 0;
                }

                public BytesRef lookupOrd(int ord) {
                    return this.getValue(ord);
                }

                public int getValueCount() {
                    return 1;
                }
            };
        }

        private void prepareForUsage() {
            this.bytesIds = this.dvBytesValuesSet.sort();
        }

        private BytesRef getValue(int index) {
            return this.dvBytesValuesSet.get(this.bytesIds[index], this.spare);
        }
    }

    private final class Info {
        private FieldInfo fieldInfo;
        private transient NumericDocValues norms;
        private BytesRefHash terms;
        private SliceByteStartArray sliceArray;
        private transient int[] sortedTerms;
        private int numTokens;
        private int numOverlapTokens;
        private float boost;
        private long sumTotalTermFreq;
        private int lastPosition;
        private int lastOffset;
        private BinaryDocValuesProducer binaryProducer;
        private NumericDocValuesProducer numericProducer;
        private boolean preparedDocValuesAndPointValues;
        private BytesRef[] pointValues;
        private byte[] minPackedValue;
        private byte[] maxPackedValue;
        private int pointValuesCount;

        private Info(FieldInfo fieldInfo, ByteBlockPool byteBlockPool) {
            this.fieldInfo = fieldInfo;
            this.sliceArray = new SliceByteStartArray(16);
            this.terms = new BytesRefHash(byteBlockPool, 16, (BytesRefHash.BytesStartArray)this.sliceArray);
            this.binaryProducer = new BinaryDocValuesProducer();
            this.numericProducer = new NumericDocValuesProducer();
        }

        void freeze() {
            this.sortTerms();
            this.prepareDocValuesAndPointValues();
            this.getNormDocValues();
        }

        void sortTerms() {
            if (this.sortedTerms == null) {
                this.sortedTerms = this.terms.sort();
            }
        }

        void prepareDocValuesAndPointValues() {
            if (!this.preparedDocValuesAndPointValues) {
                DocValuesType dvType = this.fieldInfo.getDocValuesType();
                if (dvType == DocValuesType.NUMERIC || dvType == DocValuesType.SORTED_NUMERIC) {
                    this.numericProducer.prepareForUsage();
                }
                if (dvType == DocValuesType.BINARY || dvType == DocValuesType.SORTED || dvType == DocValuesType.SORTED_SET) {
                    this.binaryProducer.prepareForUsage();
                }
                if (this.pointValues != null) {
                    assert (this.pointValues[0].bytes.length == this.pointValues[0].length) : "BytesRef should wrap a precise byte[], BytesRef.deepCopyOf() should take care of this";
                    int numDimensions = this.fieldInfo.getPointDimensionCount();
                    int numBytesPerDimension = this.fieldInfo.getPointNumBytes();
                    this.minPackedValue = (byte[])this.pointValues[0].bytes.clone();
                    this.maxPackedValue = (byte[])this.pointValues[0].bytes.clone();
                    for (int i = 0; i < this.pointValuesCount; ++i) {
                        BytesRef pointValue = this.pointValues[i];
                        assert (pointValue.bytes.length == pointValue.length) : "BytesRef should wrap a precise byte[], BytesRef.deepCopyOf() should take care of this";
                        for (int dim = 0; dim < numDimensions; ++dim) {
                            int offset = dim * numBytesPerDimension;
                            if (StringHelper.compare((int)numBytesPerDimension, (byte[])pointValue.bytes, (int)offset, (byte[])this.minPackedValue, (int)offset) < 0) {
                                System.arraycopy(pointValue.bytes, offset, this.minPackedValue, offset, numBytesPerDimension);
                            }
                            if (StringHelper.compare((int)numBytesPerDimension, (byte[])pointValue.bytes, (int)offset, (byte[])this.maxPackedValue, (int)offset) <= 0) continue;
                            System.arraycopy(pointValue.bytes, offset, this.maxPackedValue, offset, numBytesPerDimension);
                        }
                    }
                }
                this.preparedDocValuesAndPointValues = true;
            }
        }

        NumericDocValues getNormDocValues() {
            if (this.norms == null) {
                FieldInvertState invertState = new FieldInvertState(this.fieldInfo.name, this.fieldInfo.number, this.numTokens, this.numOverlapTokens, 0, this.boost);
                final long value = MemoryIndex.this.normSimilarity.computeNorm(invertState);
                this.norms = new NumericDocValues(){

                    public long get(int docID) {
                        if (docID != 0) {
                            throw new IndexOutOfBoundsException();
                        }
                        return value;
                    }
                };
            }
            return this.norms;
        }

        static /* synthetic */ BytesRef[] access$202(Info x0, BytesRef[] x1) {
            x0.pointValues = x1;
            return x1;
        }
    }
}

