/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index.memory;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.Norm;
import org.apache.lucene.util.BytesRef;

class MemoryIndexNormDocValues
extends DocValues {
    private final DocValues.Source source;

    MemoryIndexNormDocValues(DocValues.Source source) {
        this.source = source;
    }

    protected DocValues.Source loadSource() throws IOException {
        return this.source;
    }

    protected DocValues.Source loadDirectSource() throws IOException {
        return this.source;
    }

    public DocValues.Type getType() {
        return this.source.getType();
    }

    public int getValueSize() {
        return 1;
    }

    public static class SingleValueSource
    extends DocValues.Source {
        private final Number numericValue;
        private final BytesRef binaryValue;

        protected SingleValueSource(Norm norm) {
            super(norm.type());
            this.numericValue = norm.field().numericValue();
            this.binaryValue = norm.field().binaryValue();
        }

        public long getInt(int docID) {
            switch (this.type) {
                case FIXED_INTS_16: 
                case FIXED_INTS_32: 
                case FIXED_INTS_64: 
                case FIXED_INTS_8: 
                case VAR_INTS: {
                    assert (this.numericValue != null);
                    return this.numericValue.longValue();
                }
            }
            return super.getInt(docID);
        }

        public double getFloat(int docID) {
            switch (this.type) {
                case FLOAT_32: 
                case FLOAT_64: {
                    assert (this.numericValue != null);
                    return this.numericValue.floatValue();
                }
            }
            return super.getFloat(docID);
        }

        public BytesRef getBytes(int docID, BytesRef ref) {
            switch (this.type) {
                case BYTES_FIXED_DEREF: 
                case BYTES_FIXED_SORTED: 
                case BYTES_FIXED_STRAIGHT: 
                case BYTES_VAR_DEREF: 
                case BYTES_VAR_SORTED: 
                case BYTES_VAR_STRAIGHT: {
                    assert (this.binaryValue != null);
                    ref.copyBytes(this.binaryValue);
                    return ref;
                }
            }
            return super.getBytes(docID, ref);
        }

        public boolean hasArray() {
            return true;
        }

        public Object getArray() {
            switch (this.type) {
                case BYTES_FIXED_DEREF: 
                case BYTES_FIXED_SORTED: 
                case BYTES_FIXED_STRAIGHT: 
                case BYTES_VAR_DEREF: 
                case BYTES_VAR_SORTED: 
                case BYTES_VAR_STRAIGHT: {
                    return this.binaryValue.bytes;
                }
                case FIXED_INTS_16: {
                    return new short[]{this.numericValue.shortValue()};
                }
                case FIXED_INTS_32: {
                    return new int[]{this.numericValue.intValue()};
                }
                case FIXED_INTS_64: {
                    return new long[]{this.numericValue.longValue()};
                }
                case FIXED_INTS_8: {
                    return new byte[]{this.numericValue.byteValue()};
                }
                case VAR_INTS: {
                    return new long[]{this.numericValue.longValue()};
                }
                case FLOAT_32: {
                    return new float[]{this.numericValue.floatValue()};
                }
                case FLOAT_64: {
                    return new double[]{this.numericValue.doubleValue()};
                }
            }
            throw new IllegalArgumentException("unknown type " + this.type);
        }
    }
}

