/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.models.util.twentynewsgroups;

import java.io.BufferedReader;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.lucene.luke.models.util.twentynewsgroups.Message;
import org.apache.lucene.luke.util.LoggerFactory;

public class MessageFilesParser
extends SimpleFileVisitor<Path> {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Path root;
    private final List<Message> messages = new ArrayList<Message>();

    public MessageFilesParser(Path root) {
        this.root = root;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attr) {
        try {
            Message message;
            if (attr.isRegularFile() && (message = this.parse(file)) != null) {
                this.messages.add(this.parse(file));
            }
        }
        catch (IOException e) {
            log.log(Level.WARNING, "Invalid file? " + file, e);
        }
        return FileVisitResult.CONTINUE;
    }

    Message parse(Path file) throws IOException {
        try (BufferedReader br = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
            String line = br.readLine();
            Message message = new Message();
            while (!line.equals("")) {
                String[] ary = line.split(":", 2);
                if (ary.length < 2) {
                    line = br.readLine();
                    continue;
                }
                String att = ary[0].trim();
                String val = ary[1].trim();
                switch (att) {
                    case "From": {
                        message.setFrom(val);
                        break;
                    }
                    case "Newsgroups": {
                        message.setNewsgroups(val.split(","));
                        break;
                    }
                    case "Subject": {
                        message.setSubject(val);
                        break;
                    }
                    case "Message-ID": {
                        message.setMessageId(val);
                        break;
                    }
                    case "Date": {
                        message.setDate(val);
                        break;
                    }
                    case "Organization": {
                        message.setOrganization(val);
                        break;
                    }
                    case "Lines": {
                        try {
                            message.setLines(Integer.parseInt(ary[1].trim()));
                        }
                        catch (NumberFormatException numberFormatException) {}
                        break;
                    }
                }
                line = br.readLine();
            }
            StringBuilder sb = new StringBuilder();
            while (line != null) {
                sb.append(line);
                sb.append(" ");
                line = br.readLine();
            }
            message.setBody(sb.toString());
            Message message2 = message;
            return message2;
        }
    }

    public List<Message> parseAll() throws IOException {
        Files.walkFileTree(this.root, this);
        return this.messages;
    }
}

