/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.models.documents;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.logging.Logger;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.luke.models.documents.TermVectorEntry;
import org.apache.lucene.luke.util.LoggerFactory;

final class TermVectorsAdapter {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private IndexReader reader;

    TermVectorsAdapter(IndexReader reader) {
        this.reader = Objects.requireNonNull(reader);
    }

    List<TermVectorEntry> getTermVector(int docid, String field) throws IOException {
        Terms termVector = this.reader.getTermVector(docid, field);
        if (termVector == null) {
            log.warning(() -> String.format(Locale.ROOT, "No term vector indexed for doc: #%s and field: %s", docid, field));
            return Collections.emptyList();
        }
        ArrayList<TermVectorEntry> res = new ArrayList<TermVectorEntry>();
        TermsEnum te = termVector.iterator();
        while (te.next() != null) {
            res.add(TermVectorEntry.of(te));
        }
        return res;
    }
}

