/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.luke.models.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TotalHits;

public final class SearchResults {
    private TotalHits totalHits;
    private int offset = 0;
    private List<Doc> hits = new ArrayList<Doc>();

    static SearchResults of(TotalHits totalHits, ScoreDoc[] docs, int offset, IndexSearcher searcher, Set<String> fieldsToLoad) throws IOException {
        SearchResults res = new SearchResults();
        res.totalHits = Objects.requireNonNull(totalHits);
        Objects.requireNonNull(docs);
        Objects.requireNonNull(searcher);
        for (ScoreDoc sd : docs) {
            Document luceneDoc = fieldsToLoad == null ? searcher.doc(sd.doc) : searcher.doc(sd.doc, fieldsToLoad);
            res.hits.add(Doc.of(sd.doc, sd.score, luceneDoc));
            res.offset = offset;
        }
        return res;
    }

    public TotalHits getTotalHits() {
        return this.totalHits;
    }

    public int getOffset() {
        return this.offset;
    }

    public List<Doc> getHits() {
        return List.copyOf(this.hits);
    }

    public int size() {
        return this.hits.size();
    }

    private SearchResults() {
    }

    public static class Doc {
        private int docId;
        private float score;
        private Map<String, String[]> fieldValues = new HashMap<String, String[]>();

        static Doc of(int docId, float score, Document luceneDoc) {
            Objects.requireNonNull(luceneDoc);
            Doc doc = new Doc();
            doc.docId = docId;
            doc.score = score;
            Set fields = luceneDoc.getFields().stream().map(IndexableField::name).collect(Collectors.toSet());
            for (String f : fields) {
                doc.fieldValues.put(f, luceneDoc.getValues(f));
            }
            return doc;
        }

        public int getDocId() {
            return this.docId;
        }

        public float getScore() {
            return this.score;
        }

        public Map<String, String[]> getFieldValues() {
            return Map.copyOf(this.fieldValues);
        }

        private Doc() {
        }
    }
}

