/*
 * Decompiled with CFR 0.152.
 */
package lucli;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import jline.ConsoleReader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.queryParser.MultiFieldQueryParser;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LuceneMethods {
    private int numDocs;
    private final FSDirectory indexName;
    private List<String> fields;
    private List<String> indexedFields;
    private String[] fieldsArray;
    private Searcher searcher;
    private Query query;
    private String analyzerClassFQN = null;

    public LuceneMethods(String index) throws IOException {
        this.indexName = FSDirectory.open((File)new File(index));
        LuceneMethods.message("Lucene CLI. Using directory '" + this.indexName + "'. Type 'help' for instructions.");
    }

    private Analyzer createAnalyzer() {
        if (this.analyzerClassFQN == null) {
            return new StandardAnalyzer(Version.LUCENE_CURRENT);
        }
        try {
            return Class.forName(this.analyzerClassFQN).asSubclass(Analyzer.class).newInstance();
        }
        catch (ClassCastException cce) {
            LuceneMethods.message("Given class is not an Analyzer: " + this.analyzerClassFQN);
            return new StandardAnalyzer(Version.LUCENE_CURRENT);
        }
        catch (Exception e) {
            LuceneMethods.message("Unable to use Analyzer " + this.analyzerClassFQN);
            return new StandardAnalyzer(Version.LUCENE_CURRENT);
        }
    }

    public void info() throws IOException {
        IndexReader indexReader = IndexReader.open((Directory)this.indexName, (boolean)true);
        this.getFieldInfo();
        this.numDocs = indexReader.numDocs();
        LuceneMethods.message("Index has " + this.numDocs + " documents ");
        LuceneMethods.message("All Fields:" + this.fields.toString());
        LuceneMethods.message("Indexed Fields:" + this.indexedFields.toString());
        if (IndexWriter.isLocked((Directory)this.indexName)) {
            LuceneMethods.message("Index is locked");
        }
        indexReader.close();
    }

    public void search(String queryString, boolean explain, boolean showTokens, ConsoleReader cr) throws IOException, ParseException {
        this.initSearch(queryString);
        int numHits = this.computeCount(this.query);
        LuceneMethods.message(numHits + " total matching documents");
        if (explain) {
            this.query = this.explainQuery(queryString);
        }
        int HITS_PER_PAGE = 10;
        LuceneMethods.message("--------------------------------------");
        for (int start = 0; start < numHits; start += 10) {
            int end = Math.min(numHits, start + 10);
            ScoreDoc[] hits = this.search(this.query, end);
            for (int ii = start; ii < end; ++ii) {
                Document doc = this.searcher.doc(hits[ii].doc);
                LuceneMethods.message("---------------- " + (ii + 1) + " score:" + hits[ii].score + "---------------------");
                this.printHit(doc);
                if (showTokens) {
                    this.invertDocument(doc);
                }
                if (!explain) continue;
                Explanation exp = this.searcher.explain(this.query, hits[ii].doc);
                LuceneMethods.message("Explanation:" + exp.toString());
            }
            LuceneMethods.message("#################################################");
            if (numHits > end && ((queryString = cr.readLine("more (y/n) ? ")).length() == 0 || queryString.charAt(0) == 'n')) break;
        }
        this.searcher.close();
    }

    private void printHit(Document doc) {
        for (int ii = 0; ii < this.fieldsArray.length; ++ii) {
            String currField = this.fieldsArray[ii];
            String[] result = doc.getValues(currField);
            if (result != null) {
                for (int i = 0; i < result.length; ++i) {
                    LuceneMethods.message(currField + ":" + result[i]);
                }
                continue;
            }
            LuceneMethods.message(currField + ": <not available>");
        }
    }

    public void optimize() throws IOException {
        IndexWriter indexWriter = new IndexWriter((Directory)this.indexName, this.createAnalyzer(), false, IndexWriter.MaxFieldLength.UNLIMITED);
        LuceneMethods.message("Starting to optimize index.");
        long start = System.currentTimeMillis();
        indexWriter.optimize();
        LuceneMethods.message("Done optimizing index. Took " + (System.currentTimeMillis() - start) + " msecs");
        indexWriter.close();
    }

    private Query explainQuery(String queryString) throws IOException, ParseException {
        this.searcher = new IndexSearcher((Directory)this.indexName, true);
        Analyzer analyzer = this.createAnalyzer();
        this.getFieldInfo();
        int arraySize = this.indexedFields.size();
        String[] indexedArray = new String[arraySize];
        for (int ii = 0; ii < arraySize; ++ii) {
            indexedArray[ii] = this.indexedFields.get(ii);
        }
        MultiFieldQueryParser parser = new MultiFieldQueryParser(Version.LUCENE_CURRENT, indexedArray, analyzer);
        this.query = parser.parse(queryString);
        LuceneMethods.message("Searching for: " + this.query.toString());
        return this.query;
    }

    private void initSearch(String queryString) throws IOException, ParseException {
        this.searcher = new IndexSearcher((Directory)this.indexName, true);
        Analyzer analyzer = this.createAnalyzer();
        this.getFieldInfo();
        int arraySize = this.fields.size();
        this.fieldsArray = new String[arraySize];
        for (int ii = 0; ii < arraySize; ++ii) {
            this.fieldsArray[ii] = this.fields.get(ii);
        }
        MultiFieldQueryParser parser = new MultiFieldQueryParser(Version.LUCENE_CURRENT, this.fieldsArray, analyzer);
        this.query = parser.parse(queryString);
        System.out.println("Searching for: " + this.query.toString());
    }

    private int computeCount(Query q) throws IOException {
        CountingCollector countingCollector = new CountingCollector();
        this.searcher.search(q, (Collector)countingCollector);
        return countingCollector.numHits;
    }

    public void count(String queryString) throws IOException, ParseException {
        this.initSearch(queryString);
        LuceneMethods.message(this.computeCount(this.query) + " total documents");
        this.searcher.close();
    }

    private ScoreDoc[] search(Query q, int numHits) throws IOException {
        return this.searcher.search((Query)this.query, (int)numHits).scoreDocs;
    }

    public static void message(String s) {
        System.out.println(s);
    }

    private void getFieldInfo() throws IOException {
        IndexReader indexReader = IndexReader.open((Directory)this.indexName, (boolean)true);
        this.fields = new ArrayList<String>();
        this.indexedFields = new ArrayList<String>();
        for (String field : indexReader.getFieldNames(IndexReader.FieldOption.ALL)) {
            if (field == null || field.equals("")) continue;
            this.fields.add(field.toString());
        }
        for (String field : indexReader.getFieldNames(IndexReader.FieldOption.INDEXED)) {
            if (field == null || field.equals("")) continue;
            this.indexedFields.add(field.toString());
        }
        indexReader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invertDocument(Document doc) throws IOException {
        HashMap<String, Integer> tokenMap = new HashMap<String, Integer>();
        int maxFieldLength = 10000;
        Analyzer analyzer = this.createAnalyzer();
        block3: for (Fieldable field : doc.getFields()) {
            Reader reader;
            String fieldName = field.name();
            if (!field.isIndexed() || !field.isTokenized()) continue;
            if (field.readerValue() != null) {
                reader = field.readerValue();
            } else if (field.stringValue() != null) {
                reader = new StringReader(field.stringValue());
            } else {
                throw new IllegalArgumentException("field must have either String or Reader value");
            }
            int position = 0;
            TokenStream stream = analyzer.tokenStream(fieldName, reader);
            TermAttribute termAtt = (TermAttribute)stream.addAttribute(TermAttribute.class);
            PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)stream.addAttribute(PositionIncrementAttribute.class);
            try {
                while (stream.incrementToken()) {
                    position += posIncrAtt.getPositionIncrement() - 1;
                    ++position;
                    String name = termAtt.term();
                    Integer Count = (Integer)tokenMap.get(name);
                    if (Count == null) {
                        tokenMap.put(name, 1);
                    } else {
                        int count = Count;
                        tokenMap.put(name, count + 1);
                    }
                    if (position <= 10000) continue;
                    continue block3;
                }
            }
            finally {
                stream.close();
            }
        }
        Map.Entry<K, V>[] sortedHash = LuceneMethods.getSortedMapEntries(tokenMap);
        for (int ii = 0; ii < sortedHash.length && ii < 10; ++ii) {
            Map.Entry currentEntry = sortedHash[ii];
            LuceneMethods.message(ii + 1 + ":" + (String)currentEntry.getKey() + " " + currentEntry.getValue());
        }
    }

    public void terms(String field) throws IOException {
        TreeMap<String, Integer> termMap = new TreeMap<String, Integer>();
        IndexReader indexReader = IndexReader.open((Directory)this.indexName, (boolean)true);
        TermEnum terms = indexReader.terms();
        while (terms.next()) {
            Term term = terms.term();
            if (field != null && !field.equals(term.field())) continue;
            termMap.put(term.field() + ":" + term.text(), terms.docFreq());
        }
        Iterator termIterator = termMap.keySet().iterator();
        for (int ii = 0; termIterator.hasNext() && ii < 100; ++ii) {
            String termDetails = (String)termIterator.next();
            Integer termFreq = (Integer)termMap.get(termDetails);
            LuceneMethods.message(termDetails + ": " + termFreq);
        }
        indexReader.close();
    }

    public static <K, V extends Comparable<V>> Map.Entry<K, V>[] getSortedMapEntries(Map<K, V> m) {
        Set<Map.Entry<K, V>> set = m.entrySet();
        Map.Entry[] entries = set.toArray(new Map.Entry[set.size()]);
        Arrays.sort(entries, new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> o1, Map.Entry<K, V> o2) {
                Comparable v1 = (Comparable)o1.getValue();
                Comparable v2 = (Comparable)o2.getValue();
                return v2.compareTo(v1);
            }
        });
        return entries;
    }

    public void analyzer(String word) {
        if ("current".equals(word)) {
            String current = this.analyzerClassFQN == null ? "StandardAnalyzer" : this.analyzerClassFQN;
            LuceneMethods.message("The currently used Analyzer class is: " + current);
            return;
        }
        this.analyzerClassFQN = word;
        LuceneMethods.message("Switched to Analyzer class " + this.analyzerClassFQN);
    }

    static final class CountingCollector
    extends Collector {
        public int numHits = 0;

        CountingCollector() {
        }

        public void setScorer(Scorer scorer) throws IOException {
        }

        public void collect(int doc) throws IOException {
            ++this.numHits;
        }

        public void setNextReader(IndexReader reader, int docBase) {
        }

        public boolean acceptsDocsOutOfOrder() {
            return true;
        }
    }
}

