/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefHash;

abstract class TermsCollector
extends SimpleCollector {
    final String field;
    final BytesRefHash collectorTerms = new BytesRefHash();

    TermsCollector(String field) {
        this.field = field;
    }

    public BytesRefHash getCollectorTerms() {
        return this.collectorTerms;
    }

    static TermsCollector create(String field, boolean multipleValuesPerDocument) {
        return multipleValuesPerDocument ? new MV(field) : new SV(field);
    }

    static class SV
    extends TermsCollector {
        final BytesRef spare = new BytesRef();
        private BinaryDocValues fromDocTerms;

        SV(String field) {
            super(field);
        }

        public void collect(int doc) throws IOException {
            BytesRef term = this.fromDocTerms.get(doc);
            this.collectorTerms.add(term);
        }

        protected void doSetNextReader(LeafReaderContext context) throws IOException {
            this.fromDocTerms = DocValues.getBinary((LeafReader)context.reader(), (String)this.field);
        }
    }

    static class MV
    extends TermsCollector {
        final BytesRef scratch = new BytesRef();
        private SortedSetDocValues docTermOrds;

        MV(String field) {
            super(field);
        }

        public void collect(int doc) throws IOException {
            long ord;
            this.docTermOrds.setDocument(doc);
            while ((ord = this.docTermOrds.nextOrd()) != -1L) {
                BytesRef term = this.docTermOrds.lookupOrd(ord);
                this.collectorTerms.add(term);
            }
        }

        protected void doSetNextReader(LeafReaderContext context) throws IOException {
            this.docTermOrds = DocValues.getSortedSet((LeafReader)context.reader(), (String)this.field);
        }
    }
}

