/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.CachingWrapperFilter;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.FilterCachingPolicy;
import org.apache.lucene.search.join.BitDocIdSetFilter;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BitDocIdSet;

public class BitDocIdSetCachingWrapperFilter
extends BitDocIdSetFilter
implements Accountable {
    private final CachingWrapperFilter filter;

    public BitDocIdSetCachingWrapperFilter(Filter filter) {
        this.filter = new CachingWrapperFilter(filter, FilterCachingPolicy.ALWAYS_CACHE){

            protected BitDocIdSet docIdSetToCache(DocIdSet docIdSet, LeafReader reader) throws IOException {
                if (docIdSet == null || docIdSet instanceof BitDocIdSet) {
                    return (BitDocIdSet)docIdSet;
                }
                DocIdSetIterator it = docIdSet.iterator();
                if (it == null) {
                    return null;
                }
                BitDocIdSet.Builder builder = new BitDocIdSet.Builder(reader.maxDoc());
                builder.or(it);
                return builder.build();
            }
        };
    }

    @Override
    public BitDocIdSet getDocIdSet(LeafReaderContext context) throws IOException {
        return (BitDocIdSet)this.filter.getDocIdSet(context, null);
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode() ^ this.filter.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BitDocIdSetCachingWrapperFilter)) {
            return false;
        }
        return this.filter.equals((Object)((BitDocIdSetCachingWrapperFilter)((Object)obj)).filter);
    }

    public String toString() {
        return this.filter.toString();
    }

    public long ramBytesUsed() {
        return this.filter.ramBytesUsed();
    }

    public Collection<Accountable> getChildResources() {
        return this.filter.getChildResources();
    }
}

