/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.FixedBitSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToParentBlockJoinQuery
extends Query {
    private final Filter parentsFilter;
    private final Query childQuery;
    private final Query origChildQuery;
    private final ScoreMode scoreMode;

    public ToParentBlockJoinQuery(Query childQuery, Filter parentsFilter, ScoreMode scoreMode) {
        this.origChildQuery = childQuery;
        this.childQuery = childQuery;
        this.parentsFilter = parentsFilter;
        this.scoreMode = scoreMode;
    }

    private ToParentBlockJoinQuery(Query origChildQuery, Query childQuery, Filter parentsFilter, ScoreMode scoreMode) {
        this.origChildQuery = origChildQuery;
        this.childQuery = childQuery;
        this.parentsFilter = parentsFilter;
        this.scoreMode = scoreMode;
    }

    public Weight createWeight(Searcher searcher) throws IOException {
        return new BlockJoinWeight(this, this.childQuery.createWeight(searcher), this.parentsFilter, this.scoreMode);
    }

    public void extractTerms(Set<Term> terms) {
        this.childQuery.extractTerms(terms);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query childRewrite = this.childQuery.rewrite(reader);
        if (childRewrite != this.childQuery) {
            ToParentBlockJoinQuery rewritten = new ToParentBlockJoinQuery(this.childQuery, childRewrite, this.parentsFilter, this.scoreMode);
            rewritten.setBoost(this.getBoost());
            return rewritten;
        }
        return this;
    }

    public String toString(String field) {
        return "ToParentBlockJoinQuery (" + this.childQuery.toString() + ")";
    }

    public boolean equals(Object _other) {
        if (_other instanceof ToParentBlockJoinQuery) {
            ToParentBlockJoinQuery other = (ToParentBlockJoinQuery)((Object)_other);
            return this.origChildQuery.equals((Object)other.origChildQuery) && this.parentsFilter.equals(other.parentsFilter) && this.scoreMode == other.scoreMode;
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int hash = 1;
        hash = 31 * hash + this.origChildQuery.hashCode();
        hash = 31 * hash + this.scoreMode.hashCode();
        hash = 31 * hash + this.parentsFilter.hashCode();
        return hash;
    }

    public Object clone() {
        return new ToParentBlockJoinQuery((Query)this.origChildQuery.clone(), this.parentsFilter, this.scoreMode);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BlockJoinScorer
    extends Scorer {
        private final Scorer childScorer;
        private final FixedBitSet parentBits;
        private final ScoreMode scoreMode;
        private int parentDoc = -1;
        private float parentScore;
        private int nextChildDoc;
        private int[] pendingChildDocs = new int[5];
        private float[] pendingChildScores;
        private int childDocUpto;

        public BlockJoinScorer(Weight weight, Scorer childScorer, FixedBitSet parentBits, int firstChildDoc, ScoreMode scoreMode) {
            super(weight);
            this.parentBits = parentBits;
            this.childScorer = childScorer;
            this.scoreMode = scoreMode;
            if (scoreMode != ScoreMode.None) {
                this.pendingChildScores = new float[5];
            }
            this.nextChildDoc = firstChildDoc;
        }

        public void visitSubScorers(Query parent, BooleanClause.Occur relationship, Scorer.ScorerVisitor<Query, Query, Scorer> visitor) {
            super.visitSubScorers(parent, relationship, visitor);
            this.childScorer.visitScorers(visitor);
        }

        int getChildCount() {
            return this.childDocUpto;
        }

        int[] swapChildDocs(int[] other) {
            int[] ret = this.pendingChildDocs;
            this.pendingChildDocs = other == null ? new int[5] : other;
            return ret;
        }

        float[] swapChildScores(float[] other) {
            if (this.scoreMode == ScoreMode.None) {
                throw new IllegalStateException("ScoreMode is None; you must pass trackScores=false to ToParentBlockJoinCollector");
            }
            float[] ret = this.pendingChildScores;
            this.pendingChildScores = other == null ? new float[5] : other;
            return ret;
        }

        public int nextDoc() throws IOException {
            if (this.nextChildDoc == Integer.MAX_VALUE) {
                this.parentDoc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            this.parentDoc = this.parentBits.nextSetBit(this.nextChildDoc);
            assert (this.parentDoc != -1);
            float totalScore = 0.0f;
            float maxScore = Float.NEGATIVE_INFINITY;
            this.childDocUpto = 0;
            do {
                if (this.pendingChildDocs.length == this.childDocUpto) {
                    this.pendingChildDocs = ArrayUtil.grow((int[])this.pendingChildDocs);
                }
                if (this.scoreMode != ScoreMode.None && this.pendingChildScores.length == this.childDocUpto) {
                    this.pendingChildScores = ArrayUtil.grow((float[])this.pendingChildScores);
                }
                this.pendingChildDocs[this.childDocUpto] = this.nextChildDoc;
                if (this.scoreMode != ScoreMode.None) {
                    float childScore;
                    this.pendingChildScores[this.childDocUpto] = childScore = this.childScorer.score();
                    maxScore = Math.max(childScore, maxScore);
                    totalScore += childScore;
                }
                ++this.childDocUpto;
                this.nextChildDoc = this.childScorer.nextDoc();
            } while (this.nextChildDoc < this.parentDoc);
            assert (this.nextChildDoc != this.parentDoc);
            switch (this.scoreMode) {
                case Avg: {
                    this.parentScore = totalScore / (float)this.childDocUpto;
                    break;
                }
                case Max: {
                    this.parentScore = maxScore;
                    break;
                }
                case Total: {
                    this.parentScore = totalScore;
                    break;
                }
            }
            return this.parentDoc;
        }

        public int docID() {
            return this.parentDoc;
        }

        public float score() throws IOException {
            return this.parentScore;
        }

        public int advance(int parentTarget) throws IOException {
            if (parentTarget == Integer.MAX_VALUE) {
                this.parentDoc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            }
            if (parentTarget == 0) {
                return this.nextDoc();
            }
            int prevParentDoc = this.parentBits.prevSetBit(parentTarget - 1);
            assert (prevParentDoc >= this.parentDoc);
            if (prevParentDoc > this.nextChildDoc) {
                this.nextChildDoc = this.childScorer.advance(prevParentDoc);
            }
            assert (this.nextChildDoc != prevParentDoc);
            int nd = this.nextDoc();
            return nd;
        }
    }

    private static class BlockJoinWeight
    extends Weight {
        private final Query joinQuery;
        private final Weight childWeight;
        private final Filter parentsFilter;
        private final ScoreMode scoreMode;

        public BlockJoinWeight(Query joinQuery, Weight childWeight, Filter parentsFilter, ScoreMode scoreMode) {
            this.joinQuery = joinQuery;
            this.childWeight = childWeight;
            this.parentsFilter = parentsFilter;
            this.scoreMode = scoreMode;
        }

        public Query getQuery() {
            return this.joinQuery;
        }

        public float getValue() {
            return this.childWeight.getValue();
        }

        public float sumOfSquaredWeights() throws IOException {
            return this.childWeight.sumOfSquaredWeights() * this.joinQuery.getBoost() * this.joinQuery.getBoost();
        }

        public void normalize(float norm) {
            this.childWeight.normalize(norm * this.joinQuery.getBoost());
        }

        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            Scorer childScorer = this.childWeight.scorer(reader, true, false);
            if (childScorer == null) {
                return null;
            }
            int firstChildDoc = childScorer.nextDoc();
            if (firstChildDoc == Integer.MAX_VALUE) {
                return null;
            }
            DocIdSet parents = this.parentsFilter.getDocIdSet(reader);
            if (parents == null) {
                return null;
            }
            if (!(parents instanceof FixedBitSet)) {
                throw new IllegalStateException("parentFilter must return FixedBitSet; got " + parents);
            }
            return new BlockJoinScorer(this, childScorer, (FixedBitSet)parents, firstChildDoc, this.scoreMode);
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getName() + " cannot explain match on parent document");
        }

        public boolean scoresDocsOutOfOrder() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ScoreMode {
        None,
        Avg,
        Max,
        Total;

    }
}

