/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.FilteredTermEnum;
import org.apache.lucene.search.MultiTermQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TermsQuery
extends MultiTermQuery {
    private static final FilteredTermEnum EMPTY = new FilteredTermEnum(){

        public boolean next() throws IOException {
            return false;
        }

        public Term term() {
            return null;
        }

        public int docFreq() {
            throw new IllegalStateException("this method should never be called");
        }

        public void close() throws IOException {
        }

        protected boolean termCompare(Term term) {
            throw new IllegalStateException("this method should never be called");
        }

        public float difference() {
            throw new IllegalStateException("this method should never be called");
        }

        protected boolean endEnum() {
            throw new IllegalStateException("this method should never be called");
        }
    };
    private final String[] terms;
    private final String field;

    TermsQuery(String field, Set<String> terms) {
        this.field = field;
        this.terms = terms.toArray(new String[terms.size()]);
        Arrays.sort(this.terms);
    }

    protected FilteredTermEnum getEnum(IndexReader reader) throws IOException {
        if (this.terms.length == 0) {
            return EMPTY;
        }
        TermEnum termEnum = reader.terms(new Term(this.field, this.terms[0]));
        Term firstTerm = termEnum.term();
        if (firstTerm == null || this.field != firstTerm.field()) {
            return EMPTY;
        }
        return new SeekingTermsEnum(termEnum, firstTerm, this.field, this.terms);
    }

    public String toString(String string) {
        return "TermsQuery{field=" + this.field + '}';
    }

    static class SeekingTermsEnum
    extends FilteredTermEnum {
        private final String[] terms;
        private final String field;
        private final int lastPosition;
        private boolean endEnum;
        private int upto;

        SeekingTermsEnum(TermEnum termEnum, Term firstTerm, String field, String[] terms) throws IOException {
            this.terms = terms;
            this.field = field;
            this.lastPosition = terms.length - 1;
            this.upto = Arrays.binarySearch(terms, firstTerm.text());
            if (this.upto < 0) {
                this.upto = 0;
            }
            this.endEnum = this.upto == this.lastPosition;
            this.setEnum(termEnum);
        }

        protected boolean termCompare(Term term) {
            if (term == null || term.field() != this.field) {
                this.endEnum = true;
                return false;
            }
            int cmp = this.terms[this.upto].compareTo(term.text());
            if (cmp < 0) {
                if (this.upto == this.lastPosition) {
                    return false;
                }
                while ((cmp = this.terms[++this.upto].compareTo(term.text())) < 0) {
                    if (this.upto != this.lastPosition) continue;
                    this.endEnum = true;
                    return false;
                }
                assert (cmp >= 0) : "cmp cannot be lower than zero";
                if (cmp == 0) {
                    ++this.upto;
                    this.endEnum = this.upto > this.lastPosition;
                    return true;
                }
                return false;
            }
            if (cmp > 0) {
                return false;
            }
            ++this.upto;
            this.endEnum = this.upto > this.lastPosition;
            return true;
        }

        public float difference() {
            return 1.0f;
        }

        protected boolean endEnum() {
            return this.endEnum;
        }
    }
}

