/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.instantiated;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermVectorOffsetInfo;
import org.apache.lucene.search.DefaultSimilarity;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.store.instantiated.InstantiatedDocument;
import org.apache.lucene.store.instantiated.InstantiatedIndex;
import org.apache.lucene.store.instantiated.InstantiatedIndexReader;
import org.apache.lucene.store.instantiated.InstantiatedTerm;
import org.apache.lucene.store.instantiated.InstantiatedTermDocumentInformation;
import org.apache.lucene.util.StringHelper;

public class InstantiatedIndexWriter {
    private PrintStream infoStream = null;
    private int maxFieldLength = 10000;
    private final InstantiatedIndex index;
    private final Analyzer analyzer;
    private Similarity similarity = Similarity.getDefault();
    private transient Set<String> fieldNameBuffer;
    private Map<InstantiatedDocument, Map<FieldSetting, Map<String, TermDocumentInformationFactory>>> termDocumentInformationFactoryByDocument = new LinkedHashMap<InstantiatedDocument, Map<FieldSetting, Map<String, TermDocumentInformationFactory>>>(2000);
    private Set<InstantiatedDocument> unflushedDocuments = new HashSet<InstantiatedDocument>();
    private int mergeFactor = 2500;
    private Set<Term> unflushedDeletions = new HashSet<Term>();

    public InstantiatedIndexWriter(InstantiatedIndex index) throws IOException {
        this(index, null);
    }

    public InstantiatedIndexWriter(InstantiatedIndex index, Analyzer analyzer) throws IOException {
        this(index, analyzer, false);
    }

    public InstantiatedIndexWriter(InstantiatedIndex index, Analyzer analyzer, boolean create) throws IOException {
        this.index = index;
        this.analyzer = analyzer;
        this.fieldNameBuffer = new HashSet<String>();
        if (create) {
            this.index.initialize();
        }
    }

    public void setMergeFactor(int mergeFactor) {
        this.mergeFactor = mergeFactor;
    }

    public int getMergeFactor() {
        return this.mergeFactor;
    }

    public void setInfoStream(PrintStream infoStream) {
        this.infoStream = infoStream;
    }

    public void abort() throws IOException {
    }

    public void addIndexes(IndexReader[] readers) {
        throw new RuntimeException("Not implemented");
    }

    public PrintStream getInfoStream() {
        return this.infoStream;
    }

    public void close() throws IOException {
        this.commit();
    }

    public int docCount() {
        return this.index.getDocumentsByNumber().length + this.unflushedDocuments.size();
    }

    public void commit() throws IOException {
        byte[] norms;
        boolean orderedTermsDirty = false;
        HashSet<InstantiatedTerm> dirtyTerms = new HashSet<InstantiatedTerm>(1000);
        HashMap<String, FieldSetting> fieldSettingsByFieldName = new HashMap<String, FieldSetting>();
        for (String fieldName : this.fieldNameBuffer) {
            fieldSettingsByFieldName.put(fieldName, new FieldSetting(fieldName));
        }
        InstantiatedDocument[] documentsByNumber = new InstantiatedDocument[this.index.getDocumentsByNumber().length + this.termDocumentInformationFactoryByDocument.size()];
        System.arraycopy(this.index.getDocumentsByNumber(), 0, documentsByNumber, 0, this.index.getDocumentsByNumber().length);
        int documentNumber = this.index.getDocumentsByNumber().length;
        ArrayList<InstantiatedTerm> orderedTerms = new ArrayList<InstantiatedTerm>(this.index.getOrderedTerms().length + 5000);
        for (InstantiatedTerm instantiatedTerm : this.index.getOrderedTerms()) {
            orderedTerms.add(instantiatedTerm);
        }
        HashMap<String, byte[]> normsByFieldNameAndDocumentNumber = new HashMap<String, byte[]>(this.index.getTermsByFieldAndText().size());
        HashSet<String> fieldNames = new HashSet<String>(20);
        fieldNames.addAll(this.index.getNormsByFieldNameAndDocumentNumber().keySet());
        fieldNames.addAll(this.fieldNameBuffer);
        for (String string : this.index.getTermsByFieldAndText().keySet()) {
            norms = new byte[this.index.getDocumentsByNumber().length + this.termDocumentInformationFactoryByDocument.size()];
            byte[] oldNorms = this.index.getNormsByFieldNameAndDocumentNumber().get(string);
            if (oldNorms != null) {
                System.arraycopy(oldNorms, 0, norms, 0, oldNorms.length);
                Arrays.fill(norms, oldNorms.length, norms.length, DefaultSimilarity.encodeNorm((float)1.0f));
            } else {
                Arrays.fill(norms, 0, norms.length, DefaultSimilarity.encodeNorm((float)1.0f));
            }
            normsByFieldNameAndDocumentNumber.put(string, norms);
            fieldNames.remove(string);
        }
        for (String string : fieldNames) {
            norms = new byte[this.index.getDocumentsByNumber().length + this.termDocumentInformationFactoryByDocument.size()];
            Arrays.fill(norms, 0, norms.length, DefaultSimilarity.encodeNorm((float)1.0f));
            normsByFieldNameAndDocumentNumber.put(string, norms);
        }
        fieldNames.clear();
        this.index.setNormsByFieldNameAndDocumentNumber(normsByFieldNameAndDocumentNumber);
        for (Map.Entry entry : this.termDocumentInformationFactoryByDocument.entrySet()) {
            InstantiatedDocument document = (InstantiatedDocument)entry.getKey();
            document.setDocumentNumber(documentNumber++);
            documentsByNumber[document.getDocumentNumber().intValue()] = document;
            int numFieldsWithTermVectorsInDocument = 0;
            int termsInDocument = 0;
            for (Map.Entry eFieldTermDocInfoFactoriesByTermText : ((Map)entry.getValue()).entrySet()) {
                if (((FieldSetting)eFieldTermDocInfoFactoriesByTermText.getKey()).storeTermVector) {
                    numFieldsWithTermVectorsInDocument += ((Map)eFieldTermDocInfoFactoriesByTermText.getValue()).size();
                }
                termsInDocument += ((Map)eFieldTermDocInfoFactoriesByTermText.getValue()).size();
                if (((FieldSetting)eFieldTermDocInfoFactoriesByTermText.getKey()).indexed && !((FieldSetting)eFieldTermDocInfoFactoriesByTermText.getKey()).omitNorms) {
                    float norm = ((FieldSetting)eFieldTermDocInfoFactoriesByTermText.getKey()).boost;
                    norm *= document.getDocument().getBoost();
                    ((byte[])normsByFieldNameAndDocumentNumber.get((Object)((FieldSetting)eFieldTermDocInfoFactoriesByTermText.getKey()).fieldName))[document.getDocumentNumber().intValue()] = Similarity.encodeNorm((float)(norm *= this.similarity.lengthNorm(((FieldSetting)eFieldTermDocInfoFactoriesByTermText.getKey()).fieldName, ((FieldSetting)eFieldTermDocInfoFactoriesByTermText.getKey()).fieldLength)));
                    continue;
                }
                System.currentTimeMillis();
            }
            HashMap<InstantiatedTerm, InstantiatedTermDocumentInformation> informationByTermOfCurrentDocument = new HashMap<InstantiatedTerm, InstantiatedTermDocumentInformation>(termsInDocument);
            HashMap documentFieldSettingsByFieldName = new HashMap(((Map)entry.getValue()).size());
            for (Map.Entry eFieldSetting_TermDocInfoFactoriesByTermText : ((Map)entry.getValue()).entrySet()) {
                documentFieldSettingsByFieldName.put(((FieldSetting)eFieldSetting_TermDocInfoFactoriesByTermText.getKey()).fieldName, eFieldSetting_TermDocInfoFactoriesByTermText.getKey());
                for (Map.Entry eTermText_TermDocInfoFactory : ((Map)eFieldSetting_TermDocInfoFactoriesByTermText.getValue()).entrySet()) {
                    InstantiatedTermDocumentInformation[] associatedDocuments;
                    InstantiatedTerm term;
                    Map<String, InstantiatedTerm> termsByText = this.index.getTermsByFieldAndText().get(((FieldSetting)eFieldSetting_TermDocInfoFactoriesByTermText.getKey()).fieldName);
                    if (termsByText == null) {
                        termsByText = new HashMap<String, InstantiatedTerm>(1000);
                        this.index.getTermsByFieldAndText().put(((FieldSetting)eFieldSetting_TermDocInfoFactoriesByTermText.getKey()).fieldName, termsByText);
                        term = new InstantiatedTerm(((FieldSetting)eFieldSetting_TermDocInfoFactoriesByTermText.getKey()).fieldName, (String)eTermText_TermDocInfoFactory.getKey());
                        termsByText.put((String)eTermText_TermDocInfoFactory.getKey(), term);
                        int pos = Collections.binarySearch(orderedTerms, term, InstantiatedTerm.comparator);
                        pos = -1 - pos;
                        orderedTerms.add(pos, term);
                        orderedTermsDirty = true;
                    } else {
                        term = termsByText.get(eTermText_TermDocInfoFactory.getKey());
                        if (term == null) {
                            term = new InstantiatedTerm(((FieldSetting)eFieldSetting_TermDocInfoFactoriesByTermText.getKey()).fieldName, (String)eTermText_TermDocInfoFactory.getKey());
                            termsByText.put((String)eTermText_TermDocInfoFactory.getKey(), term);
                            int pos = Collections.binarySearch(orderedTerms, term, InstantiatedTerm.comparator);
                            pos = -1 - pos;
                            orderedTerms.add(pos, term);
                            orderedTermsDirty = true;
                        }
                    }
                    int[] positions = new int[((TermDocumentInformationFactory)eTermText_TermDocInfoFactory.getValue()).termPositions.size()];
                    for (int i = 0; i < positions.length; ++i) {
                        positions[i] = (Integer)((TermDocumentInformationFactory)eTermText_TermDocInfoFactory.getValue()).termPositions.get(i);
                    }
                    byte[][] payloads = new byte[((TermDocumentInformationFactory)eTermText_TermDocInfoFactory.getValue()).payloads.size()][];
                    for (int i = 0; i < payloads.length; ++i) {
                        payloads[i] = (byte[])((TermDocumentInformationFactory)eTermText_TermDocInfoFactory.getValue()).payloads.get(i);
                    }
                    InstantiatedTermDocumentInformation info = new InstantiatedTermDocumentInformation(term, document, positions, payloads);
                    if (term.getAssociatedDocuments() != null) {
                        associatedDocuments = new InstantiatedTermDocumentInformation[term.getAssociatedDocuments().length + 1];
                        System.arraycopy(term.getAssociatedDocuments(), 0, associatedDocuments, 0, term.getAssociatedDocuments().length);
                    } else {
                        associatedDocuments = new InstantiatedTermDocumentInformation[1];
                    }
                    associatedDocuments[associatedDocuments.length - 1] = info;
                    term.setAssociatedDocuments(associatedDocuments);
                    informationByTermOfCurrentDocument.put(term, info);
                    dirtyTerms.add(term);
                }
                if (!((FieldSetting)eFieldSetting_TermDocInfoFactoriesByTermText.getKey()).storeOffsetWithTermVector) continue;
                for (Map.Entry e : informationByTermOfCurrentDocument.entrySet()) {
                    if (!((FieldSetting)eFieldSetting_TermDocInfoFactoriesByTermText.getKey()).fieldName.equals(((InstantiatedTerm)e.getKey()).field())) continue;
                    TermDocumentInformationFactory factory = (TermDocumentInformationFactory)((Map)eFieldSetting_TermDocInfoFactoriesByTermText.getValue()).get(((InstantiatedTerm)e.getKey()).text());
                    ((InstantiatedTermDocumentInformation)e.getValue()).setTermOffsets(factory.termOffsets.toArray(new TermVectorOffsetInfo[factory.termOffsets.size()]));
                }
            }
            HashMap termDocumentInformationsByField = new HashMap();
            for (Map.Entry eTerm_TermDocumentInformation : informationByTermOfCurrentDocument.entrySet()) {
                ArrayList termDocumentInformations = (ArrayList)termDocumentInformationsByField.get(((InstantiatedTerm)eTerm_TermDocumentInformation.getKey()).field());
                if (termDocumentInformations == null) {
                    termDocumentInformations = new ArrayList();
                    termDocumentInformationsByField.put(((InstantiatedTerm)eTerm_TermDocumentInformation.getKey()).field(), termDocumentInformations);
                }
                termDocumentInformations.add(eTerm_TermDocumentInformation.getValue());
            }
            for (Map.Entry eField_TermDocInfos : termDocumentInformationsByField.entrySet()) {
                Collections.sort((List)eField_TermDocInfos.getValue(), new Comparator<InstantiatedTermDocumentInformation>(){

                    @Override
                    public int compare(InstantiatedTermDocumentInformation instantiatedTermDocumentInformation, InstantiatedTermDocumentInformation instantiatedTermDocumentInformation1) {
                        return instantiatedTermDocumentInformation.getTerm().getTerm().compareTo(instantiatedTermDocumentInformation1.getTerm().getTerm());
                    }
                });
                if (!((FieldSetting)documentFieldSettingsByFieldName.get(eField_TermDocInfos.getKey())).storeTermVector) continue;
                if (document.getVectorSpace() == null) {
                    document.setVectorSpace(new HashMap<String, List<InstantiatedTermDocumentInformation>>(documentFieldSettingsByFieldName.size()));
                }
                document.getVectorSpace().put((String)eField_TermDocInfos.getKey(), (List<InstantiatedTermDocumentInformation>)eField_TermDocInfos.getValue());
            }
            fieldSettingsByFieldName.putAll(documentFieldSettingsByFieldName);
        }
        for (InstantiatedTerm instantiatedTerm : dirtyTerms) {
            Arrays.sort(instantiatedTerm.getAssociatedDocuments(), InstantiatedTermDocumentInformation.documentNumberComparator);
        }
        this.index.setDocumentsByNumber(documentsByNumber);
        this.index.setOrderedTerms(orderedTerms.toArray(new InstantiatedTerm[orderedTerms.size()]));
        for (FieldSetting fieldSetting : fieldSettingsByFieldName.values()) {
            this.index.getFieldSettings().merge(fieldSetting);
        }
        if (orderedTermsDirty) {
            for (int i = 0; i < this.index.getOrderedTerms().length; ++i) {
                this.index.getOrderedTerms()[i].setTermIndex(i);
            }
        }
        InstantiatedIndexReader indexDeleter = this.index.indexReaderFactory();
        if (this.unflushedDeletions.size() > 0) {
            for (Term term : this.unflushedDeletions) {
                indexDeleter.deleteDocuments(term);
            }
            this.unflushedDeletions.clear();
        }
        this.unflushedDocuments.clear();
        this.termDocumentInformationFactoryByDocument.clear();
        this.fieldNameBuffer.clear();
        this.index.setVersion(System.currentTimeMillis());
        indexDeleter.close();
    }

    public void addDocument(Document doc) throws IOException {
        this.addDocument(doc, this.getAnalyzer());
    }

    public void addDocument(Document doc, Analyzer analyzer) throws IOException {
        this.addDocument(new InstantiatedDocument(doc), analyzer);
    }

    protected void addDocument(InstantiatedDocument document, Analyzer analyzer) throws IOException {
        if (document.getDocumentNumber() != null) {
            throw new RuntimeException("Document number already set! Are you trying to add a document that already is bound to this or another index?");
        }
        HashMap<String, FieldSetting> fieldSettingsByFieldName = new HashMap<String, FieldSetting>();
        for (Field field : document.getDocument().getFields()) {
            FieldSetting fieldSetting = (FieldSetting)fieldSettingsByFieldName.get(field.name());
            if (fieldSetting == null) {
                fieldSetting = new FieldSetting();
                fieldSetting.fieldName = StringHelper.intern((String)field.name());
                fieldSettingsByFieldName.put(fieldSetting.fieldName, fieldSetting);
                this.fieldNameBuffer.add(fieldSetting.fieldName);
            }
            fieldSetting.boost *= field.getBoost();
            if (field.getOmitNorms()) {
                fieldSetting.omitNorms = true;
            }
            if (field.isIndexed()) {
                fieldSetting.indexed = true;
            }
            if (field.isTokenized()) {
                fieldSetting.tokenized = true;
            }
            if (field.isCompressed()) {
                fieldSetting.compressed = true;
            }
            if (field.isStored()) {
                fieldSetting.stored = true;
            }
            if (field.isBinary()) {
                fieldSetting.isBinary = true;
            }
            if (field.isTermVectorStored()) {
                fieldSetting.storeTermVector = true;
            }
            if (field.isStorePositionWithTermVector()) {
                fieldSetting.storePositionWithTermVector = true;
            }
            if (!field.isStoreOffsetWithTermVector()) continue;
            fieldSetting.storeOffsetWithTermVector = true;
        }
        LinkedHashMap tokensByField = new LinkedHashMap(20);
        Iterator it = document.getDocument().getFields().iterator();
        while (it.hasNext()) {
            Field field = (Field)it.next();
            FieldSetting fieldSetting = (FieldSetting)fieldSettingsByFieldName.get(field.name());
            if (field.isIndexed()) {
                LinkedList<Token> tokens = new LinkedList<Token>();
                tokensByField.put(field, tokens);
                if (field.isTokenized()) {
                    boolean termCounter = false;
                    TokenStream tokenStream = field.tokenStreamValue() != null ? field.tokenStreamValue() : analyzer.tokenStream(field.name(), (Reader)new StringReader(field.stringValue()));
                    tokenStream.reset();
                    Token reusableToken = new Token();
                    Token nextToken = tokenStream.next(reusableToken);
                    while (nextToken != null) {
                        tokens.add((Token)nextToken.clone());
                        ++fieldSetting.fieldLength;
                        if (fieldSetting.fieldLength <= this.maxFieldLength) {
                            nextToken = tokenStream.next(reusableToken);
                            continue;
                        }
                        break;
                    }
                } else {
                    String fieldVal = field.stringValue();
                    Token token = new Token(0, fieldVal.length(), "untokenized");
                    token.setTermBuffer(fieldVal);
                    tokens.add(token);
                    ++fieldSetting.fieldLength;
                }
            }
            if (field.isStored()) continue;
            it.remove();
        }
        HashMap termDocumentInformationFactoryByTermTextAndFieldSetting = new HashMap();
        this.termDocumentInformationFactoryByDocument.put(document, termDocumentInformationFactoryByTermTextAndFieldSetting);
        for (Map.Entry eField_Tokens : tokensByField.entrySet()) {
            FieldSetting fieldSetting = (FieldSetting)fieldSettingsByFieldName.get(((Field)eField_Tokens.getKey()).name());
            HashMap<String, TermDocumentInformationFactory> termDocumentInformationFactoryByTermText = (HashMap<String, TermDocumentInformationFactory>)termDocumentInformationFactoryByTermTextAndFieldSetting.get(fieldSettingsByFieldName.get(((Field)eField_Tokens.getKey()).name()));
            if (termDocumentInformationFactoryByTermText == null) {
                termDocumentInformationFactoryByTermText = new HashMap<String, TermDocumentInformationFactory>();
                termDocumentInformationFactoryByTermTextAndFieldSetting.put(fieldSettingsByFieldName.get(((Field)eField_Tokens.getKey()).name()), termDocumentInformationFactoryByTermText);
            }
            int lastOffset = 0;
            if (fieldSetting.position > 0) {
                fieldSetting.position += analyzer.getPositionIncrementGap(fieldSetting.fieldName);
            }
            for (Token token : (LinkedList)eField_Tokens.getValue()) {
                TermDocumentInformationFactory termDocumentInformationFactory = (TermDocumentInformationFactory)termDocumentInformationFactoryByTermText.get(token.term());
                if (termDocumentInformationFactory == null) {
                    termDocumentInformationFactory = new TermDocumentInformationFactory();
                    termDocumentInformationFactoryByTermText.put(token.term(), termDocumentInformationFactory);
                }
                fieldSetting.position += token.getPositionIncrement() - 1;
                termDocumentInformationFactory.termPositions.add(fieldSetting.position++);
                if (token.getPayload() != null && token.getPayload().length() > 0) {
                    termDocumentInformationFactory.payloads.add(token.getPayload().toByteArray());
                    fieldSetting.storePayloads = true;
                } else {
                    termDocumentInformationFactory.payloads.add(null);
                }
                if (!((Field)eField_Tokens.getKey()).isStoreOffsetWithTermVector()) continue;
                termDocumentInformationFactory.termOffsets.add(new TermVectorOffsetInfo(fieldSetting.offset + token.startOffset(), fieldSetting.offset + token.endOffset()));
                lastOffset = fieldSetting.offset + token.endOffset();
            }
            if (!((Field)eField_Tokens.getKey()).isStoreOffsetWithTermVector()) continue;
            fieldSetting.offset = lastOffset + 1;
        }
        this.unflushedDocuments.add(document);
        if (this.unflushedDocuments.size() >= this.getMergeFactor()) {
            this.commit();
        }
    }

    public void deleteDocuments(Term term) throws IOException {
        this.unflushedDeletions.add(term);
    }

    public void deleteDocuments(Term[] terms) throws IOException {
        for (Term term : terms) {
            this.deleteDocuments(term);
        }
    }

    public void updateDocument(Term term, Document doc) throws IOException {
        this.updateDocument(term, doc, this.getAnalyzer());
    }

    public void updateDocument(Term term, Document doc, Analyzer analyzer) throws IOException {
        this.deleteDocuments(term);
        this.addDocument(doc, analyzer);
    }

    public int getMaxFieldLength() {
        return this.maxFieldLength;
    }

    public void setMaxFieldLength(int maxFieldLength) {
        this.maxFieldLength = maxFieldLength;
    }

    public Similarity getSimilarity() {
        return this.similarity;
    }

    public void setSimilarity(Similarity similarity) {
        this.similarity = similarity;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    static class FieldSetting
    extends org.apache.lucene.store.instantiated.FieldSetting {
        float boost = 1.0f;
        int position = 0;
        int offset;
        int fieldLength = 0;
        boolean omitNorms = false;
        boolean isBinary = false;

        private FieldSetting() {
        }

        private FieldSetting(String fieldName) {
            super(fieldName);
        }
    }

    private class TermDocumentInformationFactory {
        private LinkedList<byte[]> payloads = new LinkedList();
        private LinkedList<Integer> termPositions = new LinkedList();
        private LinkedList<TermVectorOffsetInfo> termOffsets = new LinkedList();

        private TermDocumentInformationFactory() {
        }
    }
}

