/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping.term;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocTermOrds;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.grouping.AbstractGroupFacetCollector;
import org.apache.lucene.search.grouping.term.GroupedFacetHit;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.SentinelIntSet;
import org.apache.lucene.util.UnicodeUtil;

public abstract class TermGroupFacetCollector
extends AbstractGroupFacetCollector {
    final List<GroupedFacetHit> groupedFacetHits;
    final SentinelIntSet segmentGroupedFacetHits;
    final BytesRef spare = new BytesRef();
    FieldCache.DocTermsIndex groupFieldTermsIndex;

    public static TermGroupFacetCollector createTermGroupFacetCollector(String groupField, String facetField, boolean facetFieldMultivalued, BytesRef facetPrefix, int initialSize) {
        if (facetFieldMultivalued) {
            return new MV(groupField, facetField, facetPrefix, initialSize);
        }
        return new SV(groupField, facetField, facetPrefix, initialSize);
    }

    TermGroupFacetCollector(String groupField, String facetField, BytesRef facetPrefix, int initialSize) {
        super(groupField, facetField, facetPrefix);
        this.groupedFacetHits = new ArrayList<GroupedFacetHit>(initialSize);
        this.segmentGroupedFacetHits = new SentinelIntSet(initialSize, -1);
    }

    static class MV
    extends TermGroupFacetCollector {
        private DocTermOrds facetFieldDocTermOrds;
        private TermsEnum facetOrdTermsEnum;
        private DocTermOrds.TermOrdsIterator reuse;

        MV(String groupField, String facetField, BytesRef facetPrefix, int initialSize) {
            super(groupField, facetField, facetPrefix, initialSize);
        }

        public void collect(int doc) throws IOException {
            int chunk;
            int groupOrd = this.groupFieldTermsIndex.getOrd(doc);
            if (this.facetFieldDocTermOrds.isEmpty()) {
                int segmentGroupedFacetsIndex = groupOrd * (this.facetFieldDocTermOrds.numTerms() + 1);
                if (this.facetPrefix != null || this.segmentGroupedFacetHits.exists(segmentGroupedFacetsIndex)) {
                    return;
                }
                ++this.segmentTotalCount;
                int n = this.facetFieldDocTermOrds.numTerms();
                this.segmentFacetCounts[n] = this.segmentFacetCounts[n] + 1;
                this.segmentGroupedFacetHits.put(segmentGroupedFacetsIndex);
                this.groupedFacetHits.add(new GroupedFacetHit(groupOrd == 0 ? null : this.groupFieldTermsIndex.lookup(groupOrd, new BytesRef()), null));
                return;
            }
            if (this.facetOrdTermsEnum != null) {
                this.reuse = this.facetFieldDocTermOrds.lookup(doc, this.reuse);
            }
            boolean first = true;
            int[] buffer = new int[5];
            do {
                int n = chunk = this.reuse != null ? this.reuse.read(buffer) : 0;
                if (first && chunk == 0) {
                    chunk = 1;
                    buffer[0] = this.facetFieldDocTermOrds.numTerms();
                }
                first = false;
                for (int pos = 0; pos < chunk; ++pos) {
                    int segmentGroupedFacetsIndex;
                    int facetOrd = buffer[pos];
                    if (facetOrd < this.startFacetOrd || facetOrd >= this.endFacetOrd || this.segmentGroupedFacetHits.exists(segmentGroupedFacetsIndex = groupOrd * (this.facetFieldDocTermOrds.numTerms() + 1) + facetOrd)) continue;
                    ++this.segmentTotalCount;
                    int n2 = facetOrd;
                    this.segmentFacetCounts[n2] = this.segmentFacetCounts[n2] + 1;
                    this.segmentGroupedFacetHits.put(segmentGroupedFacetsIndex);
                    this.groupedFacetHits.add(new GroupedFacetHit(groupOrd == 0 ? null : this.groupFieldTermsIndex.lookup(groupOrd, new BytesRef()), facetOrd == this.facetFieldDocTermOrds.numTerms() ? null : BytesRef.deepCopyOf((BytesRef)this.facetFieldDocTermOrds.lookupTerm(this.facetOrdTermsEnum, facetOrd))));
                }
            } while (chunk >= buffer.length);
        }

        public void setNextReader(AtomicReaderContext context) throws IOException {
            if (this.segmentFacetCounts != null) {
                this.segmentResults.add(this.createSegmentResult());
            }
            this.reuse = null;
            this.groupFieldTermsIndex = FieldCache.DEFAULT.getTermsIndex(context.reader(), this.groupField);
            this.facetFieldDocTermOrds = FieldCache.DEFAULT.getDocTermOrds(context.reader(), this.facetField);
            this.facetOrdTermsEnum = this.facetFieldDocTermOrds.getOrdTermsEnum(context.reader());
            this.segmentFacetCounts = new int[this.facetFieldDocTermOrds.numTerms() + 1];
            this.segmentTotalCount = 0;
            this.segmentGroupedFacetHits.clear();
            for (GroupedFacetHit groupedFacetHit : this.groupedFacetHits) {
                int facetOrd;
                int groupOrd = this.groupFieldTermsIndex.binarySearchLookup(groupedFacetHit.groupValue, this.spare);
                if (groupOrd < 0) continue;
                if (groupedFacetHit.facetValue != null) {
                    if (this.facetOrdTermsEnum == null || !this.facetOrdTermsEnum.seekExact(groupedFacetHit.facetValue, true)) continue;
                    facetOrd = (int)this.facetOrdTermsEnum.ord();
                } else {
                    facetOrd = this.facetFieldDocTermOrds.numTerms();
                }
                int segmentGroupedFacetsIndex = groupOrd * (this.facetFieldDocTermOrds.numTerms() + 1) + facetOrd;
                this.segmentGroupedFacetHits.put(segmentGroupedFacetsIndex);
            }
            if (this.facetPrefix != null) {
                TermsEnum.SeekStatus seekStatus = this.facetOrdTermsEnum != null ? this.facetOrdTermsEnum.seekCeil(this.facetPrefix, true) : TermsEnum.SeekStatus.END;
                if (seekStatus == TermsEnum.SeekStatus.END) {
                    this.startFacetOrd = 0;
                    this.endFacetOrd = 0;
                    return;
                }
                this.startFacetOrd = (int)this.facetOrdTermsEnum.ord();
                BytesRef facetEndPrefix = BytesRef.deepCopyOf((BytesRef)this.facetPrefix);
                facetEndPrefix.append(UnicodeUtil.BIG_TERM);
                seekStatus = this.facetOrdTermsEnum.seekCeil(facetEndPrefix, true);
                this.endFacetOrd = seekStatus != TermsEnum.SeekStatus.END ? (int)this.facetOrdTermsEnum.ord() : this.facetFieldDocTermOrds.numTerms();
            } else {
                this.startFacetOrd = 0;
                this.endFacetOrd = this.facetFieldDocTermOrds.numTerms() + 1;
            }
        }

        @Override
        protected SegmentResult createSegmentResult() throws IOException {
            return new SegmentResult(this.segmentFacetCounts, this.segmentTotalCount, this.facetFieldDocTermOrds.numTerms(), this.facetOrdTermsEnum, this.startFacetOrd, this.endFacetOrd);
        }

        private static class SegmentResult
        extends AbstractGroupFacetCollector.SegmentResult {
            final TermsEnum tenum;

            SegmentResult(int[] counts, int total, int missingCountIndex, TermsEnum tenum, int startFacetOrd, int endFacetOrd) throws IOException {
                super(counts, total - counts[missingCountIndex], counts[missingCountIndex], endFacetOrd == missingCountIndex + 1 ? missingCountIndex : endFacetOrd);
                this.tenum = tenum;
                this.mergePos = startFacetOrd;
                if (tenum != null) {
                    tenum.seekExact((long)this.mergePos);
                    this.mergeTerm = tenum.term();
                }
            }

            @Override
            protected void nextTerm() throws IOException {
                this.mergeTerm = this.tenum.next();
            }
        }
    }

    static class SV
    extends TermGroupFacetCollector {
        private FieldCache.DocTermsIndex facetFieldTermsIndex;

        SV(String groupField, String facetField, BytesRef facetPrefix, int initialSize) {
            super(groupField, facetField, facetPrefix, initialSize);
        }

        public void collect(int doc) throws IOException {
            int facetOrd = this.facetFieldTermsIndex.getOrd(doc);
            if (facetOrd < this.startFacetOrd || facetOrd >= this.endFacetOrd) {
                return;
            }
            int groupOrd = this.groupFieldTermsIndex.getOrd(doc);
            int segmentGroupedFacetsIndex = groupOrd * this.facetFieldTermsIndex.numOrd() + facetOrd;
            if (this.segmentGroupedFacetHits.exists(segmentGroupedFacetsIndex)) {
                return;
            }
            ++this.segmentTotalCount;
            int n = facetOrd;
            this.segmentFacetCounts[n] = this.segmentFacetCounts[n] + 1;
            this.segmentGroupedFacetHits.put(segmentGroupedFacetsIndex);
            this.groupedFacetHits.add(new GroupedFacetHit(groupOrd == 0 ? null : this.groupFieldTermsIndex.lookup(groupOrd, new BytesRef()), facetOrd == 0 ? null : this.facetFieldTermsIndex.lookup(facetOrd, new BytesRef())));
        }

        public void setNextReader(AtomicReaderContext context) throws IOException {
            if (this.segmentFacetCounts != null) {
                this.segmentResults.add(this.createSegmentResult());
            }
            this.groupFieldTermsIndex = FieldCache.DEFAULT.getTermsIndex(context.reader(), this.groupField);
            this.facetFieldTermsIndex = FieldCache.DEFAULT.getTermsIndex(context.reader(), this.facetField);
            this.segmentFacetCounts = new int[this.facetFieldTermsIndex.numOrd()];
            this.segmentTotalCount = 0;
            this.segmentGroupedFacetHits.clear();
            for (GroupedFacetHit groupedFacetHit : this.groupedFacetHits) {
                int groupOrd;
                int facetOrd = this.facetFieldTermsIndex.binarySearchLookup(groupedFacetHit.facetValue, this.spare);
                if (facetOrd < 0 || (groupOrd = this.groupFieldTermsIndex.binarySearchLookup(groupedFacetHit.groupValue, this.spare)) < 0) continue;
                int segmentGroupedFacetsIndex = groupOrd * this.facetFieldTermsIndex.numOrd() + facetOrd;
                this.segmentGroupedFacetHits.put(segmentGroupedFacetsIndex);
            }
            if (this.facetPrefix != null) {
                this.startFacetOrd = this.facetFieldTermsIndex.binarySearchLookup(this.facetPrefix, this.spare);
                if (this.startFacetOrd < 0) {
                    this.startFacetOrd = -this.startFacetOrd - 1;
                }
                BytesRef facetEndPrefix = BytesRef.deepCopyOf((BytesRef)this.facetPrefix);
                facetEndPrefix.append(UnicodeUtil.BIG_TERM);
                this.endFacetOrd = this.facetFieldTermsIndex.binarySearchLookup(facetEndPrefix, this.spare);
                this.endFacetOrd = -this.endFacetOrd - 1;
            } else {
                this.startFacetOrd = 0;
                this.endFacetOrd = this.facetFieldTermsIndex.numOrd();
            }
        }

        @Override
        protected SegmentResult createSegmentResult() throws IOException {
            return new SegmentResult(this.segmentFacetCounts, this.segmentTotalCount, this.facetFieldTermsIndex.getTermsEnum(), this.startFacetOrd, this.endFacetOrd);
        }

        private static class SegmentResult
        extends AbstractGroupFacetCollector.SegmentResult {
            final TermsEnum tenum;

            SegmentResult(int[] counts, int total, TermsEnum tenum, int startFacetOrd, int endFacetOrd) throws IOException {
                super(counts, total - counts[0], counts[0], endFacetOrd);
                this.tenum = tenum;
                int n = this.mergePos = startFacetOrd == 0 ? 1 : startFacetOrd;
                if (this.mergePos < this.maxTermPos) {
                    tenum.seekExact((long)this.mergePos);
                    this.mergeTerm = tenum.term();
                }
            }

            @Override
            protected void nextTerm() throws IOException {
                this.mergeTerm = this.tenum.next();
            }
        }
    }
}

