/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping.dv;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.grouping.AbstractAllGroupHeadsCollector;
import org.apache.lucene.util.BytesRef;

public abstract class DVAllGroupHeadsCollector<GH extends AbstractAllGroupHeadsCollector.GroupHead<?>>
extends AbstractAllGroupHeadsCollector<GH> {
    final String groupField;
    final boolean diskResident;
    final DocValues.Type valueType;
    final BytesRef scratchBytesRef = new BytesRef();
    AtomicReaderContext readerContext;
    Scorer scorer;

    DVAllGroupHeadsCollector(String groupField, DocValues.Type valueType, int numberOfSorts, boolean diskResident) {
        super(numberOfSorts);
        this.groupField = groupField;
        this.valueType = valueType;
        this.diskResident = diskResident;
    }

    public static <T extends AbstractAllGroupHeadsCollector.GroupHead<?>> DVAllGroupHeadsCollector<T> create(String groupField, Sort sortWithinGroup, DocValues.Type type, boolean diskResident) throws IOException {
        switch (type) {
            case VAR_INTS: 
            case FIXED_INTS_8: 
            case FIXED_INTS_16: 
            case FIXED_INTS_32: 
            case FIXED_INTS_64: {
                return new GeneralAllGroupHeadsCollector.Lng(groupField, type, sortWithinGroup, diskResident);
            }
            case FLOAT_32: 
            case FLOAT_64: {
                return new GeneralAllGroupHeadsCollector.Dbl(groupField, type, sortWithinGroup, diskResident);
            }
            case BYTES_FIXED_STRAIGHT: 
            case BYTES_FIXED_DEREF: 
            case BYTES_VAR_STRAIGHT: 
            case BYTES_VAR_DEREF: {
                return new GeneralAllGroupHeadsCollector.BR(groupField, type, sortWithinGroup, diskResident);
            }
            case BYTES_VAR_SORTED: 
            case BYTES_FIXED_SORTED: {
                return new GeneralAllGroupHeadsCollector.SortedBR(groupField, type, sortWithinGroup, diskResident);
            }
        }
        throw new IllegalArgumentException(String.format("ValueType %s not supported", type));
    }

    public void setNextReader(AtomicReaderContext readerContext) throws IOException {
        this.readerContext = readerContext;
        DocValues dv = readerContext.reader().docValues(this.groupField);
        DocValues.Source dvSource = dv != null ? (this.diskResident ? dv.getDirectSource() : dv.getSource()) : this.getDefaultSource(readerContext);
        this.setDocValuesSources(dvSource);
    }

    protected abstract void setDocValuesSources(DocValues.Source var1);

    protected DocValues.Source getDefaultSource(AtomicReaderContext readerContext) {
        return DocValues.getDefaultSource((DocValues.Type)this.valueType);
    }

    static abstract class GeneralAllGroupHeadsCollector
    extends DVAllGroupHeadsCollector<GroupHead> {
        private final Sort sortWithinGroup;
        private final Map<Comparable<?>, GroupHead> groups;

        GeneralAllGroupHeadsCollector(String groupField, DocValues.Type valueType, Sort sortWithinGroup, boolean diskResident) throws IOException {
            super(groupField, valueType, sortWithinGroup.getSort().length, diskResident);
            this.sortWithinGroup = sortWithinGroup;
            this.groups = new HashMap();
            SortField[] sortFields = sortWithinGroup.getSort();
            for (int i = 0; i < sortFields.length; ++i) {
                this.reversed[i] = sortFields[i].getReverse() ? -1 : 1;
            }
        }

        @Override
        protected void retrieveGroupHeadAndAddIfNotExist(int doc) throws IOException {
            Comparable<?> groupValue = this.getGroupValue(doc);
            GroupHead groupHead = this.groups.get(groupValue);
            if (groupHead == null) {
                groupHead = new GroupHead(groupValue, this.sortWithinGroup, doc, this.readerContext, this.scorer);
                this.groups.put(groupValue == null ? null : this.duplicate(groupValue), groupHead);
                this.temporalResult.stop = true;
            } else {
                this.temporalResult.stop = false;
            }
            this.temporalResult.groupHead = groupHead;
        }

        protected abstract Comparable<?> getGroupValue(int var1);

        protected abstract Comparable<?> duplicate(Comparable<?> var1);

        @Override
        protected Collection<GroupHead> getCollectedGroupHeads() {
            return this.groups.values();
        }

        @Override
        public void setNextReader(AtomicReaderContext context) throws IOException {
            super.setNextReader(context);
            for (GroupHead groupHead : this.groups.values()) {
                for (int i = 0; i < groupHead.comparators.length; ++i) {
                    groupHead.comparators[i] = groupHead.comparators[i].setNextReader(context);
                    groupHead.readerContext = context;
                }
            }
        }

        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
            for (GroupHead groupHead : this.groups.values()) {
                groupHead.scorer = scorer;
                for (FieldComparator<?> comparator : groupHead.comparators) {
                    comparator.setScorer(scorer);
                }
            }
        }

        static class Dbl
        extends GeneralAllGroupHeadsCollector {
            private DocValues.Source source;

            Dbl(String groupField, DocValues.Type valueType, Sort sortWithinGroup, boolean diskResident) throws IOException {
                super(groupField, valueType, sortWithinGroup, diskResident);
            }

            @Override
            protected Comparable<?> getGroupValue(int doc) {
                return this.source.getFloat(doc);
            }

            @Override
            protected Comparable<?> duplicate(Comparable<?> value) {
                return value;
            }

            @Override
            protected void setDocValuesSources(DocValues.Source source) {
                this.source = source;
            }
        }

        static class Lng
        extends GeneralAllGroupHeadsCollector {
            private DocValues.Source source;

            Lng(String groupField, DocValues.Type valueType, Sort sortWithinGroup, boolean diskResident) throws IOException {
                super(groupField, valueType, sortWithinGroup, diskResident);
            }

            @Override
            protected Comparable<?> getGroupValue(int doc) {
                return this.source.getInt(doc);
            }

            @Override
            protected Comparable<?> duplicate(Comparable<?> value) {
                return value;
            }

            @Override
            protected void setDocValuesSources(DocValues.Source source) {
                this.source = source;
            }
        }

        static class BR
        extends GeneralAllGroupHeadsCollector {
            private DocValues.Source source;

            BR(String groupField, DocValues.Type valueType, Sort sortWithinGroup, boolean diskResident) throws IOException {
                super(groupField, valueType, sortWithinGroup, diskResident);
            }

            @Override
            protected Comparable<?> getGroupValue(int doc) {
                return this.source.getBytes(doc, this.scratchBytesRef);
            }

            @Override
            protected Comparable<?> duplicate(Comparable<?> value) {
                return BytesRef.deepCopyOf((BytesRef)((BytesRef)value));
            }

            @Override
            protected void setDocValuesSources(DocValues.Source source) {
                this.source = source;
            }
        }

        static class SortedBR
        extends GeneralAllGroupHeadsCollector {
            private DocValues.SortedSource source;

            SortedBR(String groupField, DocValues.Type valueType, Sort sortWithinGroup, boolean diskResident) throws IOException {
                super(groupField, valueType, sortWithinGroup, diskResident);
            }

            @Override
            protected Comparable<?> getGroupValue(int doc) {
                return this.source.getBytes(doc, this.scratchBytesRef);
            }

            @Override
            protected Comparable<?> duplicate(Comparable<?> value) {
                return BytesRef.deepCopyOf((BytesRef)((BytesRef)value));
            }

            @Override
            protected void setDocValuesSources(DocValues.Source source) {
                this.source = source.asSortedSource();
            }

            @Override
            protected DocValues.Source getDefaultSource(AtomicReaderContext readerContext) {
                return DocValues.getDefaultSortedSource((DocValues.Type)this.valueType, (int)readerContext.reader().maxDoc());
            }
        }
    }

    static class GroupHead
    extends AbstractAllGroupHeadsCollector.GroupHead<Comparable<?>> {
        final FieldComparator<?>[] comparators;
        AtomicReaderContext readerContext;
        Scorer scorer;

        GroupHead(Comparable<?> groupValue, Sort sort, int doc, AtomicReaderContext readerContext, Scorer scorer) throws IOException {
            super(groupValue, doc + readerContext.docBase);
            SortField[] sortFields = sort.getSort();
            this.comparators = new FieldComparator[sortFields.length];
            for (int i = 0; i < sortFields.length; ++i) {
                this.comparators[i] = sortFields[i].getComparator(1, i).setNextReader(readerContext);
                this.comparators[i].setScorer(scorer);
                this.comparators[i].copy(0, doc);
                this.comparators[i].setBottom(0);
            }
            this.readerContext = readerContext;
            this.scorer = scorer;
        }

        @Override
        public int compare(int compIDX, int doc) throws IOException {
            return this.comparators[compIDX].compareBottom(doc);
        }

        @Override
        public void updateDocHead(int doc) throws IOException {
            for (FieldComparator<?> comparator : this.comparators) {
                comparator.copy(0, doc);
                comparator.setBottom(0);
            }
            this.doc = doc + this.readerContext.docBase;
        }
    }
}

