/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping.dv;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.TreeSet;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.search.grouping.AbstractAllGroupsCollector;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.SentinelIntSet;

public abstract class DVAllGroupsCollector<GROUP_VALUE_TYPE>
extends AbstractAllGroupsCollector<GROUP_VALUE_TYPE> {
    private static final int DEFAULT_INITIAL_SIZE = 128;
    final String groupField;
    final DocValues.Type valueType;
    final boolean diskResident;
    final Collection<GROUP_VALUE_TYPE> groups;

    public static <T> DVAllGroupsCollector<T> create(String groupField, DocValues.Type type, boolean diskResident, int initialSize) {
        switch (type) {
            case VAR_INTS: 
            case FIXED_INTS_8: 
            case FIXED_INTS_16: 
            case FIXED_INTS_32: 
            case FIXED_INTS_64: {
                return new Lng(groupField, type, diskResident);
            }
            case FLOAT_32: 
            case FLOAT_64: {
                return new Dbl(groupField, type, diskResident);
            }
            case BYTES_FIXED_STRAIGHT: 
            case BYTES_FIXED_DEREF: 
            case BYTES_VAR_STRAIGHT: 
            case BYTES_VAR_DEREF: {
                return new BR(groupField, type, diskResident);
            }
            case BYTES_VAR_SORTED: 
            case BYTES_FIXED_SORTED: {
                return new SortedBR(groupField, type, diskResident, initialSize);
            }
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "ValueType %s not supported", type));
    }

    public static <T> DVAllGroupsCollector<T> create(String groupField, DocValues.Type type, boolean diskResident) {
        return DVAllGroupsCollector.create(groupField, type, diskResident, 128);
    }

    DVAllGroupsCollector(String groupField, DocValues.Type valueType, boolean diskResident, Collection<GROUP_VALUE_TYPE> groups) {
        this.groupField = groupField;
        this.valueType = valueType;
        this.diskResident = diskResident;
        this.groups = groups;
    }

    public void setNextReader(AtomicReaderContext readerContext) throws IOException {
        DocValues dv = readerContext.reader().docValues(this.groupField);
        DocValues.Source dvSource = dv != null ? (this.diskResident ? dv.getDirectSource() : dv.getSource()) : this.getDefaultSource(readerContext);
        this.setDocValuesSources(dvSource, readerContext);
    }

    protected abstract void setDocValuesSources(DocValues.Source var1, AtomicReaderContext var2);

    protected DocValues.Source getDefaultSource(AtomicReaderContext readerContext) {
        return DocValues.getDefaultSource((DocValues.Type)this.valueType);
    }

    static class SortedBR
    extends DVAllGroupsCollector<BytesRef> {
        private final SentinelIntSet ordSet;
        private final BytesRef spare = new BytesRef();
        private DocValues.SortedSource source;

        SortedBR(String groupField, DocValues.Type valueType, boolean diskResident, int initialSize) {
            super(groupField, valueType, diskResident, new ArrayList(initialSize));
            this.ordSet = new SentinelIntSet(initialSize, -1);
        }

        public void collect(int doc) throws IOException {
            int ord = this.source.ord(doc);
            if (!this.ordSet.exists(ord)) {
                this.ordSet.put(ord);
                BytesRef value = this.source.getBytes(doc, new BytesRef());
                this.groups.add(value);
            }
        }

        @Override
        public Collection<BytesRef> getGroups() {
            return this.groups;
        }

        @Override
        protected void setDocValuesSources(DocValues.Source source, AtomicReaderContext readerContext) {
            this.source = source.asSortedSource();
            this.ordSet.clear();
            for (BytesRef countedGroup : this.groups) {
                int ord = this.source.getOrdByValue(countedGroup, this.spare);
                if (ord < 0) continue;
                this.ordSet.put(ord);
            }
        }

        @Override
        protected DocValues.Source getDefaultSource(AtomicReaderContext readerContext) {
            return DocValues.getDefaultSortedSource((DocValues.Type)this.valueType, (int)readerContext.reader().maxDoc());
        }
    }

    static class BR
    extends DVAllGroupsCollector<BytesRef> {
        private final BytesRef spare = new BytesRef();
        private DocValues.Source source;

        BR(String groupField, DocValues.Type valueType, boolean diskResident) {
            super(groupField, valueType, diskResident, new TreeSet());
        }

        public void collect(int doc) throws IOException {
            BytesRef value = this.source.getBytes(doc, this.spare);
            if (!this.groups.contains(value)) {
                this.groups.add(BytesRef.deepCopyOf((BytesRef)value));
            }
        }

        @Override
        public Collection<BytesRef> getGroups() {
            return this.groups;
        }

        @Override
        protected void setDocValuesSources(DocValues.Source source, AtomicReaderContext readerContext) {
            this.source = source;
        }
    }

    static class Dbl
    extends DVAllGroupsCollector<Double> {
        private DocValues.Source source;

        Dbl(String groupField, DocValues.Type valueType, boolean diskResident) {
            super(groupField, valueType, diskResident, new TreeSet());
        }

        public void collect(int doc) throws IOException {
            double value = this.source.getFloat(doc);
            if (!this.groups.contains(value)) {
                this.groups.add(value);
            }
        }

        @Override
        public Collection<Double> getGroups() {
            return this.groups;
        }

        @Override
        protected void setDocValuesSources(DocValues.Source source, AtomicReaderContext readerContext) {
            this.source = source;
        }
    }

    static class Lng
    extends DVAllGroupsCollector<Long> {
        private DocValues.Source source;

        Lng(String groupField, DocValues.Type valueType, boolean diskResident) {
            super(groupField, valueType, diskResident, new TreeSet());
        }

        public void collect(int doc) throws IOException {
            long value = this.source.getInt(doc);
            if (!this.groups.contains(value)) {
                this.groups.add(value);
            }
        }

        @Override
        public Collection<Long> getGroups() {
            return this.groups;
        }

        @Override
        protected void setDocValuesSources(DocValues.Source source, AtomicReaderContext readerContext) {
            this.source = source;
        }
    }
}

