/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.LabelAndValue;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.util.BitDocIdSet;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.FixedBitSet;

public class RandomSamplingFacetsCollector
extends FacetsCollector {
    private static final int NOT_CALCULATED = -1;
    private final int sampleSize;
    private final XORShift64Random random;
    private double samplingRate;
    private List<FacetsCollector.MatchingDocs> sampledDocs;
    private int totalHits = -1;
    private int leftoverBin = -1;
    private int leftoverIndex = -1;

    public RandomSamplingFacetsCollector(int sampleSize) {
        this(sampleSize, 0L);
    }

    public RandomSamplingFacetsCollector(int sampleSize, long seed) {
        super(false);
        this.sampleSize = sampleSize;
        this.random = new XORShift64Random(seed);
        this.sampledDocs = null;
    }

    @Override
    public List<FacetsCollector.MatchingDocs> getMatchingDocs() {
        List<FacetsCollector.MatchingDocs> matchingDocs = super.getMatchingDocs();
        if (this.totalHits == -1) {
            this.totalHits = 0;
            for (FacetsCollector.MatchingDocs md : matchingDocs) {
                this.totalHits += md.totalHits;
            }
        }
        if (this.totalHits <= this.sampleSize) {
            return matchingDocs;
        }
        if (this.sampledDocs == null) {
            this.samplingRate = 1.0 * (double)this.sampleSize / (double)this.totalHits;
            this.sampledDocs = this.createSampledDocs(matchingDocs);
        }
        return this.sampledDocs;
    }

    public List<FacetsCollector.MatchingDocs> getOriginalMatchingDocs() {
        return super.getMatchingDocs();
    }

    private List<FacetsCollector.MatchingDocs> createSampledDocs(List<FacetsCollector.MatchingDocs> matchingDocsList) {
        ArrayList<FacetsCollector.MatchingDocs> sampledDocsList = new ArrayList<FacetsCollector.MatchingDocs>(matchingDocsList.size());
        for (FacetsCollector.MatchingDocs docs : matchingDocsList) {
            sampledDocsList.add(this.createSample(docs));
        }
        return sampledDocsList;
    }

    private FacetsCollector.MatchingDocs createSample(FacetsCollector.MatchingDocs docs) {
        int maxdoc = docs.context.reader().maxDoc();
        FixedBitSet sampleDocs = new FixedBitSet(maxdoc);
        int binSize = (int)(1.0 / this.samplingRate);
        try {
            int randomIndex;
            int limit;
            int counter = 0;
            if (this.leftoverBin != -1) {
                limit = this.leftoverBin;
                randomIndex = this.leftoverIndex;
            } else {
                limit = binSize;
                randomIndex = this.random.nextInt(binSize);
            }
            DocIdSetIterator it = docs.bits.iterator();
            int doc = it.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                if (counter == randomIndex) {
                    sampleDocs.set(doc);
                }
                if (++counter >= limit) {
                    counter = 0;
                    limit = binSize;
                    randomIndex = this.random.nextInt(binSize);
                }
                doc = it.nextDoc();
            }
            if (counter == 0) {
                this.leftoverIndex = -1;
                this.leftoverBin = -1;
            } else {
                this.leftoverBin = limit - counter;
                if (randomIndex > counter) {
                    this.leftoverIndex = randomIndex - counter;
                } else if (randomIndex < counter) {
                    this.leftoverIndex = -1;
                }
            }
            return new FacetsCollector.MatchingDocs(docs.context, (DocIdSet)new BitDocIdSet((BitSet)sampleDocs), docs.totalHits, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public FacetResult amortizeFacetCounts(FacetResult res, FacetsConfig config, IndexSearcher searcher) throws IOException {
        if (res == null || this.totalHits <= this.sampleSize) {
            return res;
        }
        LabelAndValue[] fixedLabelValues = new LabelAndValue[res.labelValues.length];
        IndexReader reader = searcher.getIndexReader();
        FacetsConfig.DimConfig dimConfig = config.getDimConfig(res.dim);
        String[] childPath = new String[res.path.length + 2];
        childPath[0] = res.dim;
        System.arraycopy(res.path, 0, childPath, 1, res.path.length);
        for (int i = 0; i < res.labelValues.length; ++i) {
            childPath[res.path.length + 1] = res.labelValues[i].label;
            String fullPath = FacetsConfig.pathToString(childPath, childPath.length);
            int max = reader.docFreq(new Term(dimConfig.indexFieldName, fullPath));
            int correctedCount = (int)(res.labelValues[i].value.doubleValue() / this.samplingRate);
            correctedCount = Math.min(max, correctedCount);
            fixedLabelValues[i] = new LabelAndValue(res.labelValues[i].label, correctedCount);
        }
        int correctedTotalCount = res.value.intValue();
        if (correctedTotalCount > 0) {
            correctedTotalCount = Math.min(reader.numDocs(), (int)(res.value.doubleValue() / this.samplingRate));
        }
        return new FacetResult(res.dim, res.path, correctedTotalCount, fixedLabelValues, res.childCount);
    }

    public double getSamplingRate() {
        return this.samplingRate;
    }

    public static CollectorManager<RandomSamplingFacetsCollector, RandomSamplingFacetsCollector> createManager(final int sampleSize, final long seed) {
        return new CollectorManager<RandomSamplingFacetsCollector, RandomSamplingFacetsCollector>(){

            public RandomSamplingFacetsCollector newCollector() {
                return new RandomSamplingFacetsCollector(sampleSize, seed);
            }

            public RandomSamplingFacetsCollector reduce(Collection<RandomSamplingFacetsCollector> collectors) {
                if (collectors == null || collectors.size() == 0) {
                    return new RandomSamplingFacetsCollector(sampleSize, seed);
                }
                if (collectors.size() == 1) {
                    return collectors.iterator().next();
                }
                return new ReducedRandomSamplingFacetsCollector(sampleSize, seed, collectors);
            }
        };
    }

    private static class XORShift64Random {
        private long x;

        public XORShift64Random(long seed) {
            this.x = seed == 0L ? -559038737L : seed;
        }

        public long randomLong() {
            this.x ^= this.x << 21;
            this.x ^= this.x >>> 35;
            this.x ^= this.x << 4;
            return this.x;
        }

        public int nextInt(int n) {
            int res = (int)(this.randomLong() % (long)n);
            return res < 0 ? -res : res;
        }
    }

    private static class ReducedRandomSamplingFacetsCollector
    extends RandomSamplingFacetsCollector {
        ReducedRandomSamplingFacetsCollector(int sampleSize, long seed, Collection<RandomSamplingFacetsCollector> facetsCollectors) {
            super(sampleSize, seed);
            facetsCollectors.forEach(facetsCollector -> this.getOriginalMatchingDocs().addAll(facetsCollector.getOriginalMatchingDocs()));
        }
    }
}

