/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.range;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.facet.MultiDoubleValues;
import org.apache.lucene.facet.MultiDoubleValuesSource;
import org.apache.lucene.facet.range.LongRange;
import org.apache.lucene.facet.range.Range;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.NumericUtils;

public final class DoubleRange
extends Range {
    public final double min;
    public final double max;

    public DoubleRange(String label, double minIn, boolean minInclusive, double maxIn, boolean maxInclusive) {
        super(label);
        if (Double.isNaN(minIn)) {
            throw new IllegalArgumentException("min cannot be NaN");
        }
        if (!minInclusive) {
            minIn = Math.nextUp(minIn);
        }
        if (Double.isNaN(maxIn)) {
            throw new IllegalArgumentException("max cannot be NaN");
        }
        if (!maxInclusive) {
            maxIn = Math.nextAfter(maxIn, Double.NEGATIVE_INFINITY);
        }
        if (minIn > maxIn) {
            this.failNoMatch();
        }
        this.min = minIn;
        this.max = maxIn;
    }

    public boolean accept(double value) {
        return value >= this.min && value <= this.max;
    }

    LongRange toLongRange() {
        return new LongRange(this.label, NumericUtils.doubleToSortableLong((double)this.min), true, NumericUtils.doubleToSortableLong((double)this.max), true);
    }

    public String toString() {
        return "DoubleRange(" + this.label + ": " + this.min + " to " + this.max + ")";
    }

    public boolean equals(Object _that) {
        if (!(_that instanceof DoubleRange)) {
            return false;
        }
        DoubleRange that = (DoubleRange)_that;
        return that.label.equals(this.label) && Double.compare(that.min, this.min) == 0 && Double.compare(that.max, this.max) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.label, this.min, this.max);
    }

    public Query getQuery(Query fastMatchQuery, DoubleValuesSource valueSource) {
        return new ValueSourceQuery(this, fastMatchQuery, valueSource);
    }

    public Query getQuery(Query fastMatchQuery, MultiDoubleValuesSource valueSource) {
        DoubleValuesSource singleValues = MultiDoubleValuesSource.unwrapSingleton(valueSource);
        if (singleValues != null) {
            return new ValueSourceQuery(this, fastMatchQuery, singleValues);
        }
        return new MultiValueSourceQuery(this, fastMatchQuery, valueSource);
    }

    private static class MultiValueSourceQuery
    extends Query {
        private final DoubleRange range;
        private final Query fastMatchQuery;
        private final MultiDoubleValuesSource valueSource;

        MultiValueSourceQuery(DoubleRange range, Query fastMatchQuery, MultiDoubleValuesSource valueSource) {
            this.range = range;
            this.fastMatchQuery = fastMatchQuery;
            this.valueSource = valueSource;
        }

        public boolean equals(Object other) {
            return this.sameClassAs(other) && this.equalsTo((MultiValueSourceQuery)((Object)((Object)((Object)this)).getClass().cast(other)));
        }

        private boolean equalsTo(MultiValueSourceQuery other) {
            return this.range.equals(other.range) && Objects.equals(this.fastMatchQuery, other.fastMatchQuery) && this.valueSource.equals(other.valueSource);
        }

        public int hashCode() {
            return this.classHash() + 31 * Objects.hash(this.range, this.fastMatchQuery, this.valueSource);
        }

        public String toString(String field) {
            return "Filter(" + this.range.toString() + ")";
        }

        public void visit(QueryVisitor visitor) {
            visitor.visitLeaf((Query)this);
        }

        public Query rewrite(IndexReader reader) throws IOException {
            Query fastMatchRewritten;
            if (this.fastMatchQuery != null && (fastMatchRewritten = this.fastMatchQuery.rewrite(reader)) != this.fastMatchQuery) {
                return new MultiValueSourceQuery(this.range, fastMatchRewritten, this.valueSource);
            }
            return super.rewrite(reader);
        }

        public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
            final Weight fastMatchWeight = this.fastMatchQuery == null ? null : searcher.createWeight(this.fastMatchQuery, ScoreMode.COMPLETE_NO_SCORES, 1.0f);
            return new ConstantScoreWeight(this, boost){

                public Scorer scorer(LeafReaderContext context) throws IOException {
                    DocIdSetIterator approximation;
                    int maxDoc = context.reader().maxDoc();
                    if (fastMatchWeight == null) {
                        approximation = DocIdSetIterator.all((int)maxDoc);
                    } else {
                        Scorer s = fastMatchWeight.scorer(context);
                        if (s == null) {
                            return null;
                        }
                        approximation = s.iterator();
                    }
                    final MultiDoubleValues values = valueSource.getValues(context);
                    TwoPhaseIterator twoPhase = new TwoPhaseIterator(approximation){

                        public boolean matches() throws IOException {
                            if (!values.advanceExact(this.approximation.docID())) {
                                return false;
                            }
                            int i = 0;
                            while ((long)i < values.getValueCount()) {
                                if (range.accept(values.nextValue())) {
                                    return true;
                                }
                                ++i;
                            }
                            return false;
                        }

                        public float matchCost() {
                            return 100.0f;
                        }
                    };
                    return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, twoPhase);
                }

                public boolean isCacheable(LeafReaderContext ctx) {
                    return valueSource.isCacheable(ctx);
                }
            };
        }
    }

    private static class ValueSourceQuery
    extends Query {
        private final DoubleRange range;
        private final Query fastMatchQuery;
        private final DoubleValuesSource valueSource;

        ValueSourceQuery(DoubleRange range, Query fastMatchQuery, DoubleValuesSource valueSource) {
            this.range = range;
            this.fastMatchQuery = fastMatchQuery;
            this.valueSource = valueSource;
        }

        public boolean equals(Object other) {
            return this.sameClassAs(other) && this.equalsTo((ValueSourceQuery)((Object)((Object)((Object)this)).getClass().cast(other)));
        }

        private boolean equalsTo(ValueSourceQuery other) {
            return this.range.equals(other.range) && Objects.equals(this.fastMatchQuery, other.fastMatchQuery) && this.valueSource.equals((Object)other.valueSource);
        }

        public int hashCode() {
            return this.classHash() + 31 * Objects.hash(this.range, this.fastMatchQuery, this.valueSource);
        }

        public String toString(String field) {
            return "Filter(" + this.range.toString() + ")";
        }

        public void visit(QueryVisitor visitor) {
            visitor.visitLeaf((Query)this);
        }

        public Query rewrite(IndexReader reader) throws IOException {
            Query fastMatchRewritten;
            if (this.fastMatchQuery != null && (fastMatchRewritten = this.fastMatchQuery.rewrite(reader)) != this.fastMatchQuery) {
                return new ValueSourceQuery(this.range, fastMatchRewritten, this.valueSource);
            }
            return super.rewrite(reader);
        }

        public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
            final Weight fastMatchWeight = this.fastMatchQuery == null ? null : searcher.createWeight(this.fastMatchQuery, ScoreMode.COMPLETE_NO_SCORES, 1.0f);
            return new ConstantScoreWeight(this, boost){

                public Scorer scorer(LeafReaderContext context) throws IOException {
                    DocIdSetIterator approximation;
                    int maxDoc = context.reader().maxDoc();
                    if (fastMatchWeight == null) {
                        approximation = DocIdSetIterator.all((int)maxDoc);
                    } else {
                        Scorer s = fastMatchWeight.scorer(context);
                        if (s == null) {
                            return null;
                        }
                        approximation = s.iterator();
                    }
                    final DoubleValues values = valueSource.getValues(context, null);
                    TwoPhaseIterator twoPhase = new TwoPhaseIterator(approximation){

                        public boolean matches() throws IOException {
                            return values.advanceExact(this.approximation.docID()) && range.accept(values.doubleValue());
                        }

                        public float matchCost() {
                            return 100.0f;
                        }
                    };
                    return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, twoPhase);
                }

                public boolean isCacheable(LeafReaderContext ctx) {
                    return valueSource.isCacheable(ctx);
                }
            };
        }
    }
}

