/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.facetset;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.facet.FacetCountsWithFilterQuery;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.LabelAndValue;
import org.apache.lucene.facet.facetset.FacetSetDecoder;
import org.apache.lucene.facet.facetset.FacetSetMatcher;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;

public class MatchingFacetSetsCounts
extends FacetCountsWithFilterQuery {
    private final FacetSetMatcher[] facetSetMatchers;
    private final int[] counts;
    private final String field;
    private final FacetSetDecoder facetSetDecoder;
    private final int totCount;

    public MatchingFacetSetsCounts(String field, FacetsCollector hits, FacetSetDecoder facetSetDecoder, FacetSetMatcher ... facetSetMatchers) throws IOException {
        this(field, hits, facetSetDecoder, (Query)null, facetSetMatchers);
    }

    public MatchingFacetSetsCounts(String field, FacetsCollector hits, FacetSetDecoder facetSetDecoder, Query fastMatchQuery, FacetSetMatcher ... facetSetMatchers) throws IOException {
        super(fastMatchQuery);
        if (facetSetMatchers == null || facetSetMatchers.length == 0) {
            throw new IllegalArgumentException("facetSetMatchers cannot be null or empty");
        }
        if (MatchingFacetSetsCounts.areFacetSetMatcherDimensionsInconsistent(facetSetMatchers)) {
            throw new IllegalArgumentException("All facet set matchers must be the same dimensionality");
        }
        this.field = field;
        this.facetSetDecoder = facetSetDecoder;
        this.facetSetMatchers = facetSetMatchers;
        this.counts = new int[facetSetMatchers.length];
        this.totCount = this.count(field, hits.getMatchingDocs());
    }

    private int count(String field, List<FacetsCollector.MatchingDocs> matchingDocs) throws IOException {
        int totCount = 0;
        for (FacetsCollector.MatchingDocs hits : matchingDocs) {
            BinaryDocValues binaryDocValues;
            DocIdSetIterator it = this.createIterator(hits, new DocIdSetIterator[]{binaryDocValues = DocValues.getBinary((LeafReader)hits.context.reader(), (String)field)});
            if (it == null) continue;
            long[] dimValues = null;
            int expectedNumDims = -1;
            int doc = it.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                boolean shouldCountDoc = false;
                BytesRef bytesRef = binaryDocValues.binaryValue();
                byte[] packedValue = bytesRef.bytes;
                int numDims = IntPoint.decodeDimension((byte[])packedValue, (int)0);
                if (expectedNumDims == -1) {
                    expectedNumDims = numDims;
                    dimValues = new long[numDims];
                } else assert (numDims == expectedNumDims) : "Expected (" + expectedNumDims + ") dimensions, found (" + numDims + ") for doc (" + doc + ")";
                int start = 4;
                while (start < bytesRef.length) {
                    start += this.facetSetDecoder.decode(bytesRef, start, dimValues);
                    for (int j = 0; j < this.facetSetMatchers.length; ++j) {
                        if (!this.facetSetMatchers[j].matches(dimValues)) continue;
                        int n = j;
                        this.counts[n] = this.counts[n] + 1;
                        shouldCountDoc = true;
                    }
                }
                if (shouldCountDoc) {
                    ++totCount;
                }
                doc = it.nextDoc();
            }
        }
        return totCount;
    }

    @Override
    public FacetResult getAllChildren(String dim, String ... path) throws IOException {
        if (!this.field.equals(dim)) {
            throw new IllegalArgumentException("invalid dim \"" + dim + "\"; should be \"" + this.field + "\"");
        }
        if (path != null && path.length != 0) {
            throw new IllegalArgumentException("path.length should be 0");
        }
        LabelAndValue[] labelValues = new LabelAndValue[this.counts.length];
        for (int i = 0; i < this.counts.length; ++i) {
            labelValues[i] = new LabelAndValue(this.facetSetMatchers[i].label, this.counts[i]);
        }
        return new FacetResult(dim, path, this.totCount, labelValues, labelValues.length);
    }

    @Override
    public FacetResult getTopChildren(int topN, String dim, String ... path) throws IOException {
        MatchingFacetSetsCounts.validateTopN(topN);
        return this.getAllChildren(dim, path);
    }

    @Override
    public Number getSpecificValue(String dim, String ... path) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<FacetResult> getAllDims(int topN) throws IOException {
        MatchingFacetSetsCounts.validateTopN(topN);
        return Collections.singletonList(this.getTopChildren(topN, this.field, new String[0]));
    }

    private static boolean areFacetSetMatcherDimensionsInconsistent(FacetSetMatcher[] facetSetMatchers) {
        int dims = facetSetMatchers[0].dims;
        return Arrays.stream(facetSetMatchers).anyMatch(facetSetMatcher -> facetSetMatcher.dims != dims);
    }
}

