/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy;

import com.carrotsearch.hppc.IntIntHashMap;
import com.carrotsearch.hppc.cursors.IntIntCursor;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.LabelAndValue;
import org.apache.lucene.facet.TopOrdAndIntQueue;
import org.apache.lucene.facet.taxonomy.AssociationAggregationFunction;
import org.apache.lucene.facet.taxonomy.FacetLabel;
import org.apache.lucene.facet.taxonomy.TaxonomyFacets;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.util.PriorityQueue;

@Deprecated
public abstract class IntTaxonomyFacets
extends TaxonomyFacets {
    protected final AssociationAggregationFunction aggregationFunction;
    protected final int[] values;
    protected final IntIntHashMap sparseValues;
    private static final String[] emptyPath = new String[0];

    protected IntTaxonomyFacets(String indexFieldName, TaxonomyReader taxoReader, FacetsConfig config, FacetsCollector fc) throws IOException {
        super(indexFieldName, taxoReader, config);
        this.aggregationFunction = AssociationAggregationFunction.SUM;
        if (this.useHashTable(fc, taxoReader)) {
            this.sparseValues = new IntIntHashMap();
            this.values = null;
        } else {
            this.sparseValues = null;
            this.values = new int[taxoReader.getSize()];
        }
    }

    protected IntTaxonomyFacets(String indexFieldName, TaxonomyReader taxoReader, FacetsConfig config, AssociationAggregationFunction aggregationFunction, FacetsCollector fc) throws IOException {
        super(indexFieldName, taxoReader, config);
        this.aggregationFunction = aggregationFunction;
        if (this.useHashTable(fc, taxoReader)) {
            this.sparseValues = new IntIntHashMap();
            this.values = null;
        } else {
            this.sparseValues = null;
            this.values = new int[taxoReader.getSize()];
        }
    }

    protected boolean useHashTable(FacetsCollector fc, TaxonomyReader taxoReader) {
        if (taxoReader.getSize() < 1024) {
            return false;
        }
        if (fc == null) {
            return false;
        }
        int maxDoc = 0;
        int sumTotalHits = 0;
        for (FacetsCollector.MatchingDocs docs : fc.getMatchingDocs()) {
            sumTotalHits += docs.totalHits;
            maxDoc += docs.context.reader().maxDoc();
        }
        return sumTotalHits < maxDoc / 10;
    }

    protected void increment(int ordinal) {
        this.increment(ordinal, 1);
    }

    protected void increment(int ordinal, int amount) {
        if (this.sparseValues != null) {
            this.sparseValues.addTo(ordinal, amount);
        } else {
            int n = ordinal;
            this.values[n] = this.values[n] + amount;
        }
    }

    void setValue(int ordinal, int newValue) {
        if (this.sparseValues != null) {
            this.sparseValues.put(ordinal, newValue);
        } else {
            this.values[ordinal] = newValue;
        }
    }

    protected int getValue(int ordinal) {
        if (this.sparseValues != null) {
            return this.sparseValues.get(ordinal);
        }
        return this.values[ordinal];
    }

    protected void rollup() throws IOException {
        int[] children = null;
        for (Map.Entry<String, FacetsConfig.DimConfig> ent : this.config.getDimConfigs().entrySet()) {
            int dimRootOrd;
            String dim = ent.getKey();
            FacetsConfig.DimConfig ft = ent.getValue();
            if (!ft.hierarchical || ft.multiValued || (dimRootOrd = this.taxoReader.getOrdinal(new FacetLabel(dim))) <= 0) continue;
            if (children == null) {
                children = this.getChildren();
            }
            int currentValue = this.getValue(dimRootOrd);
            int newValue = this.aggregationFunction.aggregate(currentValue, this.rollup(children[dimRootOrd]));
            this.setValue(dimRootOrd, newValue);
        }
    }

    private int rollup(int ord) throws IOException {
        int[] children = this.getChildren();
        int[] siblings = this.getSiblings();
        int aggregatedValue = 0;
        while (ord != -1) {
            int currentValue = this.getValue(ord);
            int newValue = this.aggregationFunction.aggregate(currentValue, this.rollup(children[ord]));
            this.setValue(ord, newValue);
            aggregatedValue = this.aggregationFunction.aggregate(aggregatedValue, this.getValue(ord));
            ord = siblings[ord];
        }
        return aggregatedValue;
    }

    @Override
    public Number getSpecificValue(String dim, String ... path) throws IOException {
        FacetsConfig.DimConfig dimConfig = this.verifyDim(dim);
        if (!(path.length != 0 || dimConfig.hierarchical && !dimConfig.multiValued || dimConfig.requireDimCount && dimConfig.multiValued)) {
            throw new IllegalArgumentException("cannot return dimension-level value alone; use getTopChildren instead");
        }
        int ord = this.taxoReader.getOrdinal(new FacetLabel(dim, path));
        if (ord < 0) {
            return -1;
        }
        return this.getValue(ord);
    }

    @Override
    public FacetResult getTopChildren(int topN, String dim, String ... path) throws IOException {
        IntTaxonomyFacets.validateTopN(topN);
        FacetsConfig.DimConfig dimConfig = this.verifyDim(dim);
        FacetLabel cp = new FacetLabel(dim, path);
        int dimOrd = this.taxoReader.getOrdinal(cp);
        if (dimOrd == -1) {
            return null;
        }
        ChildOrdsResult childOrdsResult = this.getChildOrdsResult(dimConfig, dimOrd, topN);
        if (childOrdsResult.q == null || childOrdsResult.aggregatedValue == 0) {
            return null;
        }
        LabelAndValue[] labelValues = this.getLabelValues(childOrdsResult.q, cp.length);
        return new FacetResult(dim, path, childOrdsResult.aggregatedValue, labelValues, childOrdsResult.childCount);
    }

    private LabelAndValue[] getLabelValues(TopOrdAndIntQueue q, int pathLength) throws IOException {
        LabelAndValue[] labelValues = new LabelAndValue[q.size()];
        int[] ordinals = new int[labelValues.length];
        int[] values = new int[labelValues.length];
        for (int i = labelValues.length - 1; i >= 0; --i) {
            TopOrdAndIntQueue.OrdAndValue ordAndValue = (TopOrdAndIntQueue.OrdAndValue)q.pop();
            ordinals[i] = ordAndValue.ord;
            values[i] = ordAndValue.value;
        }
        FacetLabel[] bulkPath = this.taxoReader.getBulkPath(ordinals);
        for (int i = 0; i < labelValues.length; ++i) {
            labelValues[i] = new LabelAndValue(bulkPath[i].components[pathLength], values[i]);
        }
        return labelValues;
    }

    private ChildOrdsResult getChildOrdsResult(FacetsConfig.DimConfig dimConfig, int dimOrd, int topN) throws IOException {
        TopOrdAndIntQueue q = new TopOrdAndIntQueue(Math.min(this.taxoReader.getSize(), topN));
        int bottomValue = 0;
        int aggregatedValue = 0;
        int childCount = 0;
        TopOrdAndIntQueue.OrdAndValue reuse = null;
        if (this.sparseValues != null) {
            for (IntIntCursor c : this.sparseValues) {
                int value = c.value;
                int ord = c.key;
                if (this.parents[ord] != dimOrd || value <= 0) continue;
                aggregatedValue = this.aggregationFunction.aggregate(aggregatedValue, value);
                ++childCount;
                if (value <= bottomValue) continue;
                if (reuse == null) {
                    reuse = new TopOrdAndIntQueue.OrdAndValue();
                }
                reuse.ord = ord;
                reuse.value = value;
                reuse = (TopOrdAndIntQueue.OrdAndValue)q.insertWithOverflow(reuse);
                if (q.size() != topN) continue;
                bottomValue = ((TopOrdAndIntQueue.OrdAndValue)q.top()).value;
            }
        } else {
            int[] children = this.getChildren();
            int[] siblings = this.getSiblings();
            int ord = children[dimOrd];
            while (ord != -1) {
                int value = this.values[ord];
                if (value > 0) {
                    aggregatedValue = this.aggregationFunction.aggregate(aggregatedValue, value);
                    ++childCount;
                    if (value > bottomValue) {
                        if (reuse == null) {
                            reuse = new TopOrdAndIntQueue.OrdAndValue();
                        }
                        reuse.ord = ord;
                        reuse.value = value;
                        reuse = (TopOrdAndIntQueue.OrdAndValue)q.insertWithOverflow(reuse);
                        if (q.size() == topN) {
                            bottomValue = ((TopOrdAndIntQueue.OrdAndValue)q.top()).value;
                        }
                    }
                }
                ord = siblings[ord];
            }
        }
        if (dimConfig.multiValued) {
            aggregatedValue = dimConfig.requireDimCount ? this.getValue(dimOrd) : -1;
        }
        return new ChildOrdsResult(aggregatedValue, childCount, q);
    }

    private int getDimValue(FacetsConfig.DimConfig dimConfig, String dim, int dimOrd, int topN, HashMap<String, ChildOrdsResult> dimToChildOrdsResult) throws IOException {
        if (dimConfig.hierarchical || dimConfig.multiValued && dimConfig.requireDimCount) {
            return this.getValue(dimOrd);
        }
        ChildOrdsResult childOrdsResult = this.getChildOrdsResult(dimConfig, dimOrd, topN);
        dimToChildOrdsResult.put(dim, childOrdsResult);
        return childOrdsResult.aggregatedValue;
    }

    @Override
    public List<FacetResult> getTopDims(int topNDims, int topNChildren) throws IOException {
        if (topNDims <= 0 || topNChildren <= 0) {
            throw new IllegalArgumentException("topN must be > 0");
        }
        int[] children = this.getChildren();
        int[] siblings = this.getSiblings();
        PriorityQueue<DimValueResult> pq = new PriorityQueue<DimValueResult>(topNDims){

            protected boolean lessThan(DimValueResult a, DimValueResult b) {
                if (a.value > b.value) {
                    return false;
                }
                if (a.value < b.value) {
                    return true;
                }
                return a.dim.compareTo(b.dim) > 0;
            }
        };
        HashMap<String, ChildOrdsResult> dimToChildOrdsResult = new HashMap<String, ChildOrdsResult>();
        int ord = children[0];
        while (ord != -1) {
            int dimCount;
            FacetLabel cp;
            int dimOrd;
            String dim = this.taxoReader.getPath((int)ord).components[0];
            FacetsConfig.DimConfig dimConfig = this.config.getDimConfig(dim);
            if (dimConfig.indexFieldName.equals(this.indexFieldName) && (dimOrd = this.taxoReader.getOrdinal(cp = new FacetLabel(dim, emptyPath))) != -1 && (dimCount = this.getDimValue(dimConfig, dim, dimOrd, topNChildren, dimToChildOrdsResult)) != 0) {
                if (pq.size() < topNDims) {
                    pq.add((Object)new DimValueResult(dim, dimOrd, dimCount));
                } else if (dimCount > ((DimValueResult)pq.top()).value || dimCount == ((DimValueResult)pq.top()).value && dim.compareTo(((DimValueResult)pq.top()).dim) < 0) {
                    DimValueResult bottomDim = (DimValueResult)pq.top();
                    bottomDim.dim = dim;
                    bottomDim.value = dimCount;
                    pq.updateTop();
                }
            }
            ord = siblings[ord];
        }
        FacetResult[] results = new FacetResult[pq.size()];
        while (pq.size() > 0) {
            FacetResult facetResult;
            ChildOrdsResult childOrdsResult;
            DimValueResult dimValueResult = (DimValueResult)pq.pop();
            String dim = dimValueResult.dim;
            if (dimToChildOrdsResult.containsKey(dim)) {
                childOrdsResult = (ChildOrdsResult)dimToChildOrdsResult.get(dim);
            } else {
                FacetsConfig.DimConfig dimConfig = this.config.getDimConfig(dim);
                childOrdsResult = this.getChildOrdsResult(dimConfig, dimValueResult.dimOrd, topNChildren);
            }
            results[pq.size()] = facetResult = new FacetResult(dimValueResult.dim, emptyPath, dimValueResult.value, this.getLabelValues(childOrdsResult.q, 1), childOrdsResult.childCount);
        }
        return Arrays.asList(results);
    }

    private static class ChildOrdsResult {
        final int aggregatedValue;
        final int childCount;
        final TopOrdAndIntQueue q;

        ChildOrdsResult(int aggregatedValue, int childCount, TopOrdAndIntQueue q) {
            this.aggregatedValue = aggregatedValue;
            this.childCount = childCount;
            this.q = q;
        }
    }

    private static class DimValueResult {
        String dim;
        int dimOrd;
        int value;

        DimValueResult(String dim, int dimOrd, int value) {
            this.dim = dim;
            this.dimOrd = dimOrd;
            this.value = value;
        }
    }
}

