/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.taxonomy;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.LabelAndValue;
import org.apache.lucene.facet.TopOrdAndFloatQueue;
import org.apache.lucene.facet.taxonomy.AssociationAggregationFunction;
import org.apache.lucene.facet.taxonomy.FacetLabel;
import org.apache.lucene.facet.taxonomy.TaxonomyFacets;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.util.PriorityQueue;

@Deprecated
public abstract class FloatTaxonomyFacets
extends TaxonomyFacets {
    protected final AssociationAggregationFunction aggregationFunction;
    protected final float[] values;
    private static final String[] emptyPath = new String[0];

    protected FloatTaxonomyFacets(String indexFieldName, TaxonomyReader taxoReader, FacetsConfig config) throws IOException {
        super(indexFieldName, taxoReader, config);
        this.aggregationFunction = AssociationAggregationFunction.SUM;
        this.values = new float[taxoReader.getSize()];
    }

    protected FloatTaxonomyFacets(String indexFieldName, TaxonomyReader taxoReader, AssociationAggregationFunction aggregationFunction, FacetsConfig config) throws IOException {
        super(indexFieldName, taxoReader, config);
        this.aggregationFunction = aggregationFunction;
        this.values = new float[taxoReader.getSize()];
    }

    protected void rollup() throws IOException {
        int[] children = this.getChildren();
        for (Map.Entry<String, FacetsConfig.DimConfig> ent : this.config.getDimConfigs().entrySet()) {
            float newValue;
            String dim = ent.getKey();
            FacetsConfig.DimConfig ft = ent.getValue();
            if (!ft.hierarchical || ft.multiValued) continue;
            int dimRootOrd = this.taxoReader.getOrdinal(new FacetLabel(dim));
            assert (dimRootOrd > 0);
            this.values[dimRootOrd] = newValue = this.aggregationFunction.aggregate(this.values[dimRootOrd], this.rollup(children[dimRootOrd]));
        }
    }

    private float rollup(int ord) throws IOException {
        int[] children = this.getChildren();
        int[] siblings = this.getSiblings();
        float aggregationValue = 0.0f;
        while (ord != -1) {
            float childValue;
            this.values[ord] = childValue = this.aggregationFunction.aggregate(this.values[ord], this.rollup(children[ord]));
            aggregationValue = this.aggregationFunction.aggregate(aggregationValue, childValue);
            ord = siblings[ord];
        }
        return aggregationValue;
    }

    @Override
    public Number getSpecificValue(String dim, String ... path) throws IOException {
        FacetsConfig.DimConfig dimConfig = this.verifyDim(dim);
        if (!(path.length != 0 || dimConfig.hierarchical && !dimConfig.multiValued || dimConfig.requireDimCount && dimConfig.multiValued)) {
            throw new IllegalArgumentException("cannot return dimension-level value alone; use getTopChildren instead");
        }
        int ord = this.taxoReader.getOrdinal(new FacetLabel(dim, path));
        if (ord < 0) {
            return -1;
        }
        return Float.valueOf(this.values[ord]);
    }

    @Override
    public FacetResult getTopChildren(int topN, String dim, String ... path) throws IOException {
        FloatTaxonomyFacets.validateTopN(topN);
        FacetsConfig.DimConfig dimConfig = this.verifyDim(dim);
        FacetLabel cp = new FacetLabel(dim, path);
        int dimOrd = this.taxoReader.getOrdinal(cp);
        if (dimOrd == -1) {
            return null;
        }
        ChildOrdsResult childOrdsResult = this.getChildOrdsResult(dimConfig, dimOrd, topN);
        if (childOrdsResult.aggregatedValue == 0.0f) {
            return null;
        }
        LabelAndValue[] labelValues = this.getLabelValues(childOrdsResult.q, cp.length);
        return new FacetResult(dim, path, Float.valueOf(childOrdsResult.aggregatedValue), labelValues, childOrdsResult.childCount);
    }

    private ChildOrdsResult getChildOrdsResult(FacetsConfig.DimConfig dimConfig, int dimOrd, int topN) throws IOException {
        TopOrdAndFloatQueue q = new TopOrdAndFloatQueue(Math.min(this.taxoReader.getSize(), topN));
        float bottomValue = 0.0f;
        int[] children = this.getChildren();
        int[] siblings = this.getSiblings();
        int ord = children[dimOrd];
        float aggregatedValue = 0.0f;
        int childCount = 0;
        TopOrdAndFloatQueue.OrdAndValue reuse = null;
        while (ord != -1) {
            if (this.values[ord] > 0.0f) {
                aggregatedValue = this.aggregationFunction.aggregate(aggregatedValue, this.values[ord]);
                ++childCount;
                if (this.values[ord] > bottomValue) {
                    if (reuse == null) {
                        reuse = new TopOrdAndFloatQueue.OrdAndValue();
                    }
                    reuse.ord = ord;
                    reuse.value = this.values[ord];
                    reuse = (TopOrdAndFloatQueue.OrdAndValue)q.insertWithOverflow(reuse);
                    if (q.size() == topN) {
                        bottomValue = ((TopOrdAndFloatQueue.OrdAndValue)q.top()).value;
                    }
                }
            }
            ord = siblings[ord];
        }
        if (dimConfig.multiValued) {
            aggregatedValue = dimConfig.requireDimCount ? this.values[dimOrd] : -1.0f;
        }
        return new ChildOrdsResult(aggregatedValue, childCount, q);
    }

    private LabelAndValue[] getLabelValues(TopOrdAndFloatQueue q, int pathLength) throws IOException {
        LabelAndValue[] labelValues = new LabelAndValue[q.size()];
        int[] ordinals = new int[labelValues.length];
        float[] values = new float[labelValues.length];
        for (int i = labelValues.length - 1; i >= 0; --i) {
            TopOrdAndFloatQueue.OrdAndValue ordAndValue = (TopOrdAndFloatQueue.OrdAndValue)q.pop();
            ordinals[i] = ordAndValue.ord;
            values[i] = ordAndValue.value;
        }
        FacetLabel[] bulkPath = this.taxoReader.getBulkPath(ordinals);
        for (int i = 0; i < labelValues.length; ++i) {
            labelValues[i] = new LabelAndValue(bulkPath[i].components[pathLength], Float.valueOf(values[i]));
        }
        return labelValues;
    }

    private float getDimValue(FacetsConfig.DimConfig dimConfig, String dim, int dimOrd, int topN, HashMap<String, ChildOrdsResult> dimToChildOrdsResult) throws IOException {
        if (dimConfig.hierarchical || dimConfig.multiValued && dimConfig.requireDimCount) {
            return this.values[dimOrd];
        }
        ChildOrdsResult childOrdsResult = this.getChildOrdsResult(dimConfig, dimOrd, topN);
        dimToChildOrdsResult.put(dim, childOrdsResult);
        return childOrdsResult.aggregatedValue;
    }

    @Override
    public List<FacetResult> getTopDims(int topNDims, int topNChildren) throws IOException {
        FloatTaxonomyFacets.validateTopN(topNDims);
        FloatTaxonomyFacets.validateTopN(topNChildren);
        int[] children = this.getChildren();
        int[] siblings = this.getSiblings();
        PriorityQueue<DimValueResult> pq = new PriorityQueue<DimValueResult>(topNDims){

            protected boolean lessThan(DimValueResult a, DimValueResult b) {
                if (a.value > b.value) {
                    return false;
                }
                if (a.value < b.value) {
                    return true;
                }
                return a.dim.compareTo(b.dim) > 0;
            }
        };
        HashMap<String, ChildOrdsResult> dimToChildOrdsResult = new HashMap<String, ChildOrdsResult>();
        int ord = children[0];
        while (ord != -1) {
            String dim = this.taxoReader.getPath((int)ord).components[0];
            FacetsConfig.DimConfig dimConfig = this.config.getDimConfig(dim);
            if (dimConfig.indexFieldName.equals(this.indexFieldName)) {
                FacetLabel cp = new FacetLabel(dim, emptyPath);
                int dimOrd = this.taxoReader.getOrdinal(cp);
                float dimCount = 0.0f;
                if (dimOrd != -1 && (dimCount = this.getDimValue(dimConfig, dim, dimOrd, topNChildren, dimToChildOrdsResult)) != 0.0f) {
                    if (pq.size() < topNDims) {
                        pq.add((Object)new DimValueResult(dim, dimOrd, dimCount));
                    } else if (dimCount > ((DimValueResult)pq.top()).value || dimCount == ((DimValueResult)pq.top()).value && dim.compareTo(((DimValueResult)pq.top()).dim) < 0) {
                        DimValueResult bottomDim = (DimValueResult)pq.top();
                        bottomDim.dim = dim;
                        bottomDim.value = dimCount;
                        pq.updateTop();
                    }
                }
            }
            ord = siblings[ord];
        }
        FacetResult[] results = new FacetResult[pq.size()];
        while (pq.size() > 0) {
            FacetResult facetResult;
            ChildOrdsResult childOrdsResult;
            DimValueResult dimValueResult = (DimValueResult)pq.pop();
            String dim = dimValueResult.dim;
            if (dimToChildOrdsResult.containsKey(dim)) {
                childOrdsResult = (ChildOrdsResult)dimToChildOrdsResult.get(dim);
            } else {
                FacetsConfig.DimConfig dimConfig = this.config.getDimConfig(dim);
                childOrdsResult = this.getChildOrdsResult(dimConfig, dimValueResult.dimOrd, topNChildren);
            }
            results[pq.size()] = facetResult = new FacetResult(dimValueResult.dim, emptyPath, Float.valueOf(dimValueResult.value), this.getLabelValues(childOrdsResult.q, 1), childOrdsResult.childCount);
        }
        return Arrays.asList(results);
    }

    private static class ChildOrdsResult {
        final float aggregatedValue;
        final int childCount;
        final TopOrdAndFloatQueue q;

        ChildOrdsResult(float aggregatedValue, int childCount, TopOrdAndFloatQueue q) {
            this.aggregatedValue = aggregatedValue;
            this.childCount = childCount;
            this.q = q;
        }
    }

    private static class DimValueResult {
        String dim;
        int dimOrd;
        float value;

        DimValueResult(String dim, int dimOrd, float value) {
            this.dim = dim;
            this.dimOrd = dimOrd;
            this.value = value;
        }
    }
}

