/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.sortedset;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.PrimitiveIterator;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.FacetUtils;
import org.apache.lucene.facet.Facets;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.LabelAndValue;
import org.apache.lucene.facet.TopOrdAndIntQueue;
import org.apache.lucene.facet.sortedset.SortedSetDocValuesReaderState;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.ConjunctionUtils;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.PriorityQueue;

public class SortedSetDocValuesFacetCounts
extends Facets {
    final SortedSetDocValuesReaderState state;
    final FacetsConfig stateConfig;
    final SortedSetDocValues dv;
    final String field;
    final int[] counts;
    private static final String[] emptyPath = new String[0];

    public SortedSetDocValuesFacetCounts(SortedSetDocValuesReaderState state) throws IOException {
        this(state, null);
    }

    public SortedSetDocValuesFacetCounts(SortedSetDocValuesReaderState state, FacetsCollector hits) throws IOException {
        this.state = state;
        this.field = state.getField();
        this.stateConfig = Objects.requireNonNullElse(state.getFacetsConfig(), new FacetsConfig());
        this.dv = state.getDocValues();
        this.counts = new int[state.getSize()];
        if (hits == null) {
            this.countAll();
        } else {
            this.count(hits.getMatchingDocs());
        }
    }

    @Override
    public FacetResult getTopChildren(int topN, String dim, String ... path) throws IOException {
        SortedSetDocValuesFacetCounts.validateTopN(topN);
        FacetsConfig.DimConfig dimConfig = this.stateConfig.getDimConfig(dim);
        if (dimConfig.hierarchical) {
            int pathOrd = (int)this.dv.lookupTerm(new BytesRef((CharSequence)FacetsConfig.pathToString(dim, path)));
            if (pathOrd < 0) {
                return null;
            }
            SortedSetDocValuesReaderState.DimTree dimTree = this.state.getDimTree(dim);
            return this.getPathResult(dimConfig, dim, path, pathOrd, dimTree.iterator(pathOrd), topN);
        }
        if (path.length > 0) {
            throw new IllegalArgumentException("Field is not configured as hierarchical, path should be 0 length");
        }
        SortedSetDocValuesReaderState.OrdRange ordRange = this.state.getOrdRange(dim);
        if (ordRange == null) {
            return null;
        }
        int dimOrd = ordRange.start;
        PrimitiveIterator.OfInt childIt = ordRange.iterator();
        if (dimConfig.multiValued && dimConfig.requireDimCount) {
            childIt.next();
        }
        return this.getPathResult(dimConfig, dim, null, dimOrd, childIt, topN);
    }

    private FacetResult getPathResult(FacetsConfig.DimConfig dimConfig, String dim, String[] path, int pathOrd, PrimitiveIterator.OfInt childOrds, int topN) throws IOException {
        return this.getPathResult(dimConfig, dim, path, pathOrd, childOrds, topN, null);
    }

    private FacetResult getPathResult(FacetsConfig.DimConfig dimConfig, String dim, String[] path, int pathOrd, PrimitiveIterator.OfInt childOrds, int topN, ChildOrdsResult dimToChildOrdsResult) throws IOException {
        ChildOrdsResult childOrdsResult = dimToChildOrdsResult != null ? dimToChildOrdsResult : this.getChildOrdsResult(childOrds, topN, dimConfig, pathOrd);
        if (childOrdsResult.q == null) {
            return null;
        }
        LabelAndValue[] labelValues = this.getLabelValuesFromTopOrdAndIntQueue(childOrdsResult.q);
        if (dimConfig.hierarchical) {
            return new FacetResult(dim, path, childOrdsResult.dimCount, labelValues, childOrdsResult.childCount);
        }
        return new FacetResult(dim, emptyPath, childOrdsResult.dimCount, labelValues, childOrdsResult.childCount);
    }

    private ChildOrdsResult getChildOrdsResult(PrimitiveIterator.OfInt childOrds, int topN, FacetsConfig.DimConfig dimConfig, int pathOrd) {
        TopOrdAndIntQueue q = null;
        int bottomCount = 0;
        int dimCount = 0;
        int childCount = 0;
        TopOrdAndIntQueue.OrdAndValue reuse = null;
        while (childOrds.hasNext()) {
            int ord = childOrds.next();
            if (this.counts[ord] <= 0) continue;
            dimCount += this.counts[ord];
            ++childCount;
            if (this.counts[ord] <= bottomCount) continue;
            if (reuse == null) {
                reuse = new TopOrdAndIntQueue.OrdAndValue();
            }
            reuse.ord = ord;
            reuse.value = this.counts[ord];
            if (q == null) {
                q = new TopOrdAndIntQueue(topN);
            }
            reuse = (TopOrdAndIntQueue.OrdAndValue)q.insertWithOverflow(reuse);
            if (q.size() != topN) continue;
            bottomCount = ((TopOrdAndIntQueue.OrdAndValue)q.top()).value;
        }
        if (dimConfig.hierarchical) {
            dimCount = this.counts[pathOrd];
        } else if (dimConfig.multiValued) {
            dimCount = dimConfig.requireDimCount ? this.counts[pathOrd] : -1;
        }
        return new ChildOrdsResult(dimCount, childCount, q);
    }

    private LabelAndValue[] getLabelValuesFromTopOrdAndIntQueue(TopOrdAndIntQueue q) throws IOException {
        LabelAndValue[] labelValues = new LabelAndValue[q.size()];
        for (int i = labelValues.length - 1; i >= 0; --i) {
            TopOrdAndIntQueue.OrdAndValue ordAndValue = (TopOrdAndIntQueue.OrdAndValue)q.pop();
            assert (ordAndValue != null);
            BytesRef term = this.dv.lookupOrd((long)ordAndValue.ord);
            String[] parts = FacetsConfig.stringToPath(term.utf8ToString());
            labelValues[i] = new LabelAndValue(parts[parts.length - 1], ordAndValue.value);
        }
        return labelValues;
    }

    private int getDimValue(FacetsConfig.DimConfig dimConfig, String dim, int dimOrd, PrimitiveIterator.OfInt childOrds, int topN, HashMap<String, ChildOrdsResult> dimToChildOrdsResult) {
        if (dimConfig.hierarchical || dimConfig.multiValued && dimConfig.requireDimCount) {
            return this.counts[dimOrd];
        }
        ChildOrdsResult childOrdsResult = this.getChildOrdsResult(childOrds, topN, dimConfig, dimOrd);
        dimToChildOrdsResult.put(dim, childOrdsResult);
        return childOrdsResult.dimCount;
    }

    private void countOneSegmentNHLD(OrdinalMap ordinalMap, LeafReader reader, int segOrd) throws IOException {
        SortedSetDocValues multiValues = DocValues.getSortedSet((LeafReader)reader, (String)this.field);
        if (multiValues == null) {
            return;
        }
        SortedDocValues singleValues = DocValues.unwrapSingleton((SortedSetDocValues)multiValues);
        if (ordinalMap != null) {
            int doc;
            LongValues ordMap = ordinalMap.getGlobalOrds(segOrd);
            int numSegOrds = (int)multiValues.getValueCount();
            int[] segCounts = new int[numSegOrds];
            if (singleValues != null) {
                doc = singleValues.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    int n = singleValues.ordValue();
                    segCounts[n] = segCounts[n] + 1;
                    doc = singleValues.nextDoc();
                }
            } else {
                doc = multiValues.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    int term = (int)multiValues.nextOrd();
                    while ((long)term != -1L) {
                        int n = term;
                        segCounts[n] = segCounts[n] + 1;
                        term = (int)multiValues.nextOrd();
                    }
                    doc = multiValues.nextDoc();
                }
            }
            for (int ord = 0; ord < numSegOrds; ++ord) {
                int count = segCounts[ord];
                if (count == 0) continue;
                int n = (int)ordMap.get((long)ord);
                this.counts[n] = this.counts[n] + count;
            }
        } else if (singleValues != null) {
            int doc = singleValues.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                int n = singleValues.ordValue();
                this.counts[n] = this.counts[n] + 1;
                doc = singleValues.nextDoc();
            }
        } else {
            int doc = multiValues.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                int term = (int)multiValues.nextOrd();
                while ((long)term != -1L) {
                    int n = term;
                    this.counts[n] = this.counts[n] + 1;
                    term = (int)multiValues.nextOrd();
                }
                doc = multiValues.nextDoc();
            }
        }
    }

    private void countOneSegment(OrdinalMap ordinalMap, LeafReader reader, int segOrd, FacetsCollector.MatchingDocs hits, Bits liveDocs) throws IOException {
        DocIdSetIterator it;
        SortedDocValues valuesIt;
        SortedSetDocValues multiValues = DocValues.getSortedSet((LeafReader)reader, (String)this.field);
        if (multiValues == null) {
            return;
        }
        SortedDocValues singleValues = DocValues.unwrapSingleton((SortedSetDocValues)multiValues);
        Object object = valuesIt = singleValues != null ? singleValues : multiValues;
        if (hits == null) {
            assert (liveDocs != null);
            it = FacetUtils.liveDocsDISI((DocIdSetIterator)valuesIt, liveDocs);
        } else {
            it = ConjunctionUtils.intersectIterators(Arrays.asList(hits.bits.iterator(), valuesIt));
        }
        if (ordinalMap != null) {
            LongValues ordMap = ordinalMap.getGlobalOrds(segOrd);
            int numSegOrds = (int)multiValues.getValueCount();
            if (hits != null && hits.totalHits < numSegOrds / 10) {
                if (singleValues != null) {
                    int doc = it.nextDoc();
                    while (doc != Integer.MAX_VALUE) {
                        int n = (int)ordMap.get((long)singleValues.ordValue());
                        this.counts[n] = this.counts[n] + 1;
                        doc = it.nextDoc();
                    }
                } else {
                    int doc = it.nextDoc();
                    while (doc != Integer.MAX_VALUE) {
                        int term = (int)multiValues.nextOrd();
                        while ((long)term != -1L) {
                            int n = (int)ordMap.get((long)term);
                            this.counts[n] = this.counts[n] + 1;
                            term = (int)multiValues.nextOrd();
                        }
                        doc = it.nextDoc();
                    }
                }
            } else {
                int doc;
                int[] segCounts = new int[numSegOrds];
                if (singleValues != null) {
                    doc = it.nextDoc();
                    while (doc != Integer.MAX_VALUE) {
                        int n = singleValues.ordValue();
                        segCounts[n] = segCounts[n] + 1;
                        doc = it.nextDoc();
                    }
                } else {
                    doc = it.nextDoc();
                    while (doc != Integer.MAX_VALUE) {
                        int term = (int)multiValues.nextOrd();
                        while ((long)term != -1L) {
                            int n = term;
                            segCounts[n] = segCounts[n] + 1;
                            term = (int)multiValues.nextOrd();
                        }
                        doc = it.nextDoc();
                    }
                }
                for (int ord = 0; ord < numSegOrds; ++ord) {
                    int count = segCounts[ord];
                    if (count == 0) continue;
                    int n = (int)ordMap.get((long)ord);
                    this.counts[n] = this.counts[n] + count;
                }
            }
        } else if (singleValues != null) {
            int doc = it.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                int n = singleValues.ordValue();
                this.counts[n] = this.counts[n] + 1;
                doc = it.nextDoc();
            }
        } else {
            int doc = it.nextDoc();
            while (doc != Integer.MAX_VALUE) {
                int term = (int)multiValues.nextOrd();
                while ((long)term != -1L) {
                    int n = term;
                    this.counts[n] = this.counts[n] + 1;
                    term = (int)multiValues.nextOrd();
                }
                doc = it.nextDoc();
            }
        }
    }

    private void count(List<FacetsCollector.MatchingDocs> matchingDocs) throws IOException {
        OrdinalMap ordinalMap = this.dv instanceof MultiDocValues.MultiSortedSetDocValues && matchingDocs.size() > 1 ? ((MultiDocValues.MultiSortedSetDocValues)this.dv).mapping : null;
        IndexReader reader = this.state.getReader();
        for (FacetsCollector.MatchingDocs hits : matchingDocs) {
            if (ReaderUtil.getTopLevelContext((IndexReaderContext)hits.context).reader() != reader) {
                throw new IllegalStateException("the SortedSetDocValuesReaderState provided to this class does not match the reader being searched; you must create a new SortedSetDocValuesReaderState every time you open a new IndexReader");
            }
            this.countOneSegment(ordinalMap, hits.context.reader(), hits.context.ord, hits, null);
        }
    }

    private void countAll() throws IOException {
        OrdinalMap ordinalMap = this.dv instanceof MultiDocValues.MultiSortedSetDocValues ? ((MultiDocValues.MultiSortedSetDocValues)this.dv).mapping : null;
        for (LeafReaderContext context : this.state.getReader().leaves()) {
            Bits liveDocs = context.reader().getLiveDocs();
            if (liveDocs == null) {
                this.countOneSegmentNHLD(ordinalMap, context.reader(), context.ord);
                continue;
            }
            this.countOneSegment(ordinalMap, context.reader(), context.ord, null, context.reader().getLiveDocs());
        }
    }

    @Override
    public Number getSpecificValue(String dim, String ... path) throws IOException {
        if (path.length != 1) {
            throw new IllegalArgumentException("path must be length=1");
        }
        int ord = (int)this.dv.lookupTerm(new BytesRef((CharSequence)FacetsConfig.pathToString(dim, path)));
        if (ord < 0) {
            return -1;
        }
        return this.counts[ord];
    }

    private FacetResult getFacetResultForDim(String dim, int topNChildren) throws IOException {
        return this.getFacetResultForDim(dim, topNChildren, null);
    }

    private FacetResult getFacetResultForDim(String dim, int topNChildren, ChildOrdsResult dimToChildOrdsResult) throws IOException {
        FacetsConfig.DimConfig dimConfig = this.stateConfig.getDimConfig(dim);
        if (dimConfig.hierarchical) {
            SortedSetDocValuesReaderState.DimTree dimTree = this.state.getDimTree(dim);
            int dimOrd = dimTree.dimStartOrd;
            return this.getPathResult(dimConfig, dim, emptyPath, dimOrd, dimTree.iterator(), topNChildren, dimToChildOrdsResult);
        }
        SortedSetDocValuesReaderState.OrdRange ordRange = this.state.getOrdRange(dim);
        int dimOrd = ordRange.start;
        PrimitiveIterator.OfInt childIt = ordRange.iterator();
        if (dimConfig.multiValued && dimConfig.requireDimCount) {
            childIt.next();
        }
        return this.getPathResult(dimConfig, dim, emptyPath, dimOrd, childIt, topNChildren, dimToChildOrdsResult);
    }

    @Override
    public List<FacetResult> getAllDims(int topN) throws IOException {
        SortedSetDocValuesFacetCounts.validateTopN(topN);
        ArrayList<FacetResult> results = new ArrayList<FacetResult>();
        for (String dim : this.state.getDims()) {
            FacetResult factResult = this.getFacetResultForDim(dim, topN);
            if (factResult == null) continue;
            results.add(factResult);
        }
        Collections.sort(results, new Comparator<FacetResult>(){

            @Override
            public int compare(FacetResult a, FacetResult b) {
                if (a.value.intValue() > b.value.intValue()) {
                    return -1;
                }
                if (b.value.intValue() > a.value.intValue()) {
                    return 1;
                }
                return a.dim.compareTo(b.dim);
            }
        });
        return results;
    }

    @Override
    public List<FacetResult> getTopDims(int topNDims, int topNChildren) throws IOException {
        SortedSetDocValuesFacetCounts.validateTopN(topNDims);
        SortedSetDocValuesFacetCounts.validateTopN(topNChildren);
        PriorityQueue<DimValueResult> pq = new PriorityQueue<DimValueResult>(topNDims){

            protected boolean lessThan(DimValueResult a, DimValueResult b) {
                if (a.value > b.value) {
                    return false;
                }
                if (a.value < b.value) {
                    return true;
                }
                return a.dim.compareTo(b.dim) > 0;
            }
        };
        HashMap<String, ChildOrdsResult> dimToChildOrdsResult = new HashMap<String, ChildOrdsResult>();
        for (String dim : this.state.getDims()) {
            int dimCount;
            int dimOrd;
            FacetsConfig.DimConfig dimConfig = this.stateConfig.getDimConfig(dim);
            if (dimConfig.hierarchical) {
                SortedSetDocValuesReaderState.DimTree dimTree = this.state.getDimTree(dim);
                dimOrd = dimTree.dimStartOrd;
                dimCount = this.getDimValue(dimConfig, dim, dimOrd, dimTree.iterator(), topNChildren, dimToChildOrdsResult);
            } else {
                SortedSetDocValuesReaderState.OrdRange ordRange = this.state.getOrdRange(dim);
                dimOrd = ordRange.start;
                PrimitiveIterator.OfInt childIt = ordRange.iterator();
                if (dimConfig.multiValued && dimConfig.requireDimCount) {
                    childIt.next();
                }
                dimCount = this.getDimValue(dimConfig, dim, dimOrd, childIt, topNChildren, dimToChildOrdsResult);
            }
            if (dimCount == 0) continue;
            if (pq.size() < topNDims) {
                pq.add((Object)new DimValueResult(dim, dimCount));
                continue;
            }
            if (dimCount <= ((DimValueResult)pq.top()).value && (dimCount != ((DimValueResult)pq.top()).value || dim.compareTo(((DimValueResult)pq.top()).dim) >= 0)) continue;
            DimValueResult bottomDim = (DimValueResult)pq.top();
            bottomDim.dim = dim;
            bottomDim.value = dimCount;
            pq.updateTop();
        }
        int resultSize = pq.size();
        FacetResult[] results = new FacetResult[resultSize];
        while (pq.size() > 0) {
            DimValueResult dimValueResult = (DimValueResult)pq.pop();
            FacetResult facetResult = this.getFacetResultForDim(dimValueResult.dim, topNChildren, (ChildOrdsResult)dimToChildOrdsResult.get(dimValueResult.dim));
            results[--resultSize] = facetResult;
        }
        return Arrays.asList(results);
    }

    private static class DimValueResult {
        String dim;
        int value;

        DimValueResult(String dim, int value) {
            this.dim = dim;
            this.value = value;
        }
    }

    private static class ChildOrdsResult {
        final int dimCount;
        final int childCount;
        final TopOrdAndIntQueue q;

        ChildOrdsResult(int dimCount, int childCount, TopOrdAndIntQueue q) {
            this.dimCount = dimCount;
            this.childCount = childCount;
            this.q = q;
        }
    }
}

