/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.range;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.Facets;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.LabelAndValue;
import org.apache.lucene.facet.range.LongRange;
import org.apache.lucene.facet.range.LongRangeCounter;
import org.apache.lucene.facet.range.Range;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.ConjunctionUtils;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

abstract class RangeFacetCounts
extends Facets {
    protected final Range[] ranges;
    protected final int[] counts;
    protected final Query fastMatchQuery;
    protected final String field;
    protected int totCount;

    protected RangeFacetCounts(String field, Range[] ranges, Query fastMatchQuery) throws IOException {
        this.field = field;
        this.ranges = ranges;
        this.fastMatchQuery = fastMatchQuery;
        this.counts = new int[ranges.length];
    }

    protected DocIdSetIterator createIterator(FacetsCollector.MatchingDocs hits) throws IOException {
        if (this.fastMatchQuery != null) {
            IndexReaderContext topLevelContext = ReaderUtil.getTopLevelContext((IndexReaderContext)hits.context);
            IndexSearcher searcher = new IndexSearcher(topLevelContext);
            searcher.setQueryCache(null);
            Weight fastMatchWeight = searcher.createWeight(searcher.rewrite(this.fastMatchQuery), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
            Scorer s = fastMatchWeight.scorer(hits.context);
            if (s == null) {
                return null;
            }
            DocIdSetIterator fastMatchDocs = s.iterator();
            return ConjunctionUtils.intersectIterators(Arrays.asList(hits.bits.iterator(), fastMatchDocs));
        }
        return hits.bits.iterator();
    }

    protected abstract LongRange[] getLongRanges();

    protected long mapDocValue(long l) {
        return l;
    }

    protected void count(String field, List<FacetsCollector.MatchingDocs> matchingDocs) throws IOException {
        SortedNumericDocValues[] multiValuedDocVals = new SortedNumericDocValues[matchingDocs.size()];
        NumericDocValues[] singleValuedDocVals = null;
        boolean foundMultiValued = false;
        for (int i = 0; i < matchingDocs.size(); ++i) {
            SortedNumericDocValues multiValues;
            FacetsCollector.MatchingDocs hits = matchingDocs.get(i);
            multiValuedDocVals[i] = multiValues = DocValues.getSortedNumeric((LeafReader)hits.context.reader(), (String)field);
            if (foundMultiValued) continue;
            NumericDocValues singleValues = DocValues.unwrapSingleton((SortedNumericDocValues)multiValues);
            if (singleValues != null) {
                if (singleValuedDocVals == null) {
                    singleValuedDocVals = new NumericDocValues[matchingDocs.size()];
                }
                singleValuedDocVals[i] = singleValues;
                continue;
            }
            foundMultiValued = true;
        }
        if (foundMultiValued) {
            singleValuedDocVals = null;
        } else {
            multiValuedDocVals = null;
        }
        LongRangeCounter counter = LongRangeCounter.create(this.getLongRanges(), this.counts);
        int missingCount = 0;
        if (!foundMultiValued) {
            for (int i = 0; i < matchingDocs.size(); ++i) {
                FacetsCollector.MatchingDocs hits = matchingDocs.get(i);
                DocIdSetIterator it = this.createIterator(hits);
                if (it == null) continue;
                assert (singleValuedDocVals != null);
                NumericDocValues singleValues = singleValuedDocVals[i];
                this.totCount += hits.totalHits;
                int doc = it.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    if (singleValues.advanceExact(doc)) {
                        counter.addSingleValued(this.mapDocValue(singleValues.longValue()));
                    } else {
                        ++missingCount;
                    }
                    doc = it.nextDoc();
                }
            }
        } else {
            for (int i = 0; i < matchingDocs.size(); ++i) {
                DocIdSetIterator it = this.createIterator(matchingDocs.get(i));
                if (it == null) continue;
                SortedNumericDocValues multiValues = multiValuedDocVals[i];
                int doc = it.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    if (multiValues.advanceExact(doc)) {
                        int limit = multiValues.docValueCount();
                        if (limit == 1) {
                            counter.addSingleValued(this.mapDocValue(multiValues.nextValue()));
                            ++this.totCount;
                        } else {
                            counter.startMultiValuedDoc();
                            long previous = 0L;
                            for (int j = 0; j < limit; ++j) {
                                long val = this.mapDocValue(multiValues.nextValue());
                                if (j != 0 && val == previous) continue;
                                counter.addMultiValued(val);
                                previous = val;
                            }
                            if (counter.endMultiValuedDoc()) {
                                ++this.totCount;
                            }
                        }
                    }
                    doc = it.nextDoc();
                }
            }
        }
        this.totCount -= (missingCount += counter.finish());
    }

    @Override
    public FacetResult getTopChildren(int topN, String dim, String ... path) {
        RangeFacetCounts.validateTopN(topN);
        if (!dim.equals(this.field)) {
            throw new IllegalArgumentException("invalid dim \"" + dim + "\"; should be \"" + this.field + "\"");
        }
        if (path.length != 0) {
            throw new IllegalArgumentException("path.length should be 0");
        }
        LabelAndValue[] labelValues = new LabelAndValue[this.counts.length];
        for (int i = 0; i < this.counts.length; ++i) {
            labelValues[i] = new LabelAndValue(this.ranges[i].label, this.counts[i]);
        }
        return new FacetResult(dim, path, this.totCount, labelValues, labelValues.length);
    }

    @Override
    public Number getSpecificValue(String dim, String ... path) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<FacetResult> getAllDims(int topN) throws IOException {
        RangeFacetCounts.validateTopN(topN);
        return Collections.singletonList(this.getTopChildren(topN, this.field, new String[0]));
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RangeFacetCounts totCount=");
        b.append(this.totCount);
        b.append(":\n");
        for (int i = 0; i < this.ranges.length; ++i) {
            b.append("  ");
            b.append(this.ranges[i].label);
            b.append(" -> count=");
            b.append(this.counts[i]);
            b.append('\n');
        }
        return b.toString();
    }
}

